/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.performer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.task.FastCompactionPerformerSubTask;
import org.apache.iotdb.db.engine.compaction.inner.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.engine.compaction.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.performer.ISeqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.performer.IUnseqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.task.SubCompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.compaction.writer.FastCrossCompactionWriter;
import org.apache.iotdb.db.engine.compaction.writer.FastInnerCompactionWriter;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastCompactionPerformer
implements ICrossCompactionPerformer,
ISeqCompactionPerformer,
IUnseqCompactionPerformer {
    private final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private List<TsFileResource> seqFiles = Collections.emptyList();
    private List<TsFileResource> unseqFiles = Collections.emptyList();
    private List<TsFileResource> sortedSourceFiles = new ArrayList<TsFileResource>();
    private static final int subTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();
    public Map<TsFileResource, TsFileSequenceReader> readerCacheMap = new ConcurrentHashMap<TsFileResource, TsFileSequenceReader>();
    private CompactionTaskSummary summary;
    private final SubCompactionTaskSummary subTaskSummary = new SubCompactionTaskSummary();
    private List<TsFileResource> targetFiles;
    public Map<TsFileResource, List<Modification>> modificationCache = new ConcurrentHashMap<TsFileResource, List<Modification>>();
    private boolean isCrossCompaction;

    public FastCompactionPerformer(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, List<TsFileResource> targetFiles) {
        this.seqFiles = seqFiles;
        this.unseqFiles = unseqFiles;
        this.targetFiles = targetFiles;
        this.isCrossCompaction = !seqFiles.isEmpty() && !unseqFiles.isEmpty();
    }

    public FastCompactionPerformer(boolean isCrossCompaction) {
        this.isCrossCompaction = isCrossCompaction;
    }

    @Override
    public void perform() throws IOException, MetadataException, StorageEngineException, InterruptedException {
        try (MultiTsFileDeviceIterator deviceIterator = new MultiTsFileDeviceIterator(this.seqFiles, this.unseqFiles, this.readerCacheMap);
             AbstractCompactionWriter compactionWriter = this.isCrossCompaction ? new FastCrossCompactionWriter(this.targetFiles, this.seqFiles) : new FastInnerCompactionWriter(this.targetFiles.get(0));){
            while (deviceIterator.hasNextDevice()) {
                this.checkThreadInterrupted();
                Pair<String, Boolean> deviceInfo = deviceIterator.nextDevice();
                String device = (String)deviceInfo.left;
                boolean isAligned = (Boolean)deviceInfo.right;
                this.sortedSourceFiles.addAll(this.seqFiles);
                this.sortedSourceFiles.addAll(this.unseqFiles);
                this.sortedSourceFiles.removeIf(x -> !x.mayContainsDevice(device));
                this.sortedSourceFiles.sort(Comparator.comparingLong(x -> x.getStartTime(device)));
                compactionWriter.startChunkGroup(device, isAligned);
                if (isAligned) {
                    this.compactAlignedSeries(device, deviceIterator, compactionWriter);
                } else {
                    this.compactNonAlignedSeries(device, deviceIterator, compactionWriter);
                }
                compactionWriter.endChunkGroup();
                compactionWriter.checkAndMayFlushChunkMetadata();
                this.sortedSourceFiles.clear();
            }
            compactionWriter.endFile();
            CompactionUtils.updatePlanIndexes(this.targetFiles, this.seqFiles, this.unseqFiles);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.sortedSourceFiles = null;
            this.readerCacheMap = null;
            this.modificationCache = null;
        }
    }

    private void compactAlignedSeries(String deviceId, MultiTsFileDeviceIterator deviceIterator, AbstractCompactionWriter fastCrossCompactionWriter) throws PageException, IOException, WriteProcessException, IllegalPathException {
        HashMap<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap = new HashMap<String, Map<TsFileResource, Pair<Long, Long>>>();
        ArrayList<IMeasurementSchema> measurementSchemas = new ArrayList<IMeasurementSchema>();
        for (Map.Entry<String, Pair<MeasurementSchema, Map<TsFileResource, Pair<Long, Long>>>> entry : deviceIterator.getTimeseriesSchemaAndMetadataOffsetOfCurrentDevice().entrySet()) {
            if (!entry.getKey().equals("")) {
                measurementSchemas.add((IMeasurementSchema)entry.getValue().left);
            }
            timeseriesMetadataOffsetMap.put(entry.getKey(), (Map)entry.getValue().right);
        }
        SubCompactionTaskSummary taskSummary = new SubCompactionTaskSummary();
        new FastCompactionPerformerSubTask(fastCrossCompactionWriter, timeseriesMetadataOffsetMap, this.readerCacheMap, this.modificationCache, this.sortedSourceFiles, measurementSchemas, deviceId, taskSummary).call();
        this.subTaskSummary.increase(taskSummary);
    }

    private void compactNonAlignedSeries(String deviceID, MultiTsFileDeviceIterator deviceIterator, AbstractCompactionWriter fastCrossCompactionWriter) throws IOException, InterruptedException {
        int i;
        Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap = deviceIterator.getTimeseriesMetadataOffsetOfCurrentDevice();
        ArrayList<String> allMeasurements = new ArrayList<String>(timeseriesMetadataOffsetMap.keySet());
        int subTaskNums = Math.min(allMeasurements.size(), subTaskNum);
        ArrayList[] measurementsForEachSubTask = new ArrayList[subTaskNums];
        for (int idx = 0; idx < allMeasurements.size(); ++idx) {
            if (measurementsForEachSubTask[idx % subTaskNums] == null) {
                measurementsForEachSubTask[idx % subTaskNums] = new ArrayList();
            }
            measurementsForEachSubTask[idx % subTaskNums].add((String)allMeasurements.get(idx));
        }
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ArrayList<SubCompactionTaskSummary> taskSummaryList = new ArrayList<SubCompactionTaskSummary>();
        for (i = 0; i < subTaskNums; ++i) {
            SubCompactionTaskSummary taskSummary = new SubCompactionTaskSummary();
            futures.add(CompactionTaskManager.getInstance().submitSubTask(new FastCompactionPerformerSubTask(fastCrossCompactionWriter, timeseriesMetadataOffsetMap, this.readerCacheMap, this.modificationCache, this.sortedSourceFiles, measurementsForEachSubTask[i], deviceID, taskSummary, i)));
            taskSummaryList.add(taskSummary);
        }
        for (i = 0; i < subTaskNums; ++i) {
            try {
                ((Future)futures.get(i)).get();
                this.subTaskSummary.increase((SubCompactionTaskSummary)taskSummaryList.get(i));
                continue;
            }
            catch (ExecutionException e) {
                this.LOGGER.error("[Compaction] SubCompactionTask meet errors ", (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    @Override
    public void setTargetFiles(List<TsFileResource> targetFiles) {
        this.targetFiles = targetFiles;
    }

    @Override
    public void setSummary(CompactionTaskSummary summary) {
        this.summary = summary;
    }

    @Override
    public void setSourceFiles(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.seqFiles = seqFiles;
        this.unseqFiles = unseqFiles;
    }

    private void checkThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted() || this.summary.isCancel()) {
            throw new InterruptedException(String.format("[Compaction] compaction for target file %s abort", this.targetFiles.toString()));
        }
    }

    public SubCompactionTaskSummary getSubTaskSummary() {
        return this.subTaskSummary;
    }

    public List<TsFileResource> getUnseqFiles() {
        return this.unseqFiles;
    }

    public List<TsFileResource> getSeqFiles() {
        return this.seqFiles;
    }

    @Override
    public void setSourceFiles(List<TsFileResource> unseqFiles) {
        this.seqFiles = unseqFiles;
    }
}

