/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCrossCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class FastCrossCompactionWriter
extends AbstractCrossCompactionWriter {
    public FastCrossCompactionWriter(List<TsFileResource> targetResources, List<TsFileResource> seqSourceResources) throws IOException {
        super(targetResources, seqSourceResources);
    }

    @Override
    public void write(TimeColumn timestamps, Column[] columns, int subTaskId, int batchSize) throws IOException {
        throw new RuntimeException("Does not support this method in FastCrossCompactionWriter");
    }

    @Override
    public boolean flushNonAlignedChunk(Chunk chunk, ChunkMetadata chunkMetadata, int subTaskId) throws IOException {
        this.checkTimeAndMayFlushChunkToCurrentFile(chunkMetadata.getStartTime(), subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        if (!this.checkIsChunkSatisfied((IChunkMetadata)chunkMetadata, fileIndex, subTaskId)) {
            return false;
        }
        this.flushNonAlignedChunkToFileWriter((TsFileIOWriter)this.targetFileWriters.get(fileIndex), chunk, chunkMetadata, subTaskId);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = chunkMetadata.getEndTime();
        return true;
    }

    @Override
    public boolean flushAlignedChunk(Chunk timeChunk, IChunkMetadata timeChunkMetadata, List<Chunk> valueChunks, List<IChunkMetadata> valueChunkMetadatas, int subTaskId) throws IOException {
        this.checkTimeAndMayFlushChunkToCurrentFile(timeChunkMetadata.getStartTime(), subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        if (!this.checkIsChunkSatisfied(timeChunkMetadata, fileIndex, subTaskId)) {
            return false;
        }
        this.flushAlignedChunkToFileWriter((TsFileIOWriter)this.targetFileWriters.get(fileIndex), timeChunk, timeChunkMetadata, valueChunks, valueChunkMetadatas, subTaskId);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = timeChunkMetadata.getEndTime();
        return true;
    }

    @Override
    public boolean flushAlignedPage(ByteBuffer compressedTimePageData, PageHeader timePageHeader, List<ByteBuffer> compressedValuePageDatas, List<PageHeader> valuePageHeaders, int subTaskId) throws IOException, PageException {
        this.checkTimeAndMayFlushChunkToCurrentFile(timePageHeader.getStartTime(), subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        if (!this.checkIsPageSatisfied(timePageHeader, fileIndex, subTaskId)) {
            return false;
        }
        this.flushAlignedPageToChunkWriter((AlignedChunkWriterImpl)this.chunkWriters[subTaskId], compressedTimePageData, timePageHeader, compressedValuePageDatas, valuePageHeaders, subTaskId);
        this.checkChunkSizeAndMayOpenANewChunk((TsFileIOWriter)this.targetFileWriters.get(fileIndex), this.chunkWriters[subTaskId], subTaskId, true);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = timePageHeader.getEndTime();
        return true;
    }

    @Override
    public boolean flushNonAlignedPage(ByteBuffer compressedPageData, PageHeader pageHeader, int subTaskId) throws IOException, PageException {
        this.checkTimeAndMayFlushChunkToCurrentFile(pageHeader.getStartTime(), subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        if (!this.checkIsPageSatisfied(pageHeader, fileIndex, subTaskId)) {
            return false;
        }
        this.flushNonAlignedPageToChunkWriter((ChunkWriterImpl)this.chunkWriters[subTaskId], compressedPageData, pageHeader, subTaskId);
        this.checkChunkSizeAndMayOpenANewChunk((TsFileIOWriter)this.targetFileWriters.get(fileIndex), this.chunkWriters[subTaskId], subTaskId, true);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = pageHeader.getEndTime();
        return true;
    }

    private boolean checkIsChunkSatisfied(IChunkMetadata chunkMetadata, int fileIndex, int subTaskId) {
        boolean isUnsealedChunkLargeEnough = this.chunkWriters[subTaskId].checkIsChunkSizeOverThreshold(this.chunkSizeLowerBoundInCompaction, this.chunkPointNumLowerBoundInCompaction, true);
        return isUnsealedChunkLargeEnough && (chunkMetadata.getEndTime() <= this.currentDeviceEndTime[fileIndex] || fileIndex == this.targetFileWriters.size() - 1);
    }

    private boolean checkIsPageSatisfied(PageHeader pageHeader, int fileIndex, int subTaskId) {
        boolean isUnsealedPageLargeEnough = this.chunkWriters[subTaskId].checkIsUnsealedPageOverThreshold(this.pageSizeLowerBoundInCompaction, this.pagePointNumLowerBoundInCompaction, true);
        return isUnsealedPageLargeEnough && (pageHeader.getEndTime() <= this.currentDeviceEndTime[fileIndex] || fileIndex == this.targetFileWriters.size() - 1);
    }
}

