/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.rescon.SchemaStatisticsManager;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.db.query.dataset.ShowResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSchemaProcessor {
    private static final Logger logger = LoggerFactory.getLogger(LocalSchemaProcessor.class);
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private LocalConfigNode configManager = LocalConfigNode.getInstance();
    private SchemaEngine schemaEngine = SchemaEngine.getInstance();

    public static LocalSchemaProcessor getInstance() {
        return LocalSchemaProcessorHolder.INSTANCE;
    }

    protected LocalSchemaProcessor() {
    }

    private ISchemaRegion getBelongedSchemaRegion(PartialPath path) throws MetadataException {
        return this.schemaEngine.getSchemaRegion(this.configManager.getBelongedSchemaRegionId(path));
    }

    private ISchemaRegion getBelongedSchemaRegionWithAutoCreate(PartialPath path) throws MetadataException {
        return this.schemaEngine.getSchemaRegion(this.configManager.getBelongedSchemaRegionIdWithAutoCreate(path));
    }

    private List<ISchemaRegion> getInvolvedSchemaRegions(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        List<SchemaRegionId> schemaRegionIds = this.configManager.getInvolvedSchemaRegionIds(pathPattern, isPrefixMatch);
        ArrayList<ISchemaRegion> schemaRegions = new ArrayList<ISchemaRegion>();
        for (SchemaRegionId schemaRegionId : schemaRegionIds) {
            schemaRegions.add(this.schemaEngine.getSchemaRegion(schemaRegionId));
        }
        return schemaRegions;
    }

    private List<ISchemaRegion> getSchemaRegionsByStorageGroup(PartialPath storageGroup) throws MetadataException {
        List<SchemaRegionId> schemaRegionIds = this.configManager.getSchemaRegionIdsByStorageGroup(storageGroup);
        ArrayList<ISchemaRegion> schemaRegions = new ArrayList<ISchemaRegion>();
        for (SchemaRegionId schemaRegionId : schemaRegionIds) {
            schemaRegions.add(this.schemaEngine.getSchemaRegion(schemaRegionId));
        }
        return schemaRegions;
    }

    public void createTimeseries(CreateTimeSeriesPlan plan) throws MetadataException {
        this.createTimeseries(plan, -1L);
    }

    public void createTimeseries(CreateTimeSeriesPlan plan, long offset) throws MetadataException {
        this.getBelongedSchemaRegionWithAutoCreate(plan.getPath()).createTimeseries(plan, offset);
    }

    public void createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws MetadataException {
        block2: {
            try {
                this.createTimeseries(new CreateTimeSeriesPlan(path, dataType, encoding, compressor, props, null, null, null));
            }
            catch (AliasAlreadyExistException | MeasurementAlreadyExistException | PathAlreadyExistException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Ignore PathAlreadyExistException and AliasAlreadyExistException when Concurrent inserting a non-exist time series {}", (Object)path);
            }
        }
    }

    public void createAlignedTimeSeries(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws MetadataException {
        this.createAlignedTimeSeries(new CreateAlignedTimeSeriesPlan(prefixPath, measurements, dataTypes, encodings, compressors, null, null, null));
    }

    public void createAlignedTimeSeries(CreateAlignedTimeSeriesPlan plan) throws MetadataException {
        this.getBelongedSchemaRegionWithAutoCreate(plan.getDevicePath()).createAlignedTimeSeries(plan);
    }

    public String deleteTimeseries(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        List<ISchemaRegion> schemaRegions = this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch);
        if (schemaRegions.isEmpty()) {
            throw new PathNotExistException(pathPattern.getFullPath());
        }
        HashSet failedNames = new HashSet();
        int deletedNum = 0;
        for (ISchemaRegion schemaRegion : schemaRegions) {
            Pair<Integer, Set<String>> sgDeletionResult = schemaRegion.deleteTimeseries(pathPattern, isPrefixMatch);
            deletedNum += ((Integer)sgDeletionResult.left).intValue();
            failedNames.addAll((Collection)sgDeletionResult.right);
        }
        if (deletedNum == 0 && failedNames.isEmpty()) {
            throw new PathNotExistException(pathPattern.getFullPath());
        }
        return failedNames.isEmpty() ? null : String.join((CharSequence)",", failedNames);
    }

    public String deleteTimeseries(PartialPath pathPattern) throws MetadataException {
        return this.deleteTimeseries(pathPattern, false);
    }

    public void setStorageGroup(PartialPath storageGroup) throws MetadataException {
        this.configManager.setStorageGroup(storageGroup);
    }

    public void deleteStorageGroups(List<PartialPath> storageGroups) throws MetadataException {
        this.configManager.deleteStorageGroups(storageGroups);
    }

    public void setTTL(PartialPath storageGroup, long dataTTL) throws MetadataException, IOException {
        this.configManager.setTTL(storageGroup, dataTTL);
    }

    public boolean isPathExist(PartialPath path) {
        try {
            if (!this.configManager.isStorageGroupAlreadySet(path)) {
                return false;
            }
            if (this.configManager.isStorageGroup(path)) {
                return true;
            }
            try {
                PartialPath storageGroup = this.configManager.getBelongedStorageGroup(path);
                for (ISchemaRegion schemaRegion : this.getSchemaRegionsByStorageGroup(storageGroup)) {
                    if (!schemaRegion.isPathExist(path)) continue;
                    return true;
                }
                return false;
            }
            catch (StorageGroupNotSetException e) {
                return true;
            }
        }
        catch (MetadataException e) {
            return false;
        }
    }

    public int getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        if (pathPattern.getFullPath().equals("root.**")) {
            return (int)SchemaStatisticsManager.getInstance().getTotalSeriesNumber();
        }
        int count = 0;
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch)) {
            count = (int)((long)count + schemaRegion.getAllTimeseriesCount(pathPattern, isPrefixMatch));
        }
        return count;
    }

    public int getAllTimeseriesCount(PartialPath pathPattern) throws MetadataException {
        return this.getAllTimeseriesCount(pathPattern, false);
    }

    public int getDevicesNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        int num = 0;
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch)) {
            num = (int)((long)num + schemaRegion.getDevicesNum(pathPattern, isPrefixMatch));
        }
        return num;
    }

    public int getStorageGroupNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.configManager.getStorageGroupNum(pathPattern, isPrefixMatch);
    }

    public int getNodesCountInGivenLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        return this.getNodesListInGivenLevel(pathPattern, level, isPrefixMatch).size();
    }

    private List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch) throws MetadataException {
        Pair<List<PartialPath>, Set<PartialPath>> pair = this.configManager.getNodesListInGivenLevel(pathPattern, nodeLevel, isPrefixMatch);
        TreeSet<PartialPath> result = new TreeSet<PartialPath>((Collection)pair.left);
        for (PartialPath storageGroup : (Set)pair.right) {
            for (ISchemaRegion schemaRegion : this.getSchemaRegionsByStorageGroup(storageGroup)) {
                result.addAll(schemaRegion.getNodesListInGivenLevel(pathPattern, nodeLevel, isPrefixMatch));
            }
        }
        return new ArrayList<PartialPath>(result);
    }

    public Set<TSchemaNode> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        Pair<Set<TSchemaNode>, Set<PartialPath>> pair = this.configManager.getChildNodePathInNextLevel(pathPattern);
        Set result = (Set)pair.left;
        for (PartialPath storageGroup : (Set)pair.right) {
            for (ISchemaRegion schemaRegion : this.getSchemaRegionsByStorageGroup(storageGroup)) {
                result.addAll(schemaRegion.getChildNodePathInNextLevel(pathPattern));
            }
        }
        return result;
    }

    public Set<String> getChildNodeNameInNextLevel(PartialPath pathPattern) throws MetadataException {
        Pair<Set<String>, Set<PartialPath>> pair = this.configManager.getChildNodeNameInNextLevel(pathPattern);
        Set result = (Set)pair.left;
        for (PartialPath storageGroup : (Set)pair.right) {
            for (ISchemaRegion schemaRegion : this.getSchemaRegionsByStorageGroup(storageGroup)) {
                result.addAll(schemaRegion.getChildNodeNameInNextLevel(pathPattern));
            }
        }
        return result;
    }

    public boolean isStorageGroup(PartialPath path) {
        return this.configManager.isStorageGroup(path);
    }

    public boolean checkStorageGroupByPath(PartialPath path) {
        return this.configManager.checkStorageGroupByPath(path);
    }

    public PartialPath getBelongedStorageGroup(PartialPath path) throws StorageGroupNotSetException {
        return this.configManager.getBelongedStorageGroup(path);
    }

    public List<PartialPath> getBelongedStorageGroups(PartialPath pathPattern) throws MetadataException {
        return this.configManager.getBelongedStorageGroups(pathPattern);
    }

    public List<PartialPath> getMatchedStorageGroups(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.configManager.getMatchedStorageGroups(pathPattern, isPrefixMatch);
    }

    public List<PartialPath> getAllStorageGroupPaths() {
        return this.configManager.getAllStorageGroupPaths();
    }

    public Set<PartialPath> getBelongedDevices(PartialPath timeseries) throws MetadataException {
        TreeSet<PartialPath> result = new TreeSet<PartialPath>();
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(timeseries, false)) {
            result.addAll(schemaRegion.getBelongedDevices(timeseries));
        }
        return result;
    }

    public Set<PartialPath> getMatchedDevices(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        TreeSet<PartialPath> result = new TreeSet<PartialPath>();
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch)) {
            result.addAll(schemaRegion.getMatchedDevices(pathPattern, isPrefixMatch));
        }
        return result;
    }

    public List<ShowDevicesResult> getMatchedDevices(ShowDevicesPlan plan) throws MetadataException {
        LinkedList<ShowDevicesResult> result = new LinkedList<ShowDevicesResult>();
        int limit = plan.getLimit();
        int offset = plan.getOffset();
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(plan.getPath(), plan.isPrefixMatch())) {
            if (limit != 0 && plan.getLimit() == 0) break;
            Pair<List<ShowDevicesResult>, Integer> regionResult = schemaRegion.getMatchedDevices(plan);
            result.addAll((Collection)regionResult.left);
            if (limit == 0) continue;
            plan.setLimit(plan.getLimit() - ((List)regionResult.left).size());
            plan.setOffset(Math.max(plan.getOffset() - (Integer)regionResult.right, 0));
        }
        plan.setLimit(limit);
        plan.setOffset(offset);
        return result;
    }

    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return (List)this.getMeasurementPathsWithAlias((PartialPath)pathPattern, (int)0, (int)0, (boolean)isPrefixMatch, (boolean)false).left;
    }

    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern) throws MetadataException {
        return this.getMeasurementPaths(pathPattern, false);
    }

    public Pair<List<MeasurementPath>, Integer> getMeasurementPathsWithAlias(PartialPath pathPattern, int limit, int offset, boolean isPrefixMatch, boolean withTags) throws MetadataException {
        Pair<List<MeasurementPath>, Integer> result;
        LinkedList measurementPaths = new LinkedList();
        int resultOffset = 0;
        int tmpLimit = limit;
        int tmpOffset = offset;
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch)) {
            if (limit != 0 && tmpLimit == 0) break;
            result = schemaRegion.getMeasurementPathsWithAlias(pathPattern, tmpLimit, tmpOffset, isPrefixMatch, withTags);
            measurementPaths.addAll((Collection)result.left);
            resultOffset += ((Integer)result.right).intValue();
            if (limit == 0) continue;
            tmpOffset = Math.max(0, tmpOffset - (Integer)result.right);
            tmpLimit -= ((List)result.left).size();
        }
        result = new Pair<List<MeasurementPath>, Integer>(measurementPaths, (Object)resultOffset);
        return result;
    }

    public List<ShowTimeSeriesResult> showTimeseries(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        LinkedList result = new LinkedList();
        int limit = plan.getLimit();
        int offset = plan.getOffset();
        if (plan.isOrderByHeat() && limit != 0) {
            plan.setOffset(0);
            plan.setLimit(offset + limit);
        }
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(plan.getPath(), plan.isPrefixMatch())) {
            if (limit != 0 && plan.getLimit() == 0) break;
            Pair<List<ShowTimeSeriesResult>, Integer> regionResult = schemaRegion.showTimeseries(plan, context);
            result.addAll((Collection)regionResult.left);
            if (limit == 0) continue;
            plan.setLimit(plan.getLimit() - ((List)regionResult.left).size());
            plan.setOffset(Math.max(plan.getOffset() - (Integer)regionResult.right, 0));
        }
        Stream<Object> stream = result.stream();
        if (plan.isOrderByHeat()) {
            stream = stream.sorted(Comparator.comparingLong(ShowTimeSeriesResult::getLastTime).reversed().thenComparing(ShowResult::getName));
            if (limit != 0) {
                stream = stream.skip(offset).limit(limit);
            }
        }
        plan.setLimit(limit);
        plan.setOffset(offset);
        return stream.collect(Collectors.toList());
    }

    public TSDataType getSeriesType(PartialPath fullPath) throws MetadataException {
        if (fullPath.equals((Object)SQLConstant.TIME_PATH)) {
            return TSDataType.INT64;
        }
        return this.getSeriesSchema(fullPath).getType();
    }

    public IMeasurementSchema getSeriesSchema(PartialPath fullPath) throws MetadataException {
        return this.getMeasurementMNode(fullPath).getSchema();
    }

    public IStorageGroupMNode getStorageGroupNodeByPath(PartialPath path) throws MetadataException {
        return this.configManager.getStorageGroupNodeByPath(path);
    }

    public List<IStorageGroupMNode> getAllStorageGroupNodes() {
        return this.configManager.getAllStorageGroupNodes();
    }

    public IMNode getDeviceNode(PartialPath path) throws MetadataException {
        return this.getBelongedSchemaRegion(path).getDeviceNode(path);
    }

    public IMeasurementMNode getMeasurementMNode(PartialPath fullPath) throws MetadataException {
        try {
            return this.getBelongedSchemaRegion(fullPath).getMeasurementMNode(fullPath);
        }
        catch (StorageGroupNotSetException e) {
            throw new PathNotExistException(fullPath.getFullPath());
        }
    }

    public void changeAlias(PartialPath path, String alias) throws MetadataException, IOException {
        this.getBelongedSchemaRegion(path).changeAlias(path, alias);
    }

    public void upsertTagsAndAttributes(String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        this.getBelongedSchemaRegion(fullPath).upsertTagsAndAttributes(alias, tagsMap, attributesMap, fullPath);
    }

    public void addTags(Map<String, String> tagsMap, PartialPath fullPath) throws MetadataException, IOException {
        this.getBelongedSchemaRegion(fullPath).addTags(tagsMap, fullPath);
    }

    public void forceMlog() {
        this.configManager.forceMlog();
    }

    public long getTotalSeriesNumber() {
        return SchemaStatisticsManager.getInstance().getTotalSeriesNumber();
    }

    private static class LocalSchemaProcessorHolder {
        private static final LocalSchemaProcessor INSTANCE = new LocalSchemaProcessor();

        private LocalSchemaProcessorHolder() {
        }
    }
}

