/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupEntityMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;

public class MNodeUtils {
    public static IEntityMNode setToEntity(IMNode node) {
        IEntityMNode entityMNode;
        if (node.isEntity()) {
            entityMNode = node.getAsEntityMNode();
        } else if (node.isStorageGroup()) {
            entityMNode = new StorageGroupEntityMNode(node.getParent(), node.getName(), node.getAsStorageGroupMNode().getDataTTL());
            node.moveDataToNewMNode(entityMNode);
        } else {
            entityMNode = new EntityMNode(node.getParent(), node.getName());
            if (node.getParent() != null) {
                node.getParent().replaceChild(node.getName(), entityMNode);
            } else {
                node.moveDataToNewMNode(entityMNode);
            }
        }
        return entityMNode;
    }

    public static IMNode setToInternal(IEntityMNode entityMNode) {
        IMNode parent = entityMNode.getParent();
        InternalMNode node = entityMNode.isStorageGroup() ? new StorageGroupMNode(parent, entityMNode.getName(), entityMNode.getAsStorageGroupMNode().getDataTTL()) : new InternalMNode(parent, entityMNode.getName());
        if (parent != null) {
            parent.replaceChild(entityMNode.getName(), node);
        }
        return node;
    }
}

