/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.plan.schemaregion.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.metadata.logfile.IDeserializer;
import org.apache.iotdb.db.metadata.plan.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.SchemaRegionPlanType;
import org.apache.iotdb.db.metadata.plan.schemaregion.SchemaRegionPlanVisitor;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.SchemaRegionPlanFactory;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IAutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IChangeAliasPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IChangeTagOffsetPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IDeleteTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IPreDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IRollbackPreDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IRollbackPreDeleteTimeSeriesPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegionPlanDeserializer
implements IDeserializer<ISchemaRegionPlan> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaRegionPlanDeserializer.class);

    @Override
    public ISchemaRegionPlan deserialize(ByteBuffer byteBuffer) {
        ISchemaRegionPlan schemaRegionPlan = SchemaRegionPlanFactory.getEmptyPlan(SchemaRegionPlanType.deserialize(byteBuffer));
        return schemaRegionPlan.accept(new SchemaRegionPlanDeserializeVisitor(), byteBuffer);
    }

    private static class SchemaRegionPlanDeserializeVisitor
    extends SchemaRegionPlanVisitor<ISchemaRegionPlan, ByteBuffer> {
        private SchemaRegionPlanDeserializeVisitor() {
        }

        @Override
        public ISchemaRegionPlan visitSchemaRegionPlan(ISchemaRegionPlan plan, ByteBuffer byteBuffer) {
            throw new UnsupportedOperationException(String.format("%s plan doesn't support deserialization.", plan.getPlanType().name()));
        }

        @Override
        public ISchemaRegionPlan visitActivateTemplateInCluster(IActivateTemplateInClusterPlan activateTemplateInClusterPlan, ByteBuffer buffer) {
            try {
                activateTemplateInClusterPlan.setActivatePath(new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer)));
            }
            catch (IllegalPathException e) {
                LOGGER.error("Cannot deserialize SchemaRegionPlan from buffer", (Throwable)e);
            }
            activateTemplateInClusterPlan.setTemplateSetLevel(ReadWriteIOUtils.readInt((ByteBuffer)buffer));
            activateTemplateInClusterPlan.setTemplateId(ReadWriteIOUtils.readInt((ByteBuffer)buffer));
            activateTemplateInClusterPlan.setAligned(ReadWriteIOUtils.readBool((ByteBuffer)buffer));
            buffer.getLong();
            return activateTemplateInClusterPlan;
        }

        @Override
        public ISchemaRegionPlan visitAutoCreateDeviceMNode(IAutoCreateDeviceMNodePlan autoCreateDeviceMNodePlan, ByteBuffer buffer) {
            try {
                autoCreateDeviceMNodePlan.setPath(new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer)));
            }
            catch (IllegalPathException e) {
                LOGGER.error("Cannot deserialize SchemaRegionPlan from buffer", (Throwable)e);
            }
            buffer.getLong();
            return autoCreateDeviceMNodePlan;
        }

        @Override
        public ISchemaRegionPlan visitChangeAlias(IChangeAliasPlan changeAliasPlan, ByteBuffer buffer) {
            try {
                changeAliasPlan.setPath(new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer)));
            }
            catch (IllegalPathException e) {
                LOGGER.error("Cannot deserialize SchemaRegionPlan from buffer", (Throwable)e);
            }
            changeAliasPlan.setAlias(ReadWriteIOUtils.readString((ByteBuffer)buffer));
            return changeAliasPlan;
        }

        @Override
        public ISchemaRegionPlan visitChangeTagOffset(IChangeTagOffsetPlan changeTagOffsetPlan, ByteBuffer buffer) {
            try {
                changeTagOffsetPlan.setPath(new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer)));
            }
            catch (IllegalPathException e) {
                LOGGER.error("Cannot deserialize SchemaRegionPlan from buffer", (Throwable)e);
            }
            changeTagOffsetPlan.setOffset(buffer.getLong());
            return changeTagOffsetPlan;
        }

        @Override
        public ISchemaRegionPlan visitCreateAlignedTimeSeries(ICreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan, ByteBuffer buffer) {
            int i;
            buffer.getInt();
            int length = buffer.getInt();
            byte[] bytes = new byte[length];
            buffer.get(bytes);
            try {
                createAlignedTimeSeriesPlan.setDevicePath(new PartialPath(new String(bytes)));
            }
            catch (IllegalPathException e) {
                LOGGER.error("Cannot deserialize SchemaRegionPlan from buffer", (Throwable)e);
            }
            int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            ArrayList<String> measurements = new ArrayList<String>();
            for (int i2 = 0; i2 < size; ++i2) {
                measurements.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
            }
            createAlignedTimeSeriesPlan.setMeasurements(measurements);
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            for (int i3 = 0; i3 < size; ++i3) {
                dataTypes.add(TSDataType.values()[buffer.get()]);
            }
            createAlignedTimeSeriesPlan.setDataTypes(dataTypes);
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
            for (int i4 = 0; i4 < size; ++i4) {
                encodings.add(TSEncoding.values()[buffer.get()]);
            }
            createAlignedTimeSeriesPlan.setEncodings(encodings);
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
            for (int i5 = 0; i5 < size; ++i5) {
                compressors.add(CompressionType.deserialize((byte)buffer.get()));
            }
            createAlignedTimeSeriesPlan.setCompressors(compressors);
            ArrayList<Long> tagOffsets = new ArrayList<Long>();
            for (int i6 = 0; i6 < size; ++i6) {
                tagOffsets.add(buffer.getLong());
            }
            createAlignedTimeSeriesPlan.setTagOffsets(tagOffsets);
            if (buffer.get() == 1) {
                ArrayList<String> aliasList = new ArrayList<String>();
                for (i = 0; i < size; ++i) {
                    aliasList.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
                }
                createAlignedTimeSeriesPlan.setAliasList(aliasList);
            }
            if (buffer.get() == 1) {
                ArrayList<Map<String, String>> tagsList = new ArrayList<Map<String, String>>();
                for (i = 0; i < size; ++i) {
                    tagsList.add(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
                }
                createAlignedTimeSeriesPlan.setTagsList(tagsList);
            }
            if (buffer.get() == 1) {
                ArrayList<Map<String, String>> attributesList = new ArrayList<Map<String, String>>();
                for (i = 0; i < size; ++i) {
                    attributesList.add(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
                }
                createAlignedTimeSeriesPlan.setAttributesList(attributesList);
            }
            buffer.getLong();
            return createAlignedTimeSeriesPlan;
        }

        @Override
        public ISchemaRegionPlan visitCreateTimeSeries(ICreateTimeSeriesPlan createTimeSeriesPlan, ByteBuffer buffer) {
            int length = buffer.getInt();
            byte[] bytes = new byte[length];
            buffer.get(bytes);
            try {
                createTimeSeriesPlan.setPath(new PartialPath(new String(bytes)));
            }
            catch (IllegalPathException e) {
                LOGGER.error("Cannot deserialize SchemaRegionPlan from buffer", (Throwable)e);
            }
            createTimeSeriesPlan.setDataType(TSDataType.values()[buffer.get()]);
            createTimeSeriesPlan.setEncoding(TSEncoding.values()[buffer.get()]);
            createTimeSeriesPlan.setCompressor(CompressionType.deserialize((byte)buffer.get()));
            createTimeSeriesPlan.setTagOffset(buffer.getLong());
            if (buffer.get() == 1) {
                createTimeSeriesPlan.setAlias(ReadWriteIOUtils.readString((ByteBuffer)buffer));
            }
            if (buffer.get() == 1) {
                createTimeSeriesPlan.setProps(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
            }
            if (buffer.get() == 1) {
                createTimeSeriesPlan.setTags(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
            }
            if (buffer.get() == 1) {
                createTimeSeriesPlan.setAttributes(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
            }
            buffer.getLong();
            return createTimeSeriesPlan;
        }

        @Override
        public ISchemaRegionPlan visitDeleteTimeSeries(IDeleteTimeSeriesPlan deleteTimeSeriesPlan, ByteBuffer buffer) {
            int pathNumber = buffer.getInt();
            try {
                ArrayList<PartialPath> deletePathList = new ArrayList<PartialPath>();
                for (int i = 0; i < pathNumber; ++i) {
                    deletePathList.add(new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer)));
                }
                deleteTimeSeriesPlan.setDeletePathList(deletePathList);
            }
            catch (IllegalPathException e) {
                LOGGER.error("Cannot deserialize SchemaRegionPlan from buffer", (Throwable)e);
            }
            buffer.getLong();
            return deleteTimeSeriesPlan;
        }

        @Override
        public ISchemaRegionPlan visitPreDeleteTimeSeries(IPreDeleteTimeSeriesPlan preDeleteTimeSeriesPlan, ByteBuffer buffer) {
            preDeleteTimeSeriesPlan.setPath((PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer));
            buffer.getLong();
            return preDeleteTimeSeriesPlan;
        }

        @Override
        public ISchemaRegionPlan visitRollbackPreDeleteTimeSeries(IRollbackPreDeleteTimeSeriesPlan rollbackPreDeleteTimeSeriesPlan, ByteBuffer buffer) {
            rollbackPreDeleteTimeSeriesPlan.setPath((PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer));
            buffer.getLong();
            return rollbackPreDeleteTimeSeriesPlan;
        }

        @Override
        public ISchemaRegionPlan visitPreDeactivateTemplate(IPreDeactivateTemplatePlan preDeactivateTemplatePlan, ByteBuffer buffer) {
            preDeactivateTemplatePlan.setTemplateSetInfo(this.deserializeTemplateSetInfo(buffer));
            return preDeactivateTemplatePlan;
        }

        @Override
        public ISchemaRegionPlan visitRollbackPreDeactivateTemplate(IRollbackPreDeactivateTemplatePlan rollbackPreDeactivateTemplatePlan, ByteBuffer buffer) {
            rollbackPreDeactivateTemplatePlan.setTemplateSetInfo(this.deserializeTemplateSetInfo(buffer));
            return rollbackPreDeactivateTemplatePlan;
        }

        @Override
        public ISchemaRegionPlan visitDeactivateTemplate(IDeactivateTemplatePlan deactivateTemplatePlan, ByteBuffer buffer) {
            deactivateTemplatePlan.setTemplateSetInfo(this.deserializeTemplateSetInfo(buffer));
            return deactivateTemplatePlan;
        }

        private Map<PartialPath, List<Integer>> deserializeTemplateSetInfo(ByteBuffer buffer) {
            int size = buffer.getInt();
            HashMap<PartialPath, List<Integer>> result = new HashMap<PartialPath, List<Integer>>(size);
            for (int i = 0; i < size; ++i) {
                PartialPath pattern = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer);
                int templateNum = buffer.getInt();
                ArrayList<Integer> templateIdList = new ArrayList<Integer>(templateNum);
                for (int j = 0; j < templateNum; ++j) {
                    templateIdList.add(buffer.getInt());
                }
                result.put(pattern, templateIdList);
            }
            return result;
        }
    }
}

