/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.client.DataNodeInternalClient;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.IntoProcessException;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;

public abstract class AbstractIntoOperator
implements ProcessOperator {
    protected final OperatorContext operatorContext;
    protected final Operator child;
    protected List<InsertTabletStatementGenerator> insertTabletStatementGenerators;
    protected final Map<String, InputLocation> sourceColumnToInputLocationMap;
    private DataNodeInternalClient client;

    public AbstractIntoOperator(OperatorContext operatorContext, Operator child, List<InsertTabletStatementGenerator> insertTabletStatementGenerators, Map<String, InputLocation> sourceColumnToInputLocationMap) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.insertTabletStatementGenerators = insertTabletStatementGenerators;
        this.sourceColumnToInputLocationMap = sourceColumnToInputLocationMap;
    }

    protected static List<InsertTabletStatementGenerator> constructInsertTabletStatementGenerators(Map<PartialPath, Map<String, InputLocation>> targetPathToSourceInputLocationMap, Map<PartialPath, Map<String, TSDataType>> targetPathToDataTypeMap, Map<String, Boolean> targetDeviceToAlignedMap) {
        ArrayList<InsertTabletStatementGenerator> insertTabletStatementGenerators = new ArrayList<InsertTabletStatementGenerator>(targetPathToSourceInputLocationMap.size());
        for (PartialPath targetDevice : targetPathToSourceInputLocationMap.keySet()) {
            InsertTabletStatementGenerator generator = new InsertTabletStatementGenerator(targetDevice, targetPathToSourceInputLocationMap.get(targetDevice), targetPathToDataTypeMap.get(targetDevice), targetDeviceToAlignedMap.get(targetDevice.toString()));
            insertTabletStatementGenerators.add(generator);
        }
        return insertTabletStatementGenerators;
    }

    protected void insertMultiTabletsInternally(boolean needCheck) {
        TSStatus executionStatus;
        if (this.insertTabletStatementGenerators == null || needCheck && !this.existFullStatement(this.insertTabletStatementGenerators)) {
            return;
        }
        ArrayList<InsertTabletStatement> insertTabletStatementList = new ArrayList<InsertTabletStatement>();
        for (InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
            if (generator.isEmpty()) continue;
            insertTabletStatementList.add(generator.constructInsertTabletStatement());
        }
        if (insertTabletStatementList.isEmpty()) {
            return;
        }
        InsertMultiTabletsStatement insertMultiTabletsStatement = new InsertMultiTabletsStatement();
        insertMultiTabletsStatement.setInsertTabletStatementList(insertTabletStatementList);
        if (this.client == null) {
            this.client = new DataNodeInternalClient(this.operatorContext.getSessionInfo());
        }
        if ((executionStatus = this.client.insertTablets(insertMultiTabletsStatement)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && executionStatus.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            String message = String.format("Error occurred while inserting tablets in SELECT INTO: %s", executionStatus.getMessage());
            throw new IntoProcessException(message);
        }
        for (InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
            generator.reset();
        }
    }

    private boolean existFullStatement(List<InsertTabletStatementGenerator> insertTabletStatementGenerators) {
        for (InsertTabletStatementGenerator generator : insertTabletStatementGenerators) {
            if (!generator.isFull()) continue;
            return true;
        }
        return false;
    }

    private boolean existNonEmptyStatement(List<InsertTabletStatementGenerator> insertTabletStatementGenerators) {
        if (insertTabletStatementGenerators == null) {
            return false;
        }
        for (InsertTabletStatementGenerator generator : insertTabletStatementGenerators) {
            if (generator == null || generator.isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected int findWritten(String device, String measurement) {
        for (InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
            if (!Objects.equals(generator.getDevice(), device)) continue;
            return generator.getWrittenCount(measurement);
        }
        return 0;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public boolean hasNext() {
        return this.existNonEmptyStatement(this.insertTabletStatementGenerators) || this.child.hasNext();
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        this.child.close();
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public static class InsertTabletStatementGenerator {
        private final int TABLET_ROW_LIMIT = IoTDBDescriptor.getInstance().getConfig().getSelectIntoInsertTabletPlanRowLimit();
        private final PartialPath devicePath;
        private final boolean isAligned;
        private final String[] measurements;
        private final TSDataType[] dataTypes;
        private final InputLocation[] inputLocations;
        private int rowCount = 0;
        private long[] times;
        private Object[] columns;
        private BitMap[] bitMaps;
        private final Map<String, AtomicInteger> writtenCounter;

        public InsertTabletStatementGenerator(PartialPath devicePath, Map<String, InputLocation> measurementToInputLocationMap, Map<String, TSDataType> measurementToDataTypeMap, Boolean isAligned) {
            this.devicePath = devicePath;
            this.isAligned = isAligned;
            this.measurements = measurementToInputLocationMap.keySet().toArray(new String[0]);
            this.dataTypes = measurementToDataTypeMap.values().toArray(new TSDataType[0]);
            this.inputLocations = measurementToInputLocationMap.values().toArray(new InputLocation[0]);
            this.writtenCounter = new HashMap<String, AtomicInteger>();
            for (String measurement : this.measurements) {
                this.writtenCounter.put(measurement, new AtomicInteger(0));
            }
            this.reset();
        }

        public void reset() {
            int i;
            this.rowCount = 0;
            this.times = new long[this.TABLET_ROW_LIMIT];
            this.columns = new Object[this.measurements.length];
            block8: for (i = 0; i < this.measurements.length; ++i) {
                switch (this.dataTypes[i]) {
                    case BOOLEAN: {
                        this.columns[i] = new boolean[this.TABLET_ROW_LIMIT];
                        continue block8;
                    }
                    case INT32: {
                        this.columns[i] = new int[this.TABLET_ROW_LIMIT];
                        continue block8;
                    }
                    case INT64: {
                        this.columns[i] = new long[this.TABLET_ROW_LIMIT];
                        continue block8;
                    }
                    case FLOAT: {
                        this.columns[i] = new float[this.TABLET_ROW_LIMIT];
                        continue block8;
                    }
                    case DOUBLE: {
                        this.columns[i] = new double[this.TABLET_ROW_LIMIT];
                        continue block8;
                    }
                    case TEXT: {
                        this.columns[i] = new Binary[this.TABLET_ROW_LIMIT];
                        Arrays.fill((Binary[])this.columns[i], Binary.EMPTY_VALUE);
                        continue block8;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataTypes[i]));
                    }
                }
            }
            this.bitMaps = new BitMap[this.measurements.length];
            for (i = 0; i < this.bitMaps.length; ++i) {
                this.bitMaps[i] = new BitMap(this.TABLET_ROW_LIMIT);
                this.bitMaps[i].markAll();
            }
        }

        public int processTsBlock(TsBlock tsBlock, int lastReadIndex) {
            while (lastReadIndex < tsBlock.getPositionCount()) {
                this.times[this.rowCount] = tsBlock.getTimeByIndex(lastReadIndex);
                block9: for (int i = 0; i < this.measurements.length; ++i) {
                    Column valueColumn = tsBlock.getValueColumns()[this.inputLocations[i].getValueColumnIndex()];
                    if (valueColumn.isNull(lastReadIndex)) continue;
                    this.bitMaps[i].unmark(this.rowCount);
                    this.writtenCounter.get(this.measurements[i]).getAndIncrement();
                    switch (valueColumn.getDataType()) {
                        case INT32: {
                            ((int[])this.columns[i])[this.rowCount] = valueColumn.getInt(lastReadIndex);
                            continue block9;
                        }
                        case INT64: {
                            ((long[])this.columns[i])[this.rowCount] = valueColumn.getLong(lastReadIndex);
                            continue block9;
                        }
                        case FLOAT: {
                            ((float[])this.columns[i])[this.rowCount] = valueColumn.getFloat(lastReadIndex);
                            continue block9;
                        }
                        case DOUBLE: {
                            ((double[])this.columns[i])[this.rowCount] = valueColumn.getDouble(lastReadIndex);
                            continue block9;
                        }
                        case BOOLEAN: {
                            ((boolean[])this.columns[i])[this.rowCount] = valueColumn.getBoolean(lastReadIndex);
                            continue block9;
                        }
                        case TEXT: {
                            ((Binary[])this.columns[i])[this.rowCount] = valueColumn.getBinary(lastReadIndex);
                            continue block9;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", valueColumn.getDataType()));
                        }
                    }
                }
                ++this.rowCount;
                ++lastReadIndex;
                if (this.rowCount != this.TABLET_ROW_LIMIT) continue;
                break;
            }
            return lastReadIndex;
        }

        public boolean isFull() {
            return this.rowCount == this.TABLET_ROW_LIMIT;
        }

        public boolean isEmpty() {
            return this.rowCount == 0;
        }

        public InsertTabletStatement constructInsertTabletStatement() {
            InsertTabletStatement insertTabletStatement = new InsertTabletStatement();
            insertTabletStatement.setDevicePath(this.devicePath);
            insertTabletStatement.setAligned(this.isAligned);
            insertTabletStatement.setMeasurements(this.measurements);
            insertTabletStatement.setDataTypes(this.dataTypes);
            insertTabletStatement.setRowCount(this.rowCount);
            if (this.rowCount != this.TABLET_ROW_LIMIT) {
                this.times = Arrays.copyOf(this.times, this.rowCount);
                block8: for (int i = 0; i < this.columns.length; ++i) {
                    this.bitMaps[i] = this.bitMaps[i].getRegion(0, this.rowCount);
                    switch (this.dataTypes[i]) {
                        case BOOLEAN: {
                            this.columns[i] = Arrays.copyOf((boolean[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        case INT32: {
                            this.columns[i] = Arrays.copyOf((int[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        case INT64: {
                            this.columns[i] = Arrays.copyOf((long[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        case FLOAT: {
                            this.columns[i] = Arrays.copyOf((float[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        case DOUBLE: {
                            this.columns[i] = Arrays.copyOf((double[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        case TEXT: {
                            this.columns[i] = Arrays.copyOf((Binary[])this.columns[i], this.rowCount);
                            continue block8;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataTypes[i]));
                        }
                    }
                }
            }
            insertTabletStatement.setTimes(this.times);
            insertTabletStatement.setBitMaps(this.bitMaps);
            insertTabletStatement.setColumns(this.columns);
            return insertTabletStatement;
        }

        public String getDevice() {
            return this.devicePath.toString();
        }

        public int getWrittenCount(String measurement) {
            if (!this.writtenCounter.containsKey(measurement)) {
                return -1;
            }
            return this.writtenCounter.get(measurement).get();
        }
    }
}

