/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.distribution;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.distribution.NodeDistribution;
import org.apache.iotdb.db.mpp.plan.planner.distribution.NodeDistributionType;
import org.apache.iotdb.db.mpp.plan.planner.distribution.NodeGroupContext;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.AbstractSchemaMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaFetchMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaFetchScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryOrderByHeatNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByTagNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryCollectNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedLastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SourceNode;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;

public class ExchangeNodeAdder
extends PlanVisitor<PlanNode, NodeGroupContext> {
    private final Analysis analysis;

    public ExchangeNodeAdder(Analysis analysis) {
        this.analysis = analysis;
    }

    @Override
    public PlanNode visitPlan(PlanNode node, NodeGroupContext context) {
        if (node instanceof WritePlanNode) {
            return node;
        }
        List children = (List)node.getChildren().stream().map(child -> child.accept(this, context)).collect(ImmutableList.toImmutableList());
        context.putNodeDistribution(node.getPlanNodeId(), new NodeDistribution(NodeDistributionType.SAME_WITH_ALL_CHILDREN, null));
        return node.cloneWithChildren(children);
    }

    @Override
    public PlanNode visitSchemaQueryMerge(SchemaQueryMergeNode node, NodeGroupContext context) {
        return this.internalVisitSchemaMerge(node, context);
    }

    private PlanNode internalVisitSchemaMerge(AbstractSchemaMergeNode node, NodeGroupContext context) {
        node.getChildren().forEach(child -> this.visit((PlanNode)child, context));
        NodeDistribution nodeDistribution = new NodeDistribution(NodeDistributionType.DIFFERENT_FROM_ALL_CHILDREN);
        PlanNode newNode = node.clone();
        nodeDistribution.region = this.calculateSchemaRegionByChildren(node.getChildren(), context);
        context.putNodeDistribution(newNode.getPlanNodeId(), nodeDistribution);
        node.getChildren().forEach(child -> {
            if (!nodeDistribution.region.equals(context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).region)) {
                ExchangeNode exchangeNode = new ExchangeNode(context.queryContext.getQueryId().genPlanNodeId());
                exchangeNode.setChild((PlanNode)child);
                exchangeNode.setOutputColumnNames(child.getOutputColumnNames());
                newNode.addChild(exchangeNode);
            } else {
                newNode.addChild((PlanNode)child);
            }
        });
        return newNode;
    }

    @Override
    public PlanNode visitCountMerge(CountSchemaMergeNode node, NodeGroupContext context) {
        return this.internalVisitSchemaMerge(node, context);
    }

    @Override
    public PlanNode visitSchemaFetchMerge(SchemaFetchMergeNode node, NodeGroupContext context) {
        return this.internalVisitSchemaMerge(node, context);
    }

    @Override
    public PlanNode visitSchemaQueryScan(SchemaQueryScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitSchemaFetchScan(SchemaFetchScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitSeriesScan(SeriesScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitAlignedSeriesScan(AlignedSeriesScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitLastQueryScan(LastQueryScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitAlignedLastQueryScan(AlignedLastQueryScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitSeriesAggregationScan(SeriesAggregationScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitAlignedSeriesAggregationScan(AlignedSeriesAggregationScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    private PlanNode processNoChildSourceNode(SourceNode node, NodeGroupContext context) {
        context.putNodeDistribution(node.getPlanNodeId(), new NodeDistribution(NodeDistributionType.NO_CHILD, node.getRegionReplicaSet()));
        return node.clone();
    }

    @Override
    public PlanNode visitDeviceView(DeviceViewNode node, NodeGroupContext context) {
        if (this.isAggregationQuery()) {
            return this.processDeviceViewWithAggregation(node, context);
        }
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitDeviceMerge(DeviceMergeNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitLastQueryMerge(LastQueryMergeNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitLastQueryCollect(LastQueryCollectNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitLastQuery(LastQueryNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitTimeJoin(TimeJoinNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitAggregation(AggregationNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitSchemaQueryOrderByHeat(SchemaQueryOrderByHeatNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitGroupByLevel(GroupByLevelNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitTransform(TransformNode node, NodeGroupContext context) {
        return this.processOneChildNode(node, context);
    }

    @Override
    public PlanNode visitFilter(FilterNode node, NodeGroupContext context) {
        return this.processOneChildNode(node, context);
    }

    @Override
    public PlanNode visitGroupByTag(GroupByTagNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    private PlanNode processDeviceViewWithAggregation(DeviceViewNode node, NodeGroupContext context) {
        HashMap<TRegionReplicaSet, DeviceViewGroup> deviceViewGroupMap = new HashMap<TRegionReplicaSet, DeviceViewGroup>();
        for (int i = 0; i < node.getDevices().size(); ++i) {
            String device = node.getDevices().get(i);
            PlanNode rawChildNode = node.getChildren().get(i);
            PlanNode visitedChild = this.visit(rawChildNode, context);
            TRegionReplicaSet region = context.getNodeDistribution((PlanNodeId)visitedChild.getPlanNodeId()).region;
            DeviceViewGroup group = deviceViewGroupMap.computeIfAbsent(region, DeviceViewGroup::new);
            group.addChild(device, visitedChild);
        }
        ArrayList<DeviceViewNode> deviceViewNodeList = new ArrayList<DeviceViewNode>();
        for (DeviceViewGroup group : deviceViewGroupMap.values()) {
            DeviceViewNode deviceViewNode = new DeviceViewNode(context.queryContext.getQueryId().genPlanNodeId(), node.getMergeOrderParameter(), node.getOutputColumnNames(), node.getDeviceToMeasurementIndexesMap());
            for (int i = 0; i < group.devices.size(); ++i) {
                deviceViewNode.addChildDeviceNode(group.devices.get(i), group.children.get(i));
            }
            context.putNodeDistribution(deviceViewNode.getPlanNodeId(), new NodeDistribution(NodeDistributionType.SAME_WITH_ALL_CHILDREN, context.getNodeDistribution((PlanNodeId)deviceViewNode.getChildren().get((int)0).getPlanNodeId()).region));
            deviceViewNodeList.add(deviceViewNode);
        }
        if (deviceViewNodeList.size() == 1) {
            return (PlanNode)deviceViewNodeList.get(0);
        }
        DeviceMergeNode deviceMergeNode = new DeviceMergeNode(context.queryContext.getQueryId().genPlanNodeId(), node.getMergeOrderParameter(), node.getDevices());
        deviceMergeNode.addChild((PlanNode)deviceViewNodeList.get(0));
        context.putNodeDistribution(deviceMergeNode.getPlanNodeId(), new NodeDistribution(NodeDistributionType.SAME_WITH_SOME_CHILD, context.getNodeDistribution((PlanNodeId)((DeviceViewNode)deviceViewNodeList.get((int)0)).getPlanNodeId()).region));
        for (int i = 1; i < deviceViewNodeList.size(); ++i) {
            PlanNode child = (PlanNode)deviceViewNodeList.get(i);
            ExchangeNode exchangeNode = new ExchangeNode(context.queryContext.getQueryId().genPlanNodeId());
            exchangeNode.setChild(child);
            exchangeNode.setOutputColumnNames(child.getOutputColumnNames());
            deviceMergeNode.addChild(exchangeNode);
        }
        return deviceMergeNode;
    }

    private PlanNode processMultiChildNode(MultiChildProcessNode node, NodeGroupContext context) {
        MultiChildProcessNode newNode = (MultiChildProcessNode)node.clone();
        ArrayList<PlanNode> visitedChildren = new ArrayList<PlanNode>();
        node.getChildren().forEach(child -> visitedChildren.add(this.visit((PlanNode)child, context)));
        TRegionReplicaSet dataRegion = this.calculateDataRegionByChildren(visitedChildren, context);
        NodeDistributionType distributionType = this.nodeDistributionIsSame(visitedChildren, context) ? NodeDistributionType.SAME_WITH_ALL_CHILDREN : NodeDistributionType.SAME_WITH_SOME_CHILD;
        context.putNodeDistribution(newNode.getPlanNodeId(), new NodeDistribution(distributionType, dataRegion));
        if (distributionType == NodeDistributionType.SAME_WITH_ALL_CHILDREN) {
            newNode.setChildren(visitedChildren);
            return newNode;
        }
        visitedChildren.forEach(child -> {
            if (context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).region != DataPartition.NOT_ASSIGNED && !dataRegion.equals(context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).region)) {
                ExchangeNode exchangeNode = new ExchangeNode(context.queryContext.getQueryId().genPlanNodeId());
                exchangeNode.setChild((PlanNode)child);
                exchangeNode.setOutputColumnNames(child.getOutputColumnNames());
                newNode.addChild(exchangeNode);
            } else {
                newNode.addChild((PlanNode)child);
            }
        });
        return newNode;
    }

    @Override
    public PlanNode visitSlidingWindowAggregation(SlidingWindowAggregationNode node, NodeGroupContext context) {
        return this.processOneChildNode(node, context);
    }

    private PlanNode processOneChildNode(PlanNode node, NodeGroupContext context) {
        PlanNode newNode = node.clone();
        PlanNode child = this.visit(node.getChildren().get(0), context);
        newNode.addChild(child);
        TRegionReplicaSet dataRegion = context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).region;
        context.putNodeDistribution(newNode.getPlanNodeId(), new NodeDistribution(NodeDistributionType.SAME_WITH_ALL_CHILDREN, dataRegion));
        return newNode;
    }

    private TRegionReplicaSet calculateDataRegionByChildren(List<PlanNode> children, NodeGroupContext context) {
        Map<TRegionReplicaSet, Long> groupByRegion = children.stream().collect(Collectors.groupingBy(child -> {
            TRegionReplicaSet region = context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).region;
            if (region == null && context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).type == NodeDistributionType.SAME_WITH_ALL_CHILDREN) {
                return this.calculateSchemaRegionByChildren(child.getChildren(), context);
            }
            return region;
        }, Collectors.counting()));
        if (groupByRegion.entrySet().size() == 1) {
            return groupByRegion.entrySet().iterator().next().getKey();
        }
        return (TRegionReplicaSet)Collections.max(groupByRegion.entrySet().stream().filter(e -> e.getKey() != DataPartition.NOT_ASSIGNED).collect(Collectors.toList()), Map.Entry.comparingByValue()).getKey();
    }

    private TRegionReplicaSet calculateSchemaRegionByChildren(List<PlanNode> children, NodeGroupContext context) {
        return context.getNodeDistribution((PlanNodeId)children.get((int)0).getPlanNodeId()).region;
    }

    private boolean nodeDistributionIsSame(List<PlanNode> children, NodeGroupContext context) {
        NodeDistribution first = context.getNodeDistribution(children.get(0).getPlanNodeId());
        for (int i = 1; i < children.size(); ++i) {
            NodeDistribution next = context.getNodeDistribution(children.get(i).getPlanNodeId());
            if (first.region != null && first.region.equals(next.region)) continue;
            return false;
        }
        return true;
    }

    private boolean isAggregationQuery() {
        return ((QueryStatement)this.analysis.getStatement()).isAggregationQuery();
    }

    public PlanNode visit(PlanNode node, NodeGroupContext context) {
        return node.accept(this, context);
    }

    private static class DeviceViewGroup {
        public TRegionReplicaSet regionReplicaSet;
        public List<PlanNode> children;
        public List<String> devices;

        public DeviceViewGroup(TRegionReplicaSet regionReplicaSet) {
            this.regionReplicaSet = regionReplicaSet;
            this.children = new LinkedList<PlanNode>();
            this.devices = new LinkedList<String>();
        }

        public void addChild(String device, PlanNode child) {
            this.devices.add(device);
            this.children.add(child);
        }

        public int hashCode() {
            return this.regionReplicaSet.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DeviceViewGroup) {
                return this.regionReplicaSet.equals(((DeviceViewGroup)o).regionReplicaSet);
            }
            return false;
        }
    }
}

