/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateMultiTimeSeriesNode
extends WritePlanNode {
    private static final int SPLIT_SIZE = IoTDBDescriptor.getInstance().getConfig().getMaxMeasurementNumOfInternalRequest();
    private final Map<PartialPath, MeasurementGroup> measurementGroupMap;
    private TRegionReplicaSet regionReplicaSet;

    public CreateMultiTimeSeriesNode(PlanNodeId id) {
        super(id);
        this.measurementGroupMap = new HashMap<PartialPath, MeasurementGroup>();
    }

    public CreateMultiTimeSeriesNode(PlanNodeId id, List<PartialPath> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<String> aliasList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList) {
        super(id);
        this.measurementGroupMap = new HashMap<PartialPath, MeasurementGroup>();
        int size = paths.size();
        for (int i = 0; i < size; ++i) {
            PartialPath devicePath = paths.get(i).getDevicePath();
            MeasurementGroup measurementGroup = this.measurementGroupMap.get(devicePath);
            if (measurementGroup == null) {
                measurementGroup = new MeasurementGroup();
                this.measurementGroupMap.put(devicePath, measurementGroup);
            }
            measurementGroup.addMeasurement(paths.get(i).getMeasurement(), dataTypes.get(i), encodings.get(i), compressors.get(i));
            if (propsList != null) {
                measurementGroup.addProps(propsList.get(i));
            }
            if (aliasList != null) {
                measurementGroup.addAlias(aliasList.get(i));
            }
            if (tagsList != null) {
                measurementGroup.addTags(tagsList.get(i));
            }
            if (attributesList == null) continue;
            measurementGroup.addAttributes(attributesList.get(i));
        }
    }

    public CreateMultiTimeSeriesNode(PlanNodeId planNodeId, Map<PartialPath, MeasurementGroup> measurementGroupMap) {
        super(planNodeId);
        this.measurementGroupMap = measurementGroupMap;
    }

    private CreateMultiTimeSeriesNode(PlanNodeId planNodeId, Map<PartialPath, MeasurementGroup> measurementGroupMap, TRegionReplicaSet regionReplicaSet) {
        super(planNodeId);
        this.measurementGroupMap = measurementGroupMap;
        this.regionReplicaSet = regionReplicaSet;
    }

    private void addMeasurementGroup(PartialPath devicePath, MeasurementGroup measurementGroup) {
        this.measurementGroupMap.put(devicePath, measurementGroup);
    }

    public Map<PartialPath, MeasurementGroup> getMeasurementGroupMap() {
        return this.measurementGroupMap;
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("Clone of CreateMultiTimeSeriesNode is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C schemaRegion) {
        return visitor.visitCreateMultiTimeSeries(this, schemaRegion);
    }

    public static CreateMultiTimeSeriesNode deserialize(ByteBuffer byteBuffer) {
        HashMap<PartialPath, MeasurementGroup> measurementGroupMap = new HashMap<PartialPath, MeasurementGroup>();
        int size = byteBuffer.getInt();
        for (int i = 0; i < size; ++i) {
            PartialPath devicePath = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
            MeasurementGroup measurementGroup = new MeasurementGroup();
            measurementGroup.deserialize(byteBuffer);
            measurementGroupMap.put(devicePath, measurementGroup);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new CreateMultiTimeSeriesNode(planNodeId, measurementGroupMap);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMultiTimeSeriesNode that = (CreateMultiTimeSeriesNode)o;
        return this.getPlanNodeId().equals(that.getPlanNodeId()) && Objects.equals(this.measurementGroupMap, that.measurementGroupMap);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.CREATE_MULTI_TIME_SERIES.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.measurementGroupMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<PartialPath, MeasurementGroup> entry : this.measurementGroupMap.entrySet()) {
            entry.getKey().serialize(byteBuffer);
            entry.getValue().serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.CREATE_MULTI_TIME_SERIES.serialize(stream);
        ReadWriteIOUtils.write((int)this.measurementGroupMap.size(), (OutputStream)stream);
        for (Map.Entry<PartialPath, MeasurementGroup> entry : this.measurementGroupMap.entrySet()) {
            entry.getKey().serialize((OutputStream)stream);
            entry.getValue().serialize(stream);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPlanNodeId(), this.measurementGroupMap);
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        HashMap<TRegionReplicaSet, Map> splitMap = new HashMap<TRegionReplicaSet, Map>();
        for (Map.Entry<PartialPath, MeasurementGroup> entry : this.measurementGroupMap.entrySet()) {
            TRegionReplicaSet regionReplicaSet = analysis.getSchemaPartitionInfo().getSchemaRegionReplicaSet(entry.getKey().getFullPath());
            splitMap.computeIfAbsent(regionReplicaSet, k -> new HashMap()).put(entry.getKey(), entry.getValue());
        }
        ArrayList<WritePlanNode> result = new ArrayList<WritePlanNode>();
        for (Map.Entry entry : splitMap.entrySet()) {
            for (Map<PartialPath, MeasurementGroup> measurementGroupMap : CreateMultiTimeSeriesNode.splitAndRegroupMeasurements((Map)entry.getValue())) {
                result.add(new CreateMultiTimeSeriesNode(this.getPlanNodeId(), measurementGroupMap, (TRegionReplicaSet)entry.getKey()));
            }
        }
        return result;
    }

    private static List<Map<PartialPath, MeasurementGroup>> splitAndRegroupMeasurements(Map<PartialPath, MeasurementGroup> measurementGroupMap) {
        ArrayList<Map<PartialPath, MeasurementGroup>> result = new ArrayList<Map<PartialPath, MeasurementGroup>>();
        int tmpSum = 0;
        HashMap<PartialPath, MeasurementGroup> tmpMap = new HashMap<PartialPath, MeasurementGroup>();
        for (Map.Entry<PartialPath, MeasurementGroup> entry : measurementGroupMap.entrySet()) {
            if (entry.getValue().size() > SPLIT_SIZE) {
                for (MeasurementGroup splitMeasurementGroup : entry.getValue().split(SPLIT_SIZE)) {
                    if (splitMeasurementGroup.size() == SPLIT_SIZE) {
                        HashMap<PartialPath, MeasurementGroup> singletonMap = new HashMap<PartialPath, MeasurementGroup>();
                        singletonMap.put(entry.getKey(), splitMeasurementGroup);
                        result.add(singletonMap);
                        continue;
                    }
                    if (tmpSum + splitMeasurementGroup.size() > SPLIT_SIZE) {
                        result.add(tmpMap);
                        tmpMap = new HashMap();
                        tmpSum = 0;
                    }
                    tmpSum += splitMeasurementGroup.size();
                    tmpMap.put(entry.getKey(), splitMeasurementGroup);
                }
                continue;
            }
            if (tmpSum + entry.getValue().size() > SPLIT_SIZE) {
                result.add(tmpMap);
                tmpMap = new HashMap();
                tmpSum = 0;
            }
            tmpSum += entry.getValue().size();
            tmpMap.put(entry.getKey(), entry.getValue());
        }
        if (!tmpMap.isEmpty()) {
            result.add(tmpMap);
        }
        return result;
    }
}

