/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp;

import java.time.ZoneId;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.PathNumOverLimitException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectIntoOperator;
import org.apache.iotdb.db.qp.logical.crud.WhereComponent;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.strategy.LogicalChecker;
import org.apache.iotdb.db.qp.strategy.LogicalGenerator;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.DnfFilterOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.MergeSingleFilterOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.RemoveNotOptimizer;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;

public class Planner {
    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr) throws QueryProcessException {
        return this.parseSQLToPhysicalPlan(sqlStr, ZoneId.systemDefault(), IoTDBConstant.ClientVersion.V_0_13);
    }

    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr, ZoneId zoneId, IoTDBConstant.ClientVersion clientVersion) throws QueryProcessException {
        Operator operator = LogicalGenerator.generate(sqlStr, zoneId, clientVersion);
        return this.generatePhysicalPlanFromOperator(operator, clientVersion);
    }

    public PhysicalPlan rawDataQueryReqToPhysicalPlan(TSRawDataQueryReq rawDataQueryReq, ZoneId zoneId, IoTDBConstant.ClientVersion clientVersion) throws IllegalPathException, QueryProcessException {
        Operator operator = LogicalGenerator.generate(rawDataQueryReq, zoneId);
        return this.generatePhysicalPlanFromOperator(operator, clientVersion);
    }

    public PhysicalPlan lastDataQueryReqToPhysicalPlan(TSLastDataQueryReq lastDataQueryReq, ZoneId zoneId, IoTDBConstant.ClientVersion clientVersion) throws QueryProcessException, IllegalPathException {
        Operator operator = LogicalGenerator.generate(lastDataQueryReq, zoneId);
        return this.generatePhysicalPlanFromOperator(operator, clientVersion);
    }

    public PhysicalPlan operatorToPhysicalPlan(Operator operator) throws QueryProcessException {
        return this.generatePhysicalPlanFromOperator(operator, IoTDBConstant.ClientVersion.V_0_13);
    }

    private PhysicalPlan generatePhysicalPlanFromOperator(Operator operator, IoTDBConstant.ClientVersion clientVersion) throws QueryProcessException {
        operator.setPrefixMatchPath(IoTDBConstant.ClientVersion.V_0_12.equals((Object)clientVersion));
        LogicalChecker.check(operator);
        operator = this.logicalOptimize(operator);
        return this.generatePhysicalPlanFromOperator(operator);
    }

    protected PhysicalPlan generatePhysicalPlanFromOperator(Operator operator) throws QueryProcessException {
        return new PhysicalGenerator().transformToPhysicalPlan(operator);
    }

    protected Operator logicalOptimize(Operator operator) throws LogicalOperatorException, PathNumOverLimitException {
        switch (operator.getType()) {
            case QUERY: 
            case QUERY_INDEX: {
                return this.optimizeQueryOperator((QueryOperator)operator);
            }
            case SELECT_INTO: {
                return this.optimizeSelectIntoOperator((SelectIntoOperator)operator);
            }
        }
        return operator;
    }

    private QueryOperator optimizeQueryOperator(QueryOperator root) throws LogicalOperatorException, PathNumOverLimitException {
        WhereComponent whereComponent = (root = (QueryOperator)new ConcatPathOptimizer().transform(root)).getWhereComponent();
        if (whereComponent == null) {
            return root;
        }
        FilterOperator filter = whereComponent.getFilterOperator();
        filter = new RemoveNotOptimizer().optimize(filter);
        filter = new DnfFilterOptimizer().optimize(filter);
        filter = new MergeSingleFilterOptimizer().optimize(filter);
        whereComponent.setFilterOperator(filter);
        return root;
    }

    private Operator optimizeSelectIntoOperator(SelectIntoOperator operator) throws PathNumOverLimitException, LogicalOperatorException {
        operator.setQueryOperator(this.optimizeQueryOperator(operator.getQueryOperator()));
        return operator;
    }
}

