/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.query.dataset.ShowResult;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ShowTimeSeriesResult
extends ShowResult {
    private String alias;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressor;
    private Map<String, String> tags;
    private Map<String, String> attributes;
    private long lastTime;
    private String deadband;
    private String deadbandParameters;

    public ShowTimeSeriesResult(String name, String alias, String sgName, TSDataType dataType, TSEncoding encoding, CompressionType compressor, long lastTime, Map<String, String> tags, Map<String, String> attributes, String deadband, String deadbandParameters) {
        super(name, sgName);
        this.alias = alias;
        this.dataType = dataType;
        this.encoding = encoding;
        this.compressor = compressor;
        this.tags = tags;
        this.attributes = attributes;
        this.lastTime = lastTime;
        this.deadband = deadband;
        this.deadbandParameters = deadbandParameters;
    }

    public ShowTimeSeriesResult() {
    }

    public String getAlias() {
        return this.alias;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public Map<String, String> getTag() {
        return this.tags;
    }

    public Map<String, String> getAttribute() {
        return this.attributes;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public String getDeadband() {
        return this.deadband;
    }

    public String getDeadbandParameters() {
        return this.deadbandParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShowTimeSeriesResult result = (ShowTimeSeriesResult)o;
        return Objects.equals(this.name, result.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    private void writeNullable(Map<String, String> param, OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((Boolean)(param != null ? 1 : 0), (OutputStream)outputStream);
        if (param != null) {
            ReadWriteIOUtils.write((int)param.size(), (OutputStream)outputStream);
            for (Map.Entry<String, String> entry : param.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)entry.getValue(), (OutputStream)outputStream);
            }
        }
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)(this.alias != null ? 1 : 0), (OutputStream)outputStream);
        if (this.alias != null) {
            ReadWriteIOUtils.write((String)this.alias, (OutputStream)outputStream);
        }
        ReadWriteIOUtils.write((String)this.sgName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((TSDataType)this.dataType, (OutputStream)outputStream);
        ReadWriteIOUtils.write((TSEncoding)this.encoding, (OutputStream)outputStream);
        ReadWriteIOUtils.write((CompressionType)this.compressor, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.lastTime, (OutputStream)outputStream);
        this.writeNullable(this.tags, outputStream);
        this.writeNullable(this.attributes, outputStream);
    }

    public static ShowTimeSeriesResult deserialize(ByteBuffer buffer) {
        String value;
        String key;
        int i;
        ShowTimeSeriesResult result = new ShowTimeSeriesResult();
        result.name = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        if (buffer.get() == 1) {
            result.alias = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
        result.sgName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        result.dataType = ReadWriteIOUtils.readDataType((ByteBuffer)buffer);
        result.encoding = ReadWriteIOUtils.readEncoding((ByteBuffer)buffer);
        result.compressor = ReadWriteIOUtils.readCompressionType((ByteBuffer)buffer);
        result.lastTime = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        if (buffer.get() == 1) {
            int tagSize = buffer.getInt();
            result.tags = new HashMap<String, String>(tagSize);
            for (i = 0; i < tagSize; ++i) {
                key = ReadWriteIOUtils.readString((ByteBuffer)buffer);
                value = ReadWriteIOUtils.readString((ByteBuffer)buffer);
                result.tags.put(key, value);
            }
        }
        if (buffer.get() == 1) {
            int attributeSize = buffer.getInt();
            result.attributes = new HashMap<String, String>(attributeSize);
            for (i = 0; i < attributeSize; ++i) {
                key = ReadWriteIOUtils.readString((ByteBuffer)buffer);
                value = ReadWriteIOUtils.readString((ByteBuffer)buffer);
                result.attributes.put(key, value);
            }
        }
        return result;
    }
}

