/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.io.File;
import java.io.UncheckedIOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.TsFileMetricManager;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetrics
implements IMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(FileMetrics.class);
    private Future<?> currentServiceFuture;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private long walFileTotalSize = 0L;
    private long walFileTotalCount = 0L;
    private long sequenceFileTotalSize = 0L;
    private long sequenceFileTotalCount = 0L;
    private long unsequenceFileTotalSize = 0L;
    private long unsequenceFileTotalCount = 0L;

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getWalFileTotalSize, new String[]{Tag.NAME.toString(), "wal"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getSequenceFileTotalSize, new String[]{Tag.NAME.toString(), "seq"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getUnsequenceFileTotalSize, new String[]{Tag.NAME.toString(), "unseq"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getWalFileTotalCount, new String[]{Tag.NAME.toString(), "wal"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getSequenceFileTotalCount, new String[]{Tag.NAME.toString(), "seq"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getUnsequenceFileTotalCount, new String[]{Tag.NAME.toString(), "unseq"});
        if (null == this.currentServiceFuture) {
            this.currentServiceFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.service, this::collect, (long)1L, (long)MetricConfigDescriptor.getInstance().getMetricConfig().getAsyncCollectPeriodInSecond().intValue(), (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        if (this.currentServiceFuture != null) {
            this.currentServiceFuture.cancel(true);
            this.currentServiceFuture = null;
        }
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "wal"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "wal"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "unseq"});
    }

    private void collect() {
        String[] walDirs = CommonDescriptor.getInstance().getConfig().getWalDirs();
        this.walFileTotalSize = WALManager.getInstance().getTotalDiskUsage();
        this.sequenceFileTotalSize = TsFileMetricManager.getInstance().getFileSize(true);
        this.unsequenceFileTotalSize = TsFileMetricManager.getInstance().getFileSize(false);
        this.walFileTotalCount = Stream.of(walDirs).mapToLong(dir -> {
            File walFolder = new File((String)dir);
            if (walFolder.exists()) {
                File[] walNodeFolders = walFolder.listFiles(File::isDirectory);
                long result = 0L;
                if (null != walNodeFolders) {
                    for (File walNodeFolder : walNodeFolders) {
                        if (!walNodeFolder.exists() || !walNodeFolder.isDirectory()) continue;
                        try {
                            result += (long)FileUtils.listFiles((File)walFolder, null, (boolean)true).size();
                        }
                        catch (UncheckedIOException exception) {
                            logger.debug("Failed when count wal folder {}: ", (Object)walNodeFolder.getName(), (Object)exception);
                        }
                    }
                }
                return result;
            }
            return 0L;
        }).sum();
        this.sequenceFileTotalCount = TsFileMetricManager.getInstance().getFileNum(true);
        this.unsequenceFileTotalCount = TsFileMetricManager.getInstance().getFileNum(false);
    }

    public long getWalFileTotalSize() {
        return this.walFileTotalSize;
    }

    public long getWalFileTotalCount() {
        return this.walFileTotalCount;
    }

    public long getSequenceFileTotalSize() {
        return this.sequenceFileTotalSize;
    }

    public long getSequenceFileTotalCount() {
        return this.sequenceFileTotalCount;
    }

    public long getUnsequenceFileTotalSize() {
        return this.unsequenceFileTotalSize;
    }

    public long getUnsequenceFileTotalCount() {
        return this.unsequenceFileTotalCount;
    }
}

