/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.common;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.sync.common.ISyncInfoFetcher;
import org.apache.iotdb.db.sync.common.LocalSyncInfo;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSyncInfoFetcher
implements ISyncInfoFetcher {
    private static final Logger logger = LoggerFactory.getLogger(LocalSyncInfoFetcher.class);
    private LocalSyncInfo localSyncInfo = new LocalSyncInfo();

    private LocalSyncInfoFetcher() {
    }

    @Override
    public TSStatus addPipeSink(CreatePipeSinkStatement createPipeSinkStatement) {
        try {
            this.localSyncInfo.addPipeSink(createPipeSinkStatement);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (IOException | PipeSinkException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    @Override
    public TSStatus dropPipeSink(String name) {
        try {
            this.localSyncInfo.dropPipeSink(name);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (IOException | PipeSinkException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    @Override
    public PipeSink getPipeSink(String name) {
        return this.localSyncInfo.getPipeSink(name);
    }

    @Override
    public List<PipeSink> getAllPipeSinks() {
        return this.localSyncInfo.getAllPipeSink();
    }

    @Override
    public TSStatus addPipe(PipeInfo pipeInfo) {
        try {
            this.localSyncInfo.addPipe(pipeInfo);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (PipeException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)e.getMessage());
        }
        catch (IOException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
        catch (PipeSinkException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.CREATE_PIPE_SINK_ERROR, (String)e.getMessage());
        }
    }

    @Override
    public TSStatus stopPipe(String pipeName) {
        try {
            this.localSyncInfo.operatePipe(pipeName, SyncOperation.STOP_PIPE);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (PipeException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)e.getMessage());
        }
        catch (IOException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    @Override
    public TSStatus startPipe(String pipeName) {
        try {
            this.localSyncInfo.operatePipe(pipeName, SyncOperation.START_PIPE);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (PipeException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)e.getMessage());
        }
        catch (IOException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    @Override
    public TSStatus dropPipe(String pipeName) {
        try {
            this.localSyncInfo.operatePipe(pipeName, SyncOperation.DROP_PIPE);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (PipeException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)e.getMessage());
        }
        catch (IOException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    @Override
    public List<PipeInfo> getAllPipeInfos() {
        return this.localSyncInfo.getAllPipeInfos();
    }

    @Override
    public TSStatus recordMsg(String pipeName, PipeMessage pipeMessage) {
        this.localSyncInfo.changePipeMessage(pipeName, pipeMessage.getType());
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public static LocalSyncInfoFetcher getInstance() {
        return LocalSyncInfoFetcherHolder.INSTANCE;
    }

    public void reset() {
        this.localSyncInfo = new LocalSyncInfo();
    }

    public void close() throws IOException {
        this.localSyncInfo.close();
    }

    private static class LocalSyncInfoFetcherHolder {
        private static final LocalSyncInfoFetcher INSTANCE = new LocalSyncInfoFetcher();

        private LocalSyncInfoFetcherHolder() {
        }
    }
}

