/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.externalpipe.operation;

public abstract class Operation {
    private OperationType operationType;
    private final String storageGroup;
    private long startIndex;
    private long endIndex;

    public Operation(OperationType operationType, String storageGroup, long startIndex, long endIndex) {
        this.operationType = operationType;
        this.storageGroup = storageGroup;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String getOperationTypeName() {
        return this.operationType.name();
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public long getEndIndex() {
        return this.endIndex;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public long getDataCount() {
        return this.endIndex - this.startIndex;
    }

    public String toString() {
        return "operationType=" + this.getOperationTypeName() + ", storageGroup=" + this.storageGroup + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex;
    }

    public static enum OperationType {
        INSERT,
        DELETE;

    }
}

