/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryChecker;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBStartCheck {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBStartCheck.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    public static final String PROPERTIES_FILE_NAME = "system.properties";
    private static final String SCHEMA_DIR = config.getSchemaDir();
    private boolean isFirstStart = false;
    private final File propertiesFile;
    private final File tmpPropertiesFile;
    private Properties properties = new Properties();
    private final Map<String, Supplier<String>> systemProperties = new HashMap<String, Supplier<String>>();
    private static final String SYSTEM_PROPERTIES_STRING = "System properties:";
    private static final String TIMESTAMP_PRECISION_STRING = "timestamp_precision";
    private static final String PARTITION_INTERVAL_STRING = "time_partition_interval";
    private static final String TSFILE_FILE_SYSTEM_STRING = "tsfile_storage_fs";
    private static final String TAG_ATTRIBUTE_SIZE_STRING = "tag_attribute_total_size";
    private static final String TAG_ATTRIBUTE_FLUSH_INTERVAL = "tag_attribute_flush_interval";
    private static final String MAX_DEGREE_OF_INDEX_STRING = "max_degree_of_index_node";
    private static final String DATA_REGION_NUM = "data_region_num";
    private static final String ENABLE_ID_TABLE = "enable_id_table";
    private static final String ENABLE_ID_TABLE_LOG_FILE = "enable_id_table_log_file";
    private static final String SCHEMA_ENGINE_MODE = "schema_engine_mode";
    private static final String TIME_ENCODER_KEY = "time_encoder";
    private static final Map<String, Supplier<String>> constantParamValueTable = new HashMap<String, Supplier<String>>();
    private static final String INTERNAL_ADDRESS = "dn_internal_address";
    private static final String INTERNAL_PORT = "dn_internal_port";
    private static final String RPC_ADDRESS = "dn_rpc_address";
    private static final String RPC_PORT = "dn_rpc_port";
    private static final String MPP_DATA_EXCHANGE_PORT = "dn_mpp_data_exchange_port";
    private static final String SCHEMA_REGION_CONSENSUS_PORT = "dn_schema_region_consensus_port";
    private static final String DATA_REGION_CONSENSUS_PORT = "dn_data_region_consensus_port";
    private static final Map<String, Supplier<String>> variableParamValueTable;
    private static final String IOTDB_VERSION_STRING = "iotdb_version";
    private static final String DATA_NODE_ID = "data_node_id";
    private static final String SCHEMA_REGION_CONSENSUS_PROTOCOL = "schema_region_consensus_protocol";
    private static final String DATA_REGION_CONSENSUS_PROTOCOL = "data_region_consensus_protocol";
    private static final String VIRTUAL_STORAGE_GROUP_NUM = "virtual_storage_group_num";

    public static IoTDBStartCheck getInstance() {
        return IoTDBConfigCheckHolder.INSTANCE;
    }

    private String getVal(String paramName) {
        if (constantParamValueTable.containsKey(paramName)) {
            return constantParamValueTable.get(paramName).get();
        }
        if (variableParamValueTable.containsKey(paramName)) {
            return variableParamValueTable.get(paramName).get();
        }
        return null;
    }

    private IoTDBStartCheck() {
        logger.info("Starting IoTDB " + IoTDBConstant.VERSION_WITH_BUILD);
        File dir = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                logger.error("can not create schema dir: {}", (Object)SCHEMA_DIR);
                System.exit(-1);
            } else {
                logger.info(" {} dir has been created.", (Object)SCHEMA_DIR);
            }
        }
        this.propertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME);
        this.tmpPropertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME + ".tmp");
        String timestampPrecision = this.getVal(TIMESTAMP_PRECISION_STRING);
        if (!("ms".equals(timestampPrecision) || "us".equals(timestampPrecision) || "ns".equals(timestampPrecision))) {
            logger.error("Wrong {}, please set as: ms, us or ns ! Current is: {}", (Object)TIMESTAMP_PRECISION_STRING, (Object)timestampPrecision);
            System.exit(-1);
        }
        if (Long.parseLong(this.getVal(PARTITION_INTERVAL_STRING)) <= 0L) {
            logger.error("Time partition interval must larger than 0!");
            System.exit(-1);
        }
        this.systemProperties.put(IOTDB_VERSION_STRING, () -> IoTDBConstant.VERSION);
        for (String param : constantParamValueTable.keySet()) {
            this.systemProperties.put(param, () -> this.getVal(param));
        }
        for (String param : variableParamValueTable.keySet()) {
            this.systemProperties.put(param, () -> this.getVal(param));
        }
    }

    public boolean checkIsFirstStart() throws IOException {
        if (!this.propertiesFile.exists() && !this.tmpPropertiesFile.exists()) {
            if (this.propertiesFile.createNewFile()) {
                logger.info(" {} has been created.", (Object)this.propertiesFile.getAbsolutePath());
            } else {
                logger.error("can not create {}", (Object)this.propertiesFile.getAbsolutePath());
                System.exit(-1);
            }
            try (FileOutputStream outputStream = new FileOutputStream(this.propertiesFile);){
                this.systemProperties.forEach((k, v) -> this.properties.setProperty((String)k, (String)v.get()));
                this.properties.store(outputStream, SYSTEM_PROPERTIES_STRING);
            }
            this.isFirstStart = true;
            return true;
        }
        if (!this.propertiesFile.exists() && this.tmpPropertiesFile.exists()) {
            FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
            logger.info("rename {} to {}", (Object)this.tmpPropertiesFile, (Object)this.propertiesFile);
            this.isFirstStart = false;
            return false;
        }
        if (this.propertiesFile.exists() && this.tmpPropertiesFile.exists()) {
            FileUtils.forceDelete((File)this.tmpPropertiesFile);
            logger.info("remove {}", (Object)this.tmpPropertiesFile);
        }
        this.isFirstStart = false;
        return false;
    }

    public void checkDirectory() throws ConfigurationException, IOException {
        for (String dataDir : config.getDataDirs()) {
            DirectoryChecker.getInstance().registerDirectory(new File(dataDir));
        }
        if (config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && DirectoryChecker.getInstance().isCrossDisk(config.getDataDirs())) {
            throw new ConfigurationException("Configuring the data directories as cross-disk directories is not supported under RatisConsensus(it will be supported in a later version).");
        }
        DirectoryChecker.getInstance().registerDirectory(new File(config.getSystemDir()));
        if (!(config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") || config.getWalMode().equals((Object)WALMode.DISABLE))) {
            for (String walDir : commonConfig.getWalDirs()) {
                DirectoryChecker.getInstance().registerDirectory(new File(walDir));
            }
        }
        if (config.isClusterMode()) {
            DirectoryChecker.getInstance().registerDirectory(new File(config.getConsensusDir()));
        }
    }

    public void checkSystemConfig() throws ConfigurationException, IOException {
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET);){
            this.properties.load(inputStreamReader);
        }
        if (this.isFirstStart) {
            try (FileOutputStream outputStream = new FileOutputStream(this.propertiesFile);){
                this.systemProperties.forEach((k, v) -> this.properties.setProperty((String)k, (String)v.get()));
                this.properties.store(outputStream, SYSTEM_PROPERTIES_STRING);
            }
            if (config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus") && config.getWalMode().equals((Object)WALMode.DISABLE)) {
                throw new ConfigurationException("Configuring the WALMode as disable is not supported under IoTConsensus");
            }
        } else {
            String versionString;
            if (!this.properties.containsKey(IOTDB_VERSION_STRING)) {
                logger.error("DO NOT UPGRADE IoTDB from v0.9 or lower version to v1.0! Please upgrade to v0.10 first");
                System.exit(-1);
            }
            if ((versionString = this.properties.getProperty(IOTDB_VERSION_STRING)).startsWith("0.10") || versionString.startsWith("0.11")) {
                logger.error("IoTDB version is too old, please upgrade to 0.12 firstly.");
                System.exit(-1);
            } else if (versionString.startsWith("0.12") || versionString.startsWith("0.13")) {
                this.checkWALNotExists();
                this.upgradePropertiesFile();
            }
            this.checkProperties();
        }
    }

    private void checkWALNotExists() {
        for (String walDir : commonConfig.getWalDirs()) {
            File[] sgWALs;
            if (!SystemFileFactory.INSTANCE.getFile(walDir).isDirectory() || (sgWALs = SystemFileFactory.INSTANCE.getFile(walDir).listFiles()) == null) continue;
            for (File sgWAL : sgWALs) {
                if (!sgWAL.isDirectory() || sgWAL.list().length == 0) continue;
                logger.error("WAL detected, please stop insertion and run 'SET SYSTEM TO READONLY', then run 'flush' on IoTDB {} before upgrading to {}.", (Object)this.properties.getProperty(IOTDB_VERSION_STRING), (Object)IoTDBConstant.VERSION);
                System.exit(-1);
            }
        }
    }

    private void upgradePropertiesFile() throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.systemProperties.forEach((k, v) -> {
                if (!this.properties.containsKey(k)) {
                    this.properties.setProperty((String)k, (String)v.get());
                }
            });
            this.properties.setProperty(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
            this.properties.setProperty(DATA_REGION_NUM, this.properties.getProperty(VIRTUAL_STORAGE_GROUP_NUM));
            this.properties.remove(VIRTUAL_STORAGE_GROUP_NUM);
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    private void upgradePropertiesFileFromBrokenFile() throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.systemProperties.forEach((k, v) -> {
                if (!this.properties.containsKey(k)) {
                    this.properties.setProperty((String)k, (String)v.get());
                }
            });
            this.properties.setProperty(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    private void checkProperties() throws ConfigurationException, IOException {
        for (Map.Entry<String, Supplier<String>> entry : this.systemProperties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.upgradePropertiesFileFromBrokenFile();
            logger.info("repair system.properties, lack {}", (Object)entry.getKey());
        }
        for (String param : constantParamValueTable.keySet()) {
            if (this.properties.getProperty(param).equals(this.getVal(param))) continue;
            this.throwException(param, this.getVal(param));
        }
        if (this.properties.containsKey("cluster_name")) {
            config.setClusterName(this.properties.getProperty("cluster_name"));
        }
        if (this.properties.containsKey(DATA_NODE_ID)) {
            config.setDataNodeId(Integer.parseInt(this.properties.getProperty(DATA_NODE_ID)));
        }
        if (this.properties.containsKey(SCHEMA_REGION_CONSENSUS_PROTOCOL)) {
            config.setSchemaRegionConsensusProtocolClass(this.properties.getProperty(SCHEMA_REGION_CONSENSUS_PROTOCOL));
        }
        if (this.properties.containsKey(DATA_REGION_CONSENSUS_PROTOCOL)) {
            config.setDataRegionConsensusProtocolClass(this.properties.getProperty(DATA_REGION_CONSENSUS_PROTOCOL));
        }
    }

    private void throwException(String parameter, Object badValue) throws ConfigurationException {
        throw new ConfigurationException(parameter, String.valueOf(badValue), this.properties.getProperty(parameter));
    }

    private void reloadProperties() throws IOException {
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET);){
            this.properties.load(inputStreamReader);
        }
    }

    public void serializeClusterNameAndDataNodeId(String clusterName, int dataNodeId) throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        this.reloadProperties();
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.properties.setProperty("cluster_name", clusterName);
            this.properties.setProperty(DATA_NODE_ID, String.valueOf(dataNodeId));
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    public void serializeGlobalConfig(TGlobalConfig globalConfig) throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        this.reloadProperties();
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            if (!this.checkConsensusProtocolExists(TConsensusGroupType.DataRegion)) {
                this.properties.setProperty(DATA_REGION_CONSENSUS_PROTOCOL, globalConfig.getDataRegionConsensusProtocolClass());
            }
            if (!this.checkConsensusProtocolExists(TConsensusGroupType.SchemaRegion)) {
                this.properties.setProperty(SCHEMA_REGION_CONSENSUS_PROTOCOL, globalConfig.getSchemaRegionConsensusProtocolClass());
            }
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    public boolean checkConsensusProtocolExists(TConsensusGroupType type) {
        if (type == TConsensusGroupType.DataRegion) {
            return this.properties.containsKey(DATA_REGION_CONSENSUS_PROTOCOL);
        }
        if (type == TConsensusGroupType.SchemaRegion) {
            return this.properties.containsKey(SCHEMA_REGION_CONSENSUS_PROTOCOL);
        }
        logger.error("Unexpected consensus group type");
        return false;
    }

    static {
        constantParamValueTable.put(TIMESTAMP_PRECISION_STRING, config::getTimestampPrecision);
        constantParamValueTable.put(PARTITION_INTERVAL_STRING, () -> String.valueOf(config.getTimePartitionInterval()));
        constantParamValueTable.put(TSFILE_FILE_SYSTEM_STRING, () -> config.getTsFileStorageFs().toString());
        constantParamValueTable.put(TAG_ATTRIBUTE_SIZE_STRING, () -> String.valueOf(config.getTagAttributeTotalSize()));
        constantParamValueTable.put(TAG_ATTRIBUTE_FLUSH_INTERVAL, () -> String.valueOf(config.getTagAttributeFlushInterval()));
        constantParamValueTable.put(MAX_DEGREE_OF_INDEX_STRING, () -> String.valueOf(TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode()));
        constantParamValueTable.put(DATA_REGION_NUM, () -> String.valueOf(config.getDataRegionNum()));
        constantParamValueTable.put(ENABLE_ID_TABLE, () -> String.valueOf(config.isEnableIDTable()));
        constantParamValueTable.put(ENABLE_ID_TABLE_LOG_FILE, () -> String.valueOf(config.isEnableIDTableLogFile()));
        constantParamValueTable.put(SCHEMA_ENGINE_MODE, () -> String.valueOf(config.getSchemaEngineMode()));
        constantParamValueTable.put(TIME_ENCODER_KEY, () -> ((TSFileConfig)TSFileDescriptor.getInstance().getConfig()).getTimeEncoder());
        variableParamValueTable = new HashMap<String, Supplier<String>>();
        variableParamValueTable.put(INTERNAL_ADDRESS, () -> String.valueOf(config.getInternalAddress()));
        variableParamValueTable.put(INTERNAL_PORT, () -> String.valueOf(config.getInternalPort()));
        variableParamValueTable.put(RPC_ADDRESS, () -> String.valueOf(config.getRpcAddress()));
        variableParamValueTable.put(RPC_PORT, () -> String.valueOf(config.getRpcPort()));
        variableParamValueTable.put(MPP_DATA_EXCHANGE_PORT, () -> String.valueOf(config.getMppDataExchangePort()));
        variableParamValueTable.put(SCHEMA_REGION_CONSENSUS_PORT, () -> String.valueOf(config.getSchemaRegionConsensusPort()));
        variableParamValueTable.put(DATA_REGION_CONSENSUS_PORT, () -> String.valueOf(config.getDataRegionConsensusPort()));
    }

    private static class IoTDBConfigCheckHolder {
        private static final IoTDBStartCheck INSTANCE = new IoTDBStartCheck();

        private IoTDBConfigCheckHolder() {
        }
    }
}

