/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.TsFileMetricManager;
import org.apache.iotdb.db.engine.compaction.CompactionExceptionHandler;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.log.CompactionLogger;
import org.apache.iotdb.db.engine.compaction.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.SubCompactionTaskSummary;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSpaceCompactionTask
extends AbstractCompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected List<TsFileResource> selectedSequenceFiles;
    protected List<TsFileResource> selectedUnsequenceFiles;
    protected TsFileResourceList seqTsFileResourceList;
    protected TsFileResourceList unseqTsFileResourceList;
    private File logFile;
    protected List<TsFileResource> targetTsfileResourceList;
    protected List<TsFileResource> holdReadLockList = new ArrayList<TsFileResource>();
    protected List<TsFileResource> holdWriteLockList = new ArrayList<TsFileResource>();
    protected double selectedSeqFileSize = 0.0;
    protected double selectedUnseqFileSize = 0.0;
    protected long memoryCost = 0L;

    public CrossSpaceCompactionTask(long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedSequenceFiles, List<TsFileResource> selectedUnsequenceFiles, ICrossCompactionPerformer performer, AtomicInteger currentTaskNum, long memoryCost, long serialId) {
        super(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, currentTaskNum, serialId);
        this.selectedSequenceFiles = selectedSequenceFiles;
        this.selectedUnsequenceFiles = selectedUnsequenceFiles;
        this.seqTsFileResourceList = tsFileManager.getSequenceListByTimePartition(timePartition);
        this.unseqTsFileResourceList = tsFileManager.getUnsequenceListByTimePartition(timePartition);
        this.performer = performer;
        this.hashCode = this.toString().hashCode();
        this.memoryCost = memoryCost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCompaction() {
        try {
            SystemInfo.getInstance().addCompactionMemoryCost(this.memoryCost);
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted when allocating memory for compaction", (Throwable)e);
            return;
        }
        try {
            if (!this.tsFileManager.isAllowCompaction()) {
                return;
            }
            long startTime = System.currentTimeMillis();
            this.targetTsfileResourceList = TsFileNameGenerator.getCrossCompactionTargetFileResources(this.selectedSequenceFiles);
            if (this.targetTsfileResourceList.isEmpty() || this.selectedSequenceFiles.isEmpty() || this.selectedUnsequenceFiles.isEmpty()) {
                LOGGER.info("{}-{} [Compaction] Cross space compaction file list is empty, end it", (Object)this.storageGroupName, (Object)this.dataRegionId);
                return;
            }
            for (TsFileResource resource : this.selectedSequenceFiles) {
                this.selectedSeqFileSize += (double)resource.getTsFileSize();
            }
            for (TsFileResource resource : this.selectedUnsequenceFiles) {
                this.selectedUnseqFileSize += (double)resource.getTsFileSize();
            }
            LOGGER.info("{}-{} [Compaction] CrossSpaceCompaction task starts with {} seq files and {} unsequence files. Sequence files : {}, unsequence files : {} . Sequence files size is {} MB, unsequence file size is {} MB, total size is {} MB", new Object[]{this.storageGroupName, this.dataRegionId, this.selectedSequenceFiles.size(), this.selectedUnsequenceFiles.size(), this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.selectedSeqFileSize / 1024.0 / 1024.0, this.selectedUnseqFileSize / 1024.0 / 1024.0, (this.selectedSeqFileSize + this.selectedUnseqFileSize) / 1024.0 / 1024.0});
            this.logFile = new File(this.selectedSequenceFiles.get(0).getTsFile().getParent() + File.separator + this.targetTsfileResourceList.get(0).getTsFile().getName() + ".cross-compaction.log");
            try (CompactionLogger compactionLogger = new CompactionLogger(this.logFile);){
                compactionLogger.logFiles(this.selectedSequenceFiles, "source");
                compactionLogger.logFiles(this.selectedUnsequenceFiles, "source");
                compactionLogger.logFiles(this.targetTsfileResourceList, "target");
                compactionLogger.close();
                this.performer.setSourceFiles(this.selectedSequenceFiles, this.selectedUnsequenceFiles);
                this.performer.setTargetFiles(this.targetTsfileResourceList);
                this.performer.setSummary(this.summary);
                this.performer.perform();
                CompactionUtils.moveTargetFile(this.targetTsfileResourceList, false, this.storageGroupName + "-" + this.dataRegionId);
                CompactionUtils.combineModsInCrossCompaction(this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.targetTsfileResourceList);
                this.tsFileManager.replace(this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.targetTsfileResourceList, this.timePartition, true);
                if (IoTDBDescriptor.getInstance().getConfig().isEnableCompactionValidation() && !CompactionUtils.validateTsFileResources(this.tsFileManager, this.storageGroupName, this.timePartition)) {
                    LOGGER.error("Failed to pass compaction validation, source sequence files is: {}, unsequence files is {}, target files is {}", new Object[]{this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.targetTsfileResourceList});
                    throw new RuntimeException("Failed to pass compaction validation");
                }
                this.releaseReadAndLockWrite(this.selectedSequenceFiles);
                this.releaseReadAndLockWrite(this.selectedUnsequenceFiles);
                long sequenceFileSize = this.deleteOldFiles(this.selectedSequenceFiles);
                long unsequenceFileSize = this.deleteOldFiles(this.selectedUnsequenceFiles);
                TsFileMetricManager.getInstance().deleteFile(sequenceFileSize, true, this.selectedSequenceFiles.size());
                TsFileMetricManager.getInstance().deleteFile(unsequenceFileSize, false, this.selectedUnsequenceFiles.size());
                for (TsFileResource targetResource : this.targetTsfileResourceList) {
                    if (targetResource == null) continue;
                    TsFileMetricManager.getInstance().addFile(targetResource.getTsFileSize(), true);
                    targetResource.setStatus(TsFileResourceStatus.CLOSED);
                }
                CompactionUtils.deleteCompactionModsFile(this.selectedSequenceFiles, this.selectedUnsequenceFiles);
                if (this.logFile.exists()) {
                    FileUtils.delete((File)this.logFile);
                }
                if (this.performer instanceof FastCompactionPerformer) {
                    SubCompactionTaskSummary subTaskSummary = ((FastCompactionPerformer)this.performer).getSubTaskSummary();
                    LOGGER.info("CHUNK_NONE_OVERLAP num is {}, CHUNK_NONE_OVERLAP_BUT_DESERIALIZE num is {}, CHUNK_OVERLAP_OR_MODIFIED num is {}, PAGE_NONE_OVERLAP num is {}, PAGE_NONE_OVERLAP_BUT_DESERIALIZE num is {}, PAGE_OVERLAP_OR_MODIFIED num is {}, PAGE_FAKE_OVERLAP num is {}.", new Object[]{subTaskSummary.CHUNK_NONE_OVERLAP, subTaskSummary.CHUNK_NONE_OVERLAP_BUT_DESERIALIZE, subTaskSummary.CHUNK_OVERLAP_OR_MODIFIED, subTaskSummary.PAGE_NONE_OVERLAP, subTaskSummary.PAGE_NONE_OVERLAP_BUT_DESERIALIZE, subTaskSummary.PAGE_OVERLAP_OR_MODIFIED, subTaskSummary.PAGE_FAKE_OVERLAP});
                }
                long costTime = (System.currentTimeMillis() - startTime) / 1000L;
                LOGGER.info("{}-{} [Compaction] CrossSpaceCompaction task finishes successfully, time cost is {} s, compaction speed is {} MB/s", new Object[]{this.storageGroupName, this.dataRegionId, costTime, (this.selectedSeqFileSize + this.selectedUnseqFileSize) / 1024.0 / 1024.0 / (double)costTime});
            }
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof InterruptedException)) {
                LOGGER.error("{}-{} [Compaction] Meet errors in cross space compaction.", new Object[]{this.storageGroupName, this.dataRegionId, throwable});
            } else {
                LOGGER.warn("{}-{} [Compaction] Compaction interrupted", (Object)this.storageGroupName, (Object)this.dataRegionId);
                Thread.interrupted();
            }
            CompactionExceptionHandler.handleException(this.storageGroupName + "-" + this.dataRegionId, this.logFile, this.targetTsfileResourceList, this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.tsFileManager, this.timePartition, false, true);
        }
        finally {
            SystemInfo.getInstance().resetCompactionMemoryCost(this.memoryCost);
            this.releaseAllLock();
        }
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask otherTask) {
        if (!(otherTask instanceof CrossSpaceCompactionTask)) {
            return false;
        }
        CrossSpaceCompactionTask otherCrossCompactionTask = (CrossSpaceCompactionTask)otherTask;
        return this.selectedSequenceFiles.equals(otherCrossCompactionTask.selectedSequenceFiles) && this.selectedUnsequenceFiles.equals(otherCrossCompactionTask.selectedUnsequenceFiles) && this.performer.getClass().isInstance(otherCrossCompactionTask.performer);
    }

    private void releaseAllLock() {
        this.selectedSequenceFiles.forEach(x -> x.setStatus(TsFileResourceStatus.CLOSED));
        this.selectedUnsequenceFiles.forEach(x -> x.setStatus(TsFileResourceStatus.CLOSED));
        for (TsFileResource tsFileResource : this.holdReadLockList) {
            tsFileResource.readUnlock();
            tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        }
        for (TsFileResource tsFileResource : this.holdWriteLockList) {
            tsFileResource.writeUnlock();
            tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        }
        this.holdReadLockList.clear();
        this.holdWriteLockList.clear();
    }

    public List<TsFileResource> getSelectedSequenceFiles() {
        return this.selectedSequenceFiles;
    }

    @Override
    public void setSourceFilesToCompactionCandidate() {
        this.selectedSequenceFiles.forEach(x -> x.setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE));
        this.selectedUnsequenceFiles.forEach(x -> x.setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE));
    }

    public List<TsFileResource> getSelectedUnsequenceFiles() {
        return this.selectedUnsequenceFiles;
    }

    public String toString() {
        return this.storageGroupName + "-" + this.dataRegionId + "-" + this.timePartition + " task seq files are " + this.selectedSequenceFiles.toString() + " , unseq files are " + this.selectedUnsequenceFiles.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CrossSpaceCompactionTask)) {
            return false;
        }
        return this.equalsOtherTask((CrossSpaceCompactionTask)other);
    }

    @Override
    public void resetCompactionCandidateStatusForAllSourceFiles() {
        this.selectedSequenceFiles.forEach(x -> x.setStatus(TsFileResourceStatus.CLOSED));
        this.selectedUnsequenceFiles.forEach(x -> x.setStatus(TsFileResourceStatus.CLOSED));
    }

    private long deleteOldFiles(List<TsFileResource> tsFileResourceList) throws IOException {
        long totalSize = 0L;
        for (TsFileResource tsFileResource : tsFileResourceList) {
            totalSize += tsFileResource.getTsFileSize();
            tsFileResource.remove();
            LOGGER.info("[CrossSpaceCompaction] Delete TsFile :{}.", (Object)tsFileResource.getTsFile().getAbsolutePath());
        }
        return totalSize;
    }

    private void releaseReadAndLockWrite(List<TsFileResource> tsFileResourceList) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            tsFileResource.readUnlock();
            this.holdReadLockList.remove(tsFileResource);
            tsFileResource.writeLock();
            this.holdWriteLockList.add(tsFileResource);
        }
    }

    @Override
    public boolean checkValidAndSetMerging() {
        return this.addReadLock(this.selectedSequenceFiles) && this.addReadLock(this.selectedUnsequenceFiles);
    }

    private boolean addReadLock(List<TsFileResource> tsFileResourceList) {
        if (!this.tsFileManager.isAllowCompaction()) {
            return false;
        }
        try {
            for (TsFileResource tsFileResource : tsFileResourceList) {
                tsFileResource.readLock();
                this.holdReadLockList.add(tsFileResource);
                if (tsFileResource.isCompacting() || !tsFileResource.isClosed() || !tsFileResource.getTsFile().exists() || tsFileResource.isDeleted()) {
                    this.releaseAllLock();
                    return false;
                }
                tsFileResource.setStatus(TsFileResourceStatus.COMPACTING);
            }
        }
        catch (Throwable e) {
            this.releaseAllLock();
            throw e;
        }
        return true;
    }
}

