/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCrossCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class ReadPointCrossCompactionWriter
extends AbstractCrossCompactionWriter {
    public ReadPointCrossCompactionWriter(List<TsFileResource> targetResources, List<TsFileResource> seqFileResources) throws IOException {
        super(targetResources, seqFileResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(TimeColumn timestamps, Column[] columns, int subTaskId, int batchSize) throws IOException {
        this.checkTimeAndMayFlushChunkToCurrentFile(timestamps.getStartTime(), subTaskId);
        AlignedChunkWriterImpl chunkWriter = (AlignedChunkWriterImpl)this.chunkWriters[subTaskId];
        chunkWriter.write(timestamps, columns, batchSize);
        ReadPointCrossCompactionWriter readPointCrossCompactionWriter = this;
        synchronized (readPointCrossCompactionWriter) {
            TsFileResource resource = (TsFileResource)this.targetResources.get(this.seqFileIndexArray[subTaskId]);
            resource.updateStartTime(this.deviceId, timestamps.getStartTime());
            resource.updateEndTime(this.deviceId, timestamps.getEndTime());
        }
        int n = subTaskId;
        this.chunkPointNumArray[n] = this.chunkPointNumArray[n] + timestamps.getTimes().length;
        this.checkChunkSizeAndMayOpenANewChunk((TsFileIOWriter)this.targetFileWriters.get(this.seqFileIndexArray[subTaskId]), (IChunkWriter)chunkWriter, subTaskId, true);
        this.isDeviceExistedInTargetFiles[this.seqFileIndexArray[subTaskId]] = true;
        this.isEmptyFile[this.seqFileIndexArray[subTaskId]] = false;
        this.lastTime[subTaskId] = timestamps.getEndTime();
    }

    @Override
    protected TsFileSequenceReader getFileReader(TsFileResource resource) throws IOException {
        return FileReaderManager.getInstance().get(resource.getTsFilePath(), true);
    }

    @Override
    public boolean flushNonAlignedChunk(Chunk chunk, ChunkMetadata chunkMetadata, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointCrossCompactionWriter");
    }

    @Override
    public boolean flushAlignedChunk(Chunk timeChunk, IChunkMetadata timeChunkMetadata, List<Chunk> valueChunks, List<IChunkMetadata> valueChunkMetadatas, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointCrossCompactionWriter");
    }

    @Override
    public boolean flushNonAlignedPage(ByteBuffer compressedPageData, PageHeader pageHeader, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointCrossCompactionWriter");
    }

    @Override
    public boolean flushAlignedPage(ByteBuffer compressedTimePageData, PageHeader timePageHeader, List<ByteBuffer> compressedValuePageDatas, List<PageHeader> valuePageHeaders, int subTaskId) {
        throw new RuntimeException("Does not support this method in ReadPointCrossCompactionWriter");
    }
}

