/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.tsfile.utils.Pair;

public class DeviceGroupSchemaTree
implements ISchemaTree {
    private final Map<PartialPath, DeviceSchemaInfo> deviceSchemaInfoMap = new HashMap<PartialPath, DeviceSchemaInfo>();

    @Override
    public DeviceSchemaInfo searchDeviceSchemaInfo(PartialPath devicePath, List<String> measurements) {
        return this.deviceSchemaInfoMap.get(devicePath).getSubDeviceSchemaInfo(measurements);
    }

    @Override
    public boolean isEmpty() {
        return this.deviceSchemaInfoMap.isEmpty();
    }

    public void addDeviceInfo(DeviceSchemaInfo deviceSchemaInfo) {
        this.deviceSchemaInfoMap.put(deviceSchemaInfo.getDevicePath(), deviceSchemaInfo);
    }

    public void merge(DeviceGroupSchemaTree schemaTree) {
        this.deviceSchemaInfoMap.putAll(schemaTree.deviceSchemaInfoMap);
    }

    @Override
    public Pair<List<MeasurementPath>, Integer> searchMeasurementPaths(PartialPath pathPattern, int slimit, int soffset, boolean isPrefixMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pair<List<MeasurementPath>, Integer> searchMeasurementPaths(PartialPath pathPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<MeasurementPath> getAllMeasurement() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DeviceSchemaInfo> getMatchedDevices(PartialPath pathPattern, boolean isPrefixMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DeviceSchemaInfo> getMatchedDevices(PartialPath pathPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBelongedDatabase(String pathName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBelongedDatabase(PartialPath path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getDatabases() {
        throw new UnsupportedOperationException();
    }
}

