/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.impl;

import java.time.ZoneId;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandalonePartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandaloneSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.protocol.rest.RestApiService;
import org.apache.iotdb.db.protocol.rest.handler.AuthorizationHandler;
import org.apache.iotdb.db.protocol.rest.handler.ExceptionHandler;
import org.apache.iotdb.db.protocol.rest.handler.ExecuteStatementHandler;
import org.apache.iotdb.db.protocol.rest.handler.QueryDataSetHandler;
import org.apache.iotdb.db.protocol.rest.handler.RequestValidationHandler;
import org.apache.iotdb.db.protocol.rest.handler.StatementConstructionHandler;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.model.SQL;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;

public class RestApiServiceImpl
extends RestApiService {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final IPartitionFetcher PARTITION_FETCHER;
    private final ISchemaFetcher SCHEMA_FETCHER;
    private final AuthorizationHandler authorizationHandler;
    private final Integer defaultQueryRowLimit;

    public RestApiServiceImpl() {
        if (config.isClusterMode()) {
            this.PARTITION_FETCHER = ClusterPartitionFetcher.getInstance();
            this.SCHEMA_FETCHER = ClusterSchemaFetcher.getInstance();
        } else {
            this.PARTITION_FETCHER = StandalonePartitionFetcher.getInstance();
            this.SCHEMA_FETCHER = StandaloneSchemaFetcher.getInstance();
        }
        this.authorizationHandler = new AuthorizationHandler();
        this.defaultQueryRowLimit = IoTDBRestServiceDescriptor.getInstance().getConfig().getRestQueryDefaultRowSizeLimit();
    }

    public Response executeNonQueryStatement(SQL sql, SecurityContext securityContext) {
        try {
            RequestValidationHandler.validateSQL(sql);
            Statement statement = StatementGenerator.createStatement(sql.getSql(), ZoneId.systemDefault());
            if (!ExecuteStatementHandler.validateStatement(statement)) {
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
            }
            Response response = this.authorizationHandler.checkAuthority(securityContext, statement);
            if (response != null) {
                return response;
            }
            ExecutionResult result = COORDINATOR.execute(statement, SESSION_MANAGER.requestQueryId(), null, sql.getSql(), this.PARTITION_FETCHER, this.SCHEMA_FETCHER, config.getQueryTimeoutThreshold());
            return Response.ok().entity((Object)(result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() ? new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name()) : new ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage()))).build();
        }
        catch (Exception e) {
            return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
        }
    }

    public Response executeQueryStatement(SQL sql, SecurityContext securityContext) {
        RequestValidationHandler.validateSQL(sql);
        Statement statement = StatementGenerator.createStatement(sql.getSql(), ZoneId.systemDefault());
        if (ExecuteStatementHandler.validateStatement(statement)) {
            return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
        }
        Response response = this.authorizationHandler.checkAuthority(securityContext, statement);
        if (response != null) {
            return response;
        }
        long queryId = SESSION_MANAGER.requestQueryId();
        ExecutionResult result = COORDINATOR.execute(statement, queryId, null, sql.getSql(), this.PARTITION_FETCHER, this.SCHEMA_FETCHER, config.getQueryTimeoutThreshold());
        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage())).build();
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        try {
            Response response2 = QueryDataSetHandler.fillQueryDataSet(queryExecution, statement, sql.getRowLimit() == null ? this.defaultQueryRowLimit : sql.getRowLimit());
            threadName.close();
            return response2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    threadName.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            }
        }
    }

    public Response insertTablet(InsertTabletRequest insertTabletRequest, SecurityContext securityContext) {
        try {
            RequestValidationHandler.validateInsertTabletRequest(insertTabletRequest);
            InsertTabletStatement insertTabletStatement = StatementConstructionHandler.constructInsertTabletStatement(insertTabletRequest);
            Response response = this.authorizationHandler.checkAuthority(securityContext, insertTabletStatement);
            if (response != null) {
                return response;
            }
            ExecutionResult result = COORDINATOR.execute(insertTabletStatement, SESSION_MANAGER.requestQueryId(), null, "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER, config.getQueryTimeoutThreshold());
            return Response.ok().entity((Object)(result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() ? new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name()) : new ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage()))).build();
        }
        catch (Exception e) {
            return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
        }
    }
}

