/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;

public class MinTimeAggrResult
extends AggregateResult {
    public MinTimeAggrResult() {
        super(TSDataType.INT64, AggregationType.MIN_TIME);
        this.reset();
    }

    @Override
    public Long getResult() {
        return this.hasCandidateResult() ? Long.valueOf(this.getLongValue()) : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        if (this.hasFinalResult()) {
            return;
        }
        long time = statistics.getStartTime();
        this.setValue(time);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator) {
        this.updateResultFromPageData(batchIterator, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, long minBound, long maxBound) {
        if (this.hasFinalResult()) {
            return;
        }
        if (batchIterator.hasNext(minBound, maxBound) && batchIterator.currentTime() < maxBound && batchIterator.currentTime() >= minBound) {
            this.setLongValue(batchIterator.currentTime());
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        int timeLength;
        if (this.hasFinalResult()) {
            return;
        }
        long[] timesForFirstValue = new long[100];
        for (int currentPos = 0; currentPos < length; currentPos += timeLength) {
            timeLength = Math.min(length - currentPos, 100);
            System.arraycopy(timestamps, currentPos, timesForFirstValue, 0, timeLength);
            Object[] values = dataReader.getValuesInTimestamps(timesForFirstValue, timeLength);
            for (int i = 0; i < timeLength; ++i) {
                if (values[i] == null) continue;
                this.setLongValue(timesForFirstValue[i]);
                return;
            }
        }
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        if (this.hasFinalResult()) {
            return;
        }
        if (valueIterator.hasNext()) {
            this.setLongValue(timestamps[valueIterator.getCurPos()]);
        }
    }

    @Override
    public boolean hasFinalResult() {
        return this.hasCandidateResult;
    }

    @Override
    public void merge(AggregateResult another) {
        MinTimeAggrResult anotherMinTime = (MinTimeAggrResult)another;
        if (!this.hasCandidateResult() && anotherMinTime.hasCandidateResult()) {
            this.setLongValue(anotherMinTime.getResult());
            return;
        }
        if (this.hasCandidateResult() && anotherMinTime.hasCandidateResult() && this.getResult() > anotherMinTime.getResult()) {
            this.setLongValue(anotherMinTime.getResult());
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) {
    }

    @Override
    public long getTime() {
        return this.getLongValue();
    }
}

