/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.query.context.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTimeManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(QueryTimeManager.class);
    private Map<Long, QueryContext> queryContextMap = new ConcurrentHashMap<Long, QueryContext>();
    private ScheduledExecutorService executorService;
    private Map<Long, ScheduledFuture<?>> queryScheduledTaskMap = new ConcurrentHashMap();

    private QueryTimeManager() {
        this.executorService = IoTDBThreadPoolFactory.newScheduledThreadPool((int)1, (String)"query-time-manager");
    }

    public void registerQuery(QueryContext context) {
        this.queryContextMap.put(context.getQueryId(), context);
        if (context.getTimeout() < 0L) {
            context.setTimeout(IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold());
        }
        if (context.getTimeout() != 0L) {
            ScheduledFuture<?> scheduledFuture = this.executorService.schedule(() -> {
                this.killQuery(context.getQueryId());
                logger.warn(String.format("Query is time out (%dms) with queryId %d", context.getTimeout(), context.getQueryId()));
            }, context.getTimeout(), TimeUnit.MILLISECONDS);
            this.queryScheduledTaskMap.put(context.getQueryId(), scheduledFuture);
        }
    }

    public void killQuery(long queryId) {
        if (this.queryContextMap.get(queryId) == null) {
            return;
        }
        this.queryContextMap.get(queryId).setInterrupted(true);
    }

    public static boolean checkQueryAlive(long queryId) {
        return true;
    }

    public Map<Long, QueryContext> getQueryContextMap() {
        return this.queryContextMap;
    }

    public void clear() {
        this.queryContextMap.clear();
        this.queryScheduledTaskMap.clear();
    }

    public QueryContext getQueryContext(long queryId) {
        return this.queryContextMap.get(queryId);
    }

    public static QueryTimeManager getInstance() {
        return QueryTimeManagerHelper.INSTANCE;
    }

    public void start() {
    }

    public void stop() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            return;
        }
        this.executorService.shutdownNow();
    }

    public ServiceType getID() {
        return ServiceType.QUERY_TIME_MANAGER;
    }

    private static class QueryTimeManagerHelper {
        private static final QueryTimeManager INSTANCE = new QueryTimeManager();

        private QueryTimeManagerHelper() {
        }
    }
}

