/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.selector.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.engine.storagegroup.timeindex.DeviceTimeIndex;

public class CrossSpaceCompactionCandidate {
    private List<TsFileResourceCandidate> seqFiles;
    private List<TsFileResourceCandidate> unseqFiles;
    private int nextUnseqFileIndex;
    private CrossCompactionTaskResourceSplit nextSplit;
    private long ttlLowerBound = Long.MIN_VALUE;

    public CrossSpaceCompactionCandidate(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.init(seqFiles, unseqFiles);
    }

    public CrossSpaceCompactionCandidate(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, long ttlLowerBound) {
        this.ttlLowerBound = ttlLowerBound;
        this.init(seqFiles, unseqFiles);
    }

    private void init(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.seqFiles = this.copySeqResource(seqFiles);
        this.unseqFiles = this.filterUnseqResource(unseqFiles);
        this.nextUnseqFileIndex = 0;
    }

    public boolean hasNextSplit() throws IOException {
        if (this.nextUnseqFileIndex >= this.unseqFiles.size()) {
            return false;
        }
        return this.prepareNextSplit();
    }

    public CrossCompactionTaskResourceSplit nextSplit() {
        return this.nextSplit;
    }

    private boolean prepareNextSplit() throws IOException {
        TsFileResourceCandidate unseqFile = this.unseqFiles.get(this.nextUnseqFileIndex);
        ArrayList<TsFileResourceCandidate> ret = new ArrayList<TsFileResourceCandidate>();
        if (!unseqFile.hasDetailedDeviceInfo()) {
            return false;
        }
        block0: for (DeviceInfo unseqDeviceInfo : unseqFile.getDevices()) {
            for (TsFileResourceCandidate seqFile : this.seqFiles) {
                if (!(seqFile.isValidCandidate && seqFile.hasDetailedDeviceInfo() || !seqFile.mayHasOverlapWithUnseqFile(unseqDeviceInfo))) {
                    return false;
                }
                if (!seqFile.containsDevice(unseqDeviceInfo.deviceId)) continue;
                DeviceInfo seqDeviceInfo = seqFile.getDeviceInfoById(unseqDeviceInfo.deviceId);
                if (seqFile.unsealed() && unseqDeviceInfo.endTime >= seqDeviceInfo.startTime) {
                    return false;
                }
                if (unseqDeviceInfo.endTime <= seqDeviceInfo.endTime) {
                    if (seqFile.selected) continue block0;
                    ret.add(seqFile);
                    seqFile.markAsSelected();
                    continue block0;
                }
                if (unseqDeviceInfo.startTime > seqDeviceInfo.endTime || seqFile.selected) continue;
                ret.add(seqFile);
                seqFile.markAsSelected();
            }
        }
        unseqFile.markAsSelected();
        this.nextSplit = new CrossCompactionTaskResourceSplit(unseqFile, ret);
        ++this.nextUnseqFileIndex;
        return true;
    }

    private List<TsFileResourceCandidate> copySeqResource(List<TsFileResource> seqFiles) {
        ArrayList<TsFileResourceCandidate> ret = new ArrayList<TsFileResourceCandidate>();
        for (TsFileResource resource : seqFiles) {
            ret.add(new TsFileResourceCandidate(resource));
        }
        return ret;
    }

    private List<TsFileResourceCandidate> filterUnseqResource(List<TsFileResource> unseqResources) {
        ArrayList<TsFileResourceCandidate> ret = new ArrayList<TsFileResourceCandidate>();
        for (TsFileResource resource : unseqResources) {
            if (resource.getStatus() != TsFileResourceStatus.CLOSED || !resource.getTsFile().exists()) break;
            if (!resource.stillLives(this.ttlLowerBound)) continue;
            ret.add(new TsFileResourceCandidate(resource));
        }
        return ret;
    }

    public List<TsFileResource> getSeqFiles() {
        return this.seqFiles.stream().map(tsFileResourceCandidate -> tsFileResourceCandidate.resource).collect(Collectors.toList());
    }

    public List<TsFileResourceCandidate> getUnseqFileCandidates() {
        return this.unseqFiles;
    }

    public List<TsFileResource> getUnseqFiles() {
        return this.unseqFiles.stream().map(tsFileResourceCandidate -> tsFileResourceCandidate.resource).collect(Collectors.toList());
    }

    protected static class DeviceInfo {
        protected String deviceId;
        protected long startTime;
        protected long endTime;

        public DeviceInfo(String deviceId, long startTime, long endTime) {
            this.deviceId = deviceId;
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }

    public static class TsFileResourceCandidate {
        public TsFileResource resource;
        protected boolean selected;
        public boolean isValidCandidate;
        private Map<String, DeviceInfo> deviceInfoMap;
        private boolean hasDetailedDeviceInfo;

        protected TsFileResourceCandidate(TsFileResource tsFileResource) {
            this.resource = tsFileResource;
            this.selected = false;
            this.isValidCandidate = tsFileResource.getStatus() == TsFileResourceStatus.CLOSED && tsFileResource.getTsFile().exists();
        }

        protected boolean unsealed() {
            return this.resource.getStatus() == TsFileResourceStatus.UNCLOSED;
        }

        private void prepareDeviceInfos() throws IOException {
            if (this.deviceInfoMap != null) {
                return;
            }
            this.deviceInfoMap = new LinkedHashMap<String, DeviceInfo>();
            if (this.resource.getTimeIndexType() == 2) {
                if (!this.resource.resourceFileExists()) {
                    this.hasDetailedDeviceInfo = false;
                    return;
                }
                DeviceTimeIndex timeIndex = this.resource.buildDeviceTimeIndex();
                for (String deviceId : timeIndex.getDevices()) {
                    this.deviceInfoMap.put(deviceId, new DeviceInfo(deviceId, timeIndex.getStartTime(deviceId), timeIndex.getEndTime(deviceId)));
                }
            } else {
                for (String deviceId : this.resource.getDevices()) {
                    this.deviceInfoMap.put(deviceId, new DeviceInfo(deviceId, this.resource.getStartTime(deviceId), this.resource.getEndTime(deviceId)));
                }
            }
            this.hasDetailedDeviceInfo = true;
        }

        protected void markAsSelected() {
            this.selected = true;
        }

        protected List<DeviceInfo> getDevices() throws IOException {
            this.prepareDeviceInfos();
            return new ArrayList<DeviceInfo>(this.deviceInfoMap.values());
        }

        protected DeviceInfo getDeviceInfoById(String deviceId) throws IOException {
            this.prepareDeviceInfos();
            return this.deviceInfoMap.get(deviceId);
        }

        protected boolean containsDevice(String deviceId) throws IOException {
            this.prepareDeviceInfos();
            return this.deviceInfoMap.containsKey(deviceId);
        }

        protected boolean hasDetailedDeviceInfo() throws IOException {
            this.prepareDeviceInfos();
            return this.hasDetailedDeviceInfo;
        }

        protected boolean mayHasOverlapWithUnseqFile(DeviceInfo unseqFileDeviceInfo) throws IOException {
            this.prepareDeviceInfos();
            long endTime = this.containsDevice(unseqFileDeviceInfo.deviceId) ? this.getDeviceInfoById((String)unseqFileDeviceInfo.deviceId).endTime : this.resource.getFileEndTime();
            return unseqFileDeviceInfo.startTime <= endTime;
        }
    }

    public static class CrossCompactionTaskResourceSplit {
        public TsFileResourceCandidate unseqFile;
        public List<TsFileResourceCandidate> seqFiles;

        public CrossCompactionTaskResourceSplit(TsFileResourceCandidate unseqFile, List<TsFileResourceCandidate> seqFiles) {
            this.unseqFile = unseqFile;
            this.seqFiles = seqFiles;
        }
    }
}

