/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.last;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.mpp.execution.driver.DataDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public abstract class AbstractUpdateLastCacheOperator
implements ProcessOperator {
    protected static final TsBlock LAST_QUERY_EMPTY_TSBLOCK = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.TEXT, (Object)TSDataType.TEXT, (Object)TSDataType.TEXT)).build();
    protected OperatorContext operatorContext;
    protected Operator child;
    protected DataNodeSchemaCache lastCache;
    protected boolean needUpdateCache;
    protected TsBlockBuilder tsBlockBuilder;
    protected String databaseName;

    protected AbstractUpdateLastCacheOperator(OperatorContext operatorContext, Operator child, DataNodeSchemaCache dataNodeSchemaCache, boolean needUpdateCache) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.lastCache = dataNodeSchemaCache;
        this.needUpdateCache = needUpdateCache;
        this.tsBlockBuilder = LastQueryUtil.createTsBlockBuilder(1);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    protected String getDatabaseName() {
        if (this.databaseName == null) {
            this.databaseName = ((DataDriverContext)this.operatorContext.getDriverContext()).getDataRegion().getDatabaseName();
        }
        return this.databaseName;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }
}

