/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TimeSeriesSchemaScanNode
extends SchemaQueryScanNode {
    private final String key;
    private final String value;
    private final boolean isContains;
    private final boolean orderByHeat;
    private final Map<Integer, Template> templateMap;

    public TimeSeriesSchemaScanNode(PlanNodeId id, PartialPath partialPath, String key, String value, int limit, int offset, boolean orderByHeat, boolean isContains, boolean isPrefixPath) {
        super(id, partialPath, limit, offset, isPrefixPath);
        this.key = key;
        this.value = value;
        this.orderByHeat = orderByHeat;
        this.isContains = isContains;
        this.templateMap = Collections.emptyMap();
    }

    public TimeSeriesSchemaScanNode(PlanNodeId id, PartialPath partialPath, String key, String value, long limit, long offset, boolean orderByHeat, boolean isContains, boolean isPrefixPath, Map<Integer, Template> templateMap) {
        super(id, partialPath, limit, offset, isPrefixPath);
        this.key = key;
        this.value = value;
        this.orderByHeat = orderByHeat;
        this.isContains = isContains;
        this.templateMap = templateMap;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TIME_SERIES_SCHEMA_SCAN.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.key, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.value, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.limit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.offset, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.orderByHeat, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isContains, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (ByteBuffer)byteBuffer);
        for (Template template : this.templateMap.values()) {
            template.serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TIME_SERIES_SCHEMA_SCAN.serialize(stream);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.key, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.limit, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.offset, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.orderByHeat, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isContains, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (OutputStream)stream);
        for (Template template : this.templateMap.values()) {
            template.serialize(stream);
        }
    }

    public static TimeSeriesSchemaScanNode deserialize(ByteBuffer byteBuffer) {
        PartialPath path;
        String fullPath = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        try {
            path = new PartialPath(fullPath);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize TimeSeriesSchemaScanNode", e);
        }
        String key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        String value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        long limit = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long offset = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        boolean oderByHeat = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean isContains = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean isPrefixPath = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        for (int i = 0; i < templateNum; ++i) {
            Template template = new Template();
            template.deserialize(byteBuffer);
            templateMap.put(template.getId(), template);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new TimeSeriesSchemaScanNode(planNodeId, path, key, value, limit, offset, oderByHeat, isContains, isPrefixPath, templateMap);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isContains() {
        return this.isContains;
    }

    public boolean isOrderByHeat() {
        return this.orderByHeat;
    }

    public Map<Integer, Template> getTemplateMap() {
        return this.templateMap;
    }

    @Override
    public PlanNode clone() {
        return new TimeSeriesSchemaScanNode(this.getPlanNodeId(), this.path, this.key, this.value, this.limit, this.offset, this.orderByHeat, this.isContains, this.isPrefixPath, this.templateMap);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ColumnHeaderConstant.showTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeSeriesSchemaScanNode that = (TimeSeriesSchemaScanNode)o;
        return this.isContains == that.isContains && this.orderByHeat == that.orderByHeat && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.value, this.isContains, this.orderByHeat);
    }

    @Override
    public String toString() {
        return String.format("TimeSeriesSchemaScanNode-%s:[DataRegion: %s]", this.getPlanNodeId(), this.getRegionReplicaSet());
    }
}

