/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.service.metric.enums.PerformanceOverviewMetrics;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.mpp.execution.executor.RegionReadExecutor;
import org.apache.iotdb.db.mpp.execution.executor.RegionWriteExecutor;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.scheduler.AsyncPlanNodeSender;
import org.apache.iotdb.db.mpp.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceDispatcher;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstance;
import org.apache.iotdb.mpp.rpc.thrift.TPlanNode;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceResp;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceDispatcherImpl
implements IFragInstanceDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(FragmentInstanceDispatcherImpl.class);
    private final ExecutorService executor;
    private final ExecutorService writeOperationExecutor;
    private final QueryType type;
    private final MPPQueryContext queryContext;
    private final String localhostIpAddr;
    private final int localhostInternalPort;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager;
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager;
    private static final QueryMetricsManager QUERY_METRICS = QueryMetricsManager.getInstance();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public FragmentInstanceDispatcherImpl(QueryType type, MPPQueryContext queryContext, ExecutorService executor, ExecutorService writeOperationExecutor, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager, IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager) {
        this.type = type;
        this.queryContext = queryContext;
        this.executor = executor;
        this.writeOperationExecutor = writeOperationExecutor;
        this.syncInternalServiceClientManager = syncInternalServiceClientManager;
        this.asyncInternalServiceClientManager = asyncInternalServiceClientManager;
        this.localhostIpAddr = IoTDBDescriptor.getInstance().getConfig().getInternalAddress();
        this.localhostInternalPort = IoTDBDescriptor.getInstance().getConfig().getInternalPort();
    }

    @Override
    public Future<FragInstanceDispatchResult> dispatch(List<FragmentInstance> instances) {
        if (this.type == QueryType.READ) {
            return this.dispatchRead(instances);
        }
        return this.dispatchWriteAsync(instances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<FragInstanceDispatchResult> dispatchRead(List<FragmentInstance> instances) {
        for (FragmentInstance instance : instances) {
            long startTime = System.nanoTime();
            try (SetThreadName threadName = new SetThreadName(instance.getId().getFullId());){
                this.dispatchOneInstance(instance);
            }
            catch (FragmentInstanceDispatchException e) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)new FragInstanceDispatchResult(e.getFailureStatus()));
                return listenableFuture;
            }
            catch (Throwable t) {
                logger.warn("[DispatchFailed]", t);
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Unexpected errors: " + t.getMessage()))));
                return listenableFuture;
            }
            finally {
                QUERY_METRICS.recordExecutionCost("dispatch_read", System.nanoTime() - startTime);
            }
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
    }

    private Future<FragInstanceDispatchResult> dispatchWriteSync(List<FragmentInstance> instances) {
        ArrayList<TSStatus> failureStatusList = new ArrayList<TSStatus>();
        for (FragmentInstance instance : instances) {
            try (SetThreadName threadName = new SetThreadName(instance.getId().getFullId());){
                this.dispatchOneInstance(instance);
            }
            catch (FragmentInstanceDispatchException e) {
                TSStatus failureStatus = e.getFailureStatus();
                if (instances.size() == 1) {
                    failureStatusList.add(failureStatus);
                    continue;
                }
                if (failureStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    failureStatusList.addAll(failureStatus.getSubStatus());
                    continue;
                }
                failureStatusList.add(failureStatus);
            }
            catch (Throwable t) {
                logger.warn("[DispatchFailed]", t);
                failureStatusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Unexpected errors: " + t.getMessage())));
            }
        }
        if (failureStatusList.isEmpty()) {
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
        }
        if (instances.size() == 1) {
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult((TSStatus)failureStatusList.get(0)));
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus(failureStatusList)));
    }

    private Future<FragInstanceDispatchResult> dispatchWriteAsync(List<FragmentInstance> instances) {
        ArrayList<FragmentInstance> localInstances = new ArrayList<FragmentInstance>();
        ArrayList<FragmentInstance> remoteInstances = new ArrayList<FragmentInstance>();
        for (FragmentInstance instance : instances) {
            TEndPoint endPoint = instance.getHostDataNode().getInternalEndPoint();
            if (this.isDispatchedToLocal(endPoint)) {
                localInstances.add(instance);
                continue;
            }
            remoteInstances.add(instance);
        }
        AsyncPlanNodeSender asyncPlanNodeSender = new AsyncPlanNodeSender(this.asyncInternalServiceClientManager, remoteInstances);
        asyncPlanNodeSender.sendAll();
        ArrayList<TSStatus> dataNodeFailureList = new ArrayList<TSStatus>();
        long localScheduleStartTime = System.nanoTime();
        for (FragmentInstance localInstance : localInstances) {
            try (SetThreadName threadName = new SetThreadName(localInstance.getId().getFullId());){
                this.dispatchOneInstance(localInstance);
            }
            catch (FragmentInstanceDispatchException e) {
                dataNodeFailureList.add(e.getFailureStatus());
            }
            catch (Throwable t) {
                logger.warn("[DispatchFailed]", t);
                dataNodeFailureList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Unexpected errors: " + t.getMessage())));
            }
        }
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLocalCost(System.nanoTime() - localScheduleStartTime);
        try {
            asyncPlanNodeSender.waitUntilCompleted();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Interrupted when dispatching write async", (Throwable)e);
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Interrupted errors: " + e.getMessage()))));
        }
        dataNodeFailureList.addAll(asyncPlanNodeSender.getFailureStatusList());
        if (dataNodeFailureList.isEmpty()) {
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
        }
        if (instances.size() == 1) {
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult((TSStatus)dataNodeFailureList.get(0)));
        }
        ArrayList<TSStatus> failureStatusList = new ArrayList<TSStatus>();
        for (TSStatus dataNodeFailure : dataNodeFailureList) {
            if (dataNodeFailure.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                failureStatusList.addAll(dataNodeFailure.getSubStatus());
                continue;
            }
            failureStatusList.add(dataNodeFailure);
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus(failureStatusList)));
    }

    private void dispatchOneInstance(FragmentInstance instance) throws FragmentInstanceDispatchException {
        TEndPoint endPoint = instance.getHostDataNode().getInternalEndPoint();
        if (this.isDispatchedToLocal(endPoint)) {
            this.dispatchLocally(instance);
        } else {
            this.dispatchRemote(instance, endPoint);
        }
    }

    private boolean isDispatchedToLocal(TEndPoint endPoint) {
        return this.localhostIpAddr.equals(endPoint.getIp()) && this.localhostInternalPort == endPoint.port;
    }

    private void dispatchRemote(FragmentInstance instance, TEndPoint endPoint) throws FragmentInstanceDispatchException {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.syncInternalServiceClientManager.borrowClient((Object)endPoint);){
            switch (instance.getType()) {
                case READ: {
                    TSendFragmentInstanceReq sendFragmentInstanceReq = new TSendFragmentInstanceReq(new TFragmentInstance(instance.serializeToByteBuffer()));
                    if (instance.getExecutorType().isStorageExecutor()) {
                        sendFragmentInstanceReq.setConsensusGroupId(instance.getRegionReplicaSet().getRegionId());
                    }
                    TSendFragmentInstanceResp sendFragmentInstanceResp = client.sendFragmentInstance(sendFragmentInstanceReq);
                    if (!sendFragmentInstanceResp.accepted) {
                        logger.warn(sendFragmentInstanceResp.message);
                        throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)sendFragmentInstanceResp.message));
                    }
                    break;
                }
                case WRITE: {
                    TSendPlanNodeReq sendPlanNodeReq = new TSendPlanNodeReq(new TPlanNode(instance.getFragment().getPlanNodeTree().serializeToByteBuffer()), instance.getRegionReplicaSet().getRegionId());
                    TSendPlanNodeResp sendPlanNodeResp = client.sendPlanNode(sendPlanNodeReq);
                    if (!sendPlanNodeResp.accepted) {
                        logger.warn("dispatch write failed. status: {}, code: {}, message: {}, node {}", new Object[]{sendPlanNodeResp.status, TSStatusCode.representOf((int)sendPlanNodeResp.status.code), sendPlanNodeResp.message, endPoint});
                        if (sendPlanNodeResp.getStatus() == null) {
                            throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)sendPlanNodeResp.getMessage()));
                        }
                        throw new FragmentInstanceDispatchException(sendPlanNodeResp.getStatus());
                    }
                    TSStatus status = sendPlanNodeResp.getStatus();
                    if (status != null && status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        throw new FragmentInstanceDispatchException(status);
                    }
                    break;
                }
                default: {
                    throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)String.format("unknown query type [%s]", new Object[]{instance.getType()})));
                }
            }
        }
        catch (ClientManagerException | TException e) {
            logger.warn("can't connect to node {}", (Object)endPoint, (Object)e);
            TSStatus status = new TSStatus();
            status.setCode(TSStatusCode.DISPATCH_ERROR.getStatusCode());
            status.setMessage("can't connect to node " + endPoint);
            this.queryContext.addFailedEndPoint(endPoint);
            throw new FragmentInstanceDispatchException(status);
        }
    }

    private void dispatchLocally(FragmentInstance instance) throws FragmentInstanceDispatchException {
        ConsensusGroupId groupId = null;
        if (instance.getExecutorType().isStorageExecutor()) {
            try {
                groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)instance.getRegionReplicaSet().getRegionId());
            }
            catch (Throwable t) {
                logger.warn("Deserialize ConsensusGroupId failed. ", t);
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)("Deserialize ConsensusGroupId failed: " + t.getMessage())));
            }
        }
        switch (instance.getType()) {
            case READ: {
                RegionExecutionResult readResult;
                RegionReadExecutor readExecutor = new RegionReadExecutor();
                RegionExecutionResult regionExecutionResult = readResult = groupId == null ? readExecutor.execute(instance) : readExecutor.execute(groupId, instance);
                if (readResult.isAccepted()) break;
                logger.warn(readResult.getMessage());
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)readResult.getMessage()));
            }
            case WRITE: {
                PlanNode planNode = instance.getFragment().getPlanNodeTree();
                RegionWriteExecutor writeExecutor = new RegionWriteExecutor();
                RegionExecutionResult writeResult = writeExecutor.execute(groupId, planNode);
                if (!writeResult.isAccepted()) {
                    logger.warn("write locally failed. TSStatus: {}, message: {}", (Object)writeResult.getStatus(), (Object)writeResult.getMessage());
                    if (writeResult.getStatus() == null) {
                        throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)writeResult.getMessage()));
                    }
                    throw new FragmentInstanceDispatchException(writeResult.getStatus());
                }
                TSStatus status = writeResult.getStatus();
                if (status == null || status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
                throw new FragmentInstanceDispatchException(status);
            }
            default: {
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)String.format("unknown query type [%s]", new Object[]{instance.getType()})));
            }
        }
    }

    @Override
    public void abort() {
    }
}

