/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.intermediate;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.LayerRowReader;
import org.apache.iotdb.db.mpp.transformation.api.LayerRowWindowReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.adapter.ElasticSerializableTVListBackedSingleColumnWindow;
import org.apache.iotdb.db.mpp.transformation.dag.adapter.LayerPointReaderBackedSingleColumnRow;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.util.LayerCacheUtils;
import org.apache.iotdb.db.mpp.transformation.dag.util.TransformUtils;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.db.mpp.transformation.datastructure.util.ValueRecorder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.customizer.strategy.SessionTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.StateWindowAccessStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInputColumnSingleReferenceIntermediateLayer
extends IntermediateLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleInputColumnSingleReferenceIntermediateLayer.class);
    private final LayerPointReader parentLayerPointReader;
    private final TSDataType dataType;

    public SingleInputColumnSingleReferenceIntermediateLayer(Expression expression, long queryId, float memoryBudgetInMB, LayerPointReader parentLayerPointReader) {
        super(expression, queryId, memoryBudgetInMB);
        this.parentLayerPointReader = parentLayerPointReader;
        this.dataType = parentLayerPointReader.getDataType();
    }

    @Override
    public LayerPointReader constructPointReader() {
        return this.parentLayerPointReader;
    }

    @Override
    public LayerRowReader constructRowReader() {
        return new LayerRowReader(){
            private final Row row;
            private boolean hasCached;
            private boolean isCurrentNull;
            {
                this.row = new LayerPointReaderBackedSingleColumnRow(SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader);
                this.hasCached = false;
                this.isCurrentNull = false;
            }

            @Override
            public YieldableState yield() throws Exception {
                if (!this.hasCached) {
                    YieldableState yieldableState = SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.yield();
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    boolean bl = this.hasCached = yieldableState == YieldableState.YIELDABLE;
                    if (this.hasCached) {
                        this.isCurrentNull = SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.isCurrentNull();
                    }
                }
                return this.hasCached ? YieldableState.YIELDABLE : YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (!this.hasCached) {
                    this.hasCached = SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.next();
                    if (this.hasCached) {
                        this.isCurrentNull = SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.isCurrentNull();
                    }
                }
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.isCurrentNull = false;
                SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.readyForNext();
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.getDataType()};
            }

            @Override
            public long currentTime() throws IOException {
                return SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader.currentTime();
            }

            @Override
            public Row currentRow() {
                return this.row;
            }

            @Override
            public boolean isCurrentNull() {
                return this.isCurrentNull;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingSizeWindowReader(final SlidingSizeWindowAccessStrategy strategy, final float memoryBudgetInMB) {
        return new LayerRowWindowReader(){
            private final int windowSize;
            private final int slidingStep;
            private final ElasticSerializableTVList tvList;
            private final ElasticSerializableTVListBackedSingleColumnWindow window;
            private boolean hasCached;
            private int beginIndex;
            {
                this.windowSize = strategy.getWindowSize();
                this.slidingStep = strategy.getSlidingStep();
                this.tvList = ElasticSerializableTVList.newElasticSerializableTVList(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.queryId, memoryBudgetInMB, 2);
                this.window = new ElasticSerializableTVListBackedSingleColumnWindow(this.tvList);
                this.hasCached = false;
                this.beginIndex = -this.slidingStep;
            }

            @Override
            public YieldableState yield() throws Exception {
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("SingleInputColumnSingleReferenceIntermediateLayer$LayerRowWindowReader: index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                int pointsToBeCollected = endIndex - this.tvList.size();
                if (0 < pointsToBeCollected) {
                    YieldableState yieldableState = LayerCacheUtils.yieldPoints(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, this.tvList, pointsToBeCollected);
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        this.beginIndex -= this.slidingStep;
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (this.tvList.size() <= this.beginIndex) {
                        return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                    }
                    this.window.seek(this.beginIndex, this.tvList.size(), this.tvList.getTime(this.beginIndex), this.tvList.getTime(this.tvList.size() - 1));
                } else {
                    this.window.seek(this.beginIndex, endIndex, this.tvList.getTime(this.beginIndex), this.tvList.getTime(endIndex - 1));
                }
                this.hasCached = true;
                return YieldableState.YIELDABLE;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.hasCached) {
                    return true;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("SingleInputColumnSingleReferenceIntermediateLayer$LayerRowWindowReader: index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return false;
                }
                int pointsToBeCollected = endIndex - this.tvList.size();
                if (0 < pointsToBeCollected) {
                    LayerCacheUtils.cachePoints(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, this.tvList, pointsToBeCollected);
                    if (this.tvList.size() <= this.beginIndex) {
                        return false;
                    }
                    this.window.seek(this.beginIndex, this.tvList.size(), this.tvList.getTime(this.beginIndex), this.tvList.getTime(this.tvList.size() - 1));
                } else {
                    this.window.seek(this.beginIndex, endIndex, this.tvList.getTime(this.beginIndex), this.tvList.getTime(endIndex - 1));
                }
                this.hasCached = true;
                return true;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.tvList.setEvictionUpperBound(this.beginIndex + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnSingleReferenceIntermediateLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return this.window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingTimeWindowReader(final SlidingTimeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long timeInterval = strategy.getTimeInterval();
        final long slidingStep = strategy.getSlidingStep();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final ElasticSerializableTVList tvList = ElasticSerializableTVList.newElasticSerializableTVList(this.dataType, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(tvList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private boolean hasCached = false;
            private long nextWindowTimeBegin = strategy.getDisplayWindowBegin();
            private int nextIndexBegin = 0;

            @Override
            public YieldableState yield() throws Exception {
                if (this.isFirstIteration) {
                    YieldableState yieldableState;
                    if (tvList.size() == 0 && (yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, tvList)) != YieldableState.YIELDABLE) {
                        return yieldableState;
                    }
                    if (this.nextWindowTimeBegin == Long.MIN_VALUE) {
                        this.nextWindowTimeBegin = tvList.getTime(0);
                    }
                    this.hasAtLeastOneRow = tvList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (tvList.getTime(tvList.size() - 1) < nextWindowTimeEnd) {
                    YieldableState yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, tvList);
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (yieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    break;
                }
                for (int i = this.nextIndexBegin; i < tvList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= tvList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != tvList.size() - 1) continue;
                    this.nextIndexBegin = tvList.size();
                }
                int nextIndexEnd = tvList.size();
                for (int i = this.nextIndexBegin; i < tvList.size(); ++i) {
                    if (nextWindowTimeEnd > tvList.getTime(i)) continue;
                    nextIndexEnd = i;
                    break;
                }
                if (nextIndexEnd == this.nextIndexBegin && nextWindowTimeEnd < tvList.getTime(tvList.size() - 1)) {
                    window.setEmptyWindow(this.nextWindowTimeBegin, nextWindowTimeEnd);
                    return YieldableState.YIELDABLE;
                }
                window.seek(this.nextIndexBegin, nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != nextIndexEnd || nextIndexEnd != tvList.size();
                return this.hasCached ? YieldableState.YIELDABLE : YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.isFirstIteration) {
                    if (tvList.size() == 0 && LayerCacheUtils.cachePoint(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, tvList) && this.nextWindowTimeBegin == Long.MIN_VALUE) {
                        this.nextWindowTimeBegin = tvList.getTime(0);
                    }
                    this.hasAtLeastOneRow = tvList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (this.hasCached) {
                    return true;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return false;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (tvList.getTime(tvList.size() - 1) < nextWindowTimeEnd && LayerCacheUtils.cachePoint(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, tvList)) {
                }
                for (int i = this.nextIndexBegin; i < tvList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= tvList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != tvList.size() - 1) continue;
                    this.nextIndexBegin = tvList.size();
                }
                int nextIndexEnd = tvList.size();
                for (int i = this.nextIndexBegin; i < tvList.size(); ++i) {
                    if (nextWindowTimeEnd > tvList.getTime(i)) continue;
                    nextIndexEnd = i;
                    break;
                }
                if (nextIndexEnd == this.nextIndexBegin && nextWindowTimeEnd < tvList.getTime(tvList.size() - 1)) {
                    window.setEmptyWindow(this.nextWindowTimeBegin, nextWindowTimeEnd);
                    return true;
                }
                window.seek(this.nextIndexBegin, nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != nextIndexEnd || nextIndexEnd != tvList.size();
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.nextWindowTimeBegin += slidingStep;
                tvList.setEvictionUpperBound(this.nextIndexBegin + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnSingleReferenceIntermediateLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSessionTimeWindowReader(SessionTimeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long displayWindowBegin = strategy.getDisplayWindowBegin();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final long sessionTimeGap = strategy.getSessionTimeGap();
        final ElasticSerializableTVList tvList = ElasticSerializableTVList.newElasticSerializableTVList(this.dataType, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(tvList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private long nextWindowTimeBegin = displayWindowBegin;
            private long nextWindowTimeEnd = 0L;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 1;

            @Override
            public YieldableState yield() throws Exception {
                YieldableState yieldableState;
                if (this.isFirstIteration) {
                    if (tvList.size() == 0 && (yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, tvList)) != YieldableState.YIELDABLE) {
                        return yieldableState;
                    }
                    this.nextWindowTimeBegin = Math.max(displayWindowBegin, tvList.getTime(0));
                    this.hasAtLeastOneRow = tvList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                while (tvList.getTime(tvList.size() - 1) < displayWindowEnd) {
                    yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, tvList);
                    if (yieldableState == YieldableState.YIELDABLE) {
                        if (tvList.getTime(tvList.size() - 2) >= displayWindowBegin && tvList.getTime(tvList.size() - 1) - tvList.getTime(tvList.size() - 2) > sessionTimeGap) {
                            this.nextIndexEnd = tvList.size() - 1;
                            break;
                        }
                        ++this.nextIndexEnd;
                        continue;
                    }
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (yieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    this.nextIndexEnd = tvList.size();
                    break;
                }
                this.nextWindowTimeEnd = tvList.getTime(this.nextIndexEnd - 1);
                if (this.nextIndexBegin == this.nextIndexEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                for (int i = this.nextIndexBegin; i < tvList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= tvList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != tvList.size() - 1) continue;
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeEnd);
                return YieldableState.YIELDABLE;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                return false;
            }

            @Override
            public void readyForNext() throws IOException {
                if (this.nextIndexEnd < tvList.size()) {
                    this.nextWindowTimeBegin = tvList.getTime(this.nextIndexEnd);
                }
                tvList.setEvictionUpperBound(this.nextIndexBegin + 1);
                this.nextIndexBegin = this.nextIndexEnd;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnSingleReferenceIntermediateLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowStateWindowReader(StateWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long displayWindowBegin = strategy.getDisplayWindowBegin();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final double delta = strategy.getDelta();
        final ElasticSerializableTVList tvList = ElasticSerializableTVList.newElasticSerializableTVList(this.dataType, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(tvList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private long nextWindowTimeBegin = displayWindowBegin;
            private long nextWindowTimeEnd = 0L;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 1;
            private ValueRecorder valueRecorder = new ValueRecorder();

            @Override
            public YieldableState yield() throws Exception {
                YieldableState yieldableState;
                if (this.isFirstIteration) {
                    if (tvList.size() == 0 && (yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, tvList)) != YieldableState.YIELDABLE) {
                        return yieldableState;
                    }
                    this.nextWindowTimeBegin = Math.max(displayWindowBegin, tvList.getTime(0));
                    this.hasAtLeastOneRow = tvList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                while (tvList.getTime(tvList.size() - 1) < displayWindowEnd) {
                    yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, SingleInputColumnSingleReferenceIntermediateLayer.this.parentLayerPointReader, tvList);
                    if (yieldableState == YieldableState.YIELDABLE) {
                        if (tvList.getTime(tvList.size() - 2) >= displayWindowBegin && TransformUtils.splitWindowForStateWindow(SingleInputColumnSingleReferenceIntermediateLayer.this.dataType, this.valueRecorder, delta, tvList)) {
                            this.nextIndexEnd = tvList.size() - 1;
                            break;
                        }
                        ++this.nextIndexEnd;
                        continue;
                    }
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (yieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    this.nextIndexEnd = tvList.size();
                    break;
                }
                this.nextWindowTimeEnd = tvList.getTime(this.nextIndexEnd - 1);
                if (this.nextIndexBegin == this.nextIndexEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                for (int i = this.nextIndexBegin; i < tvList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= tvList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != tvList.size() - 1) continue;
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeEnd);
                return YieldableState.YIELDABLE;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                return false;
            }

            @Override
            public void readyForNext() throws IOException {
                if (this.nextIndexEnd < tvList.size()) {
                    this.nextWindowTimeBegin = tvList.getTime(this.nextIndexEnd);
                }
                tvList.setEvictionUpperBound(this.nextIndexBegin + 1);
                this.nextIndexBegin = this.nextIndexEnd;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnSingleReferenceIntermediateLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }
}

