/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.engine.storagegroup.ILastFlushTimeMap;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashLastFlushTimeMap
implements ILastFlushTimeMap {
    private static final Logger logger = LoggerFactory.getLogger(HashLastFlushTimeMap.class);
    long STRING_BASE_SIZE = 40L;
    long LONG_SIZE = 24L;
    long HASHMAP_NODE_BASIC_SIZE = 14L + this.STRING_BASE_SIZE + this.LONG_SIZE;
    private Map<Long, Map<String, Long>> partitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<Long, Map<String, Long>> newlyFlushedPartitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<String, Long> globalLatestFlushedTimeForEachDevice = new HashMap<String, Long>();
    TsFileManager tsFileManager;
    private Map<Long, Long> memCostForEachPartition = new HashMap<Long, Long>();

    public HashLastFlushTimeMap(TsFileManager tsFileManager) {
        this.tsFileManager = tsFileManager;
    }

    @Override
    public void setMultiDeviceFlushedTime(long timePartitionId, Map<String, Long> flushedTimeMap) {
        Map<String, Long> flushTimeMapForPartition = this.partitionLatestFlushedTimeForEachDevice.get(timePartitionId);
        if (flushTimeMapForPartition == null) {
            return;
        }
        long memIncr = 0L;
        for (Map.Entry<String, Long> entry : flushedTimeMap.entrySet()) {
            if (flushTimeMapForPartition.put(entry.getKey(), entry.getValue()) != null) continue;
            memIncr += this.HASHMAP_NODE_BASIC_SIZE + 2L * (long)entry.getKey().length();
        }
        long finalMemIncr = memIncr;
        this.memCostForEachPartition.compute(timePartitionId, (k1, v1) -> v1 == null ? finalMemIncr : v1 + finalMemIncr);
    }

    @Override
    public void setOneDeviceFlushedTime(long timePartitionId, String path, long time) {
        Map<String, Long> flushTimeMapForPartition = this.partitionLatestFlushedTimeForEachDevice.get(timePartitionId);
        if (flushTimeMapForPartition == null) {
            return;
        }
        if (flushTimeMapForPartition.put(path, time) == null) {
            long memCost = this.HASHMAP_NODE_BASIC_SIZE + 2L * (long)path.length();
            this.memCostForEachPartition.compute(timePartitionId, (k1, v1) -> v1 == null ? memCost : v1 + memCost);
        }
    }

    @Override
    public void setMultiDeviceGlobalFlushedTime(Map<String, Long> globalFlushedTimeMap) {
        this.globalLatestFlushedTimeForEachDevice.putAll(globalFlushedTimeMap);
    }

    @Override
    public void setOneDeviceGlobalFlushedTime(String path, long time) {
        this.globalLatestFlushedTimeForEachDevice.put(path, time);
    }

    @Override
    public void updateFlushedTime(long timePartitionId, String path, long time) {
        Map<String, Long> flushTimeMapForPartition = this.partitionLatestFlushedTimeForEachDevice.get(timePartitionId);
        if (flushTimeMapForPartition == null) {
            return;
        }
        flushTimeMapForPartition.compute(path, (k, v) -> {
            if (v == null) {
                long memCost = this.HASHMAP_NODE_BASIC_SIZE + 2L * (long)path.length();
                this.memCostForEachPartition.compute(timePartitionId, (k1, v1) -> v1 == null ? memCost : v1 + memCost);
                return time;
            }
            return Math.max(v, time);
        });
    }

    @Override
    public void updateGlobalFlushedTime(String path, long time) {
        this.globalLatestFlushedTimeForEachDevice.compute(path, (k, v) -> v == null ? time : Math.max(v, time));
    }

    @Override
    public void updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(long partitionId, String deviceId, long time) {
        this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).compute(deviceId, (k, v) -> v == null ? time : Math.max(v, time));
    }

    @Override
    public boolean checkAndCreateFlushedTimePartition(long timePartitionId) {
        if (!this.partitionLatestFlushedTimeForEachDevice.containsKey(timePartitionId)) {
            this.partitionLatestFlushedTimeForEachDevice.put(timePartitionId, new HashMap());
            return false;
        }
        return true;
    }

    @Override
    public void applyNewlyFlushedTimeToFlushedTime() {
        for (Map.Entry<Long, Map<String, Long>> entry : this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.entrySet()) {
            long timePartitionId = entry.getKey();
            Map latestFlushTimeForPartition = this.partitionLatestFlushedTimeForEachDevice.getOrDefault(timePartitionId, new HashMap());
            for (Map.Entry<String, Long> endTimeMap : entry.getValue().entrySet()) {
                String device = endTimeMap.getKey();
                long endTime = endTimeMap.getValue();
                if (latestFlushTimeForPartition.getOrDefault(device, Long.MIN_VALUE) >= endTime) continue;
                this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).put(device, endTime);
            }
        }
    }

    @Override
    public void updateLatestFlushTime(long partitionId, Map<String, Long> updateMap) {
        for (Map.Entry<String, Long> entry : updateMap.entrySet()) {
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).put(entry.getKey(), entry.getValue());
            this.updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(partitionId, entry.getKey(), entry.getValue());
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(entry.getKey(), Long.MIN_VALUE) >= entry.getValue()) continue;
            this.globalLatestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public long getFlushedTime(long timePartitionId, String path) {
        return this.partitionLatestFlushedTimeForEachDevice.get(timePartitionId).computeIfAbsent(path, k -> this.recoverFlushTime(timePartitionId, path));
    }

    @Override
    public long getGlobalFlushedTime(String path) {
        return this.globalLatestFlushedTimeForEachDevice.getOrDefault(path, Long.MIN_VALUE);
    }

    @Override
    public void clearFlushedTime() {
        this.partitionLatestFlushedTimeForEachDevice.clear();
    }

    @Override
    public void clearGlobalFlushedTime() {
        this.globalLatestFlushedTimeForEachDevice.clear();
    }

    @Override
    public void removePartition(long partitionId) {
        this.partitionLatestFlushedTimeForEachDevice.remove(partitionId);
        this.memCostForEachPartition.remove(partitionId);
    }

    private long recoverFlushTime(long partitionId, String devicePath) {
        TsFileResourceList tsFileResourceList = this.tsFileManager.getOrCreateSequenceListByTimePartition(partitionId);
        for (int i = tsFileResourceList.size() - 1; i >= 0; --i) {
            if (!((TsFileResource)tsFileResourceList.get((int)i)).timeIndex.mayContainsDevice(devicePath)) continue;
            return ((TsFileResource)tsFileResourceList.get((int)i)).timeIndex.getEndTime(devicePath);
        }
        long memCost = this.HASHMAP_NODE_BASIC_SIZE + 2L * (long)devicePath.length();
        this.memCostForEachPartition.compute(partitionId, (k, v) -> v == null ? memCost : v + memCost);
        return Long.MIN_VALUE;
    }

    @Override
    public long getMemSize(long partitionId) {
        if (this.memCostForEachPartition.containsKey(partitionId)) {
            return this.memCostForEachPartition.get(partitionId);
        }
        return 0L;
    }
}

