/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.basic;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.Traverser;

public abstract class MNodeTraverser<R>
extends Traverser<R> {
    protected int targetLevel = -1;
    protected IMNode lastVisitNode = null;

    public MNodeTraverser(IMNode startNode, PartialPath path, IMTreeStore store, boolean isPrefixMatch) throws MetadataException {
        super(startNode, path, store, isPrefixMatch);
    }

    protected boolean mayTargetNodeType(IMNode node) {
        return true;
    }

    protected boolean acceptFullMatchedNode(IMNode node) {
        if (this.targetLevel >= 0) {
            if (this.getSizeOfAncestor() > this.targetLevel) {
                return this.getAncestorNodeByLevel(this.targetLevel) != this.lastVisitNode;
            }
            if (this.getSizeOfAncestor() == this.targetLevel) {
                return node != this.lastVisitNode;
            }
            return false;
        }
        return true;
    }

    protected boolean acceptInternalMatchedNode(IMNode node) {
        return false;
    }

    protected boolean shouldVisitSubtreeOfFullMatchedNode(IMNode node) {
        return !node.isMeasurement();
    }

    protected boolean shouldVisitSubtreeOfInternalMatchedNode(IMNode node) {
        return !node.isMeasurement();
    }

    public void setTargetLevel(int targetLevel) {
        this.targetLevel = targetLevel;
    }

    protected final R generateResult(IMNode nextMatchedNode) {
        if (this.targetLevel >= 0) {
            this.lastVisitNode = this.getLevelOfNextMatchedNode() == this.targetLevel ? nextMatchedNode : (IMNode)this.getAncestorNodeByLevel(this.targetLevel);
            return this.transferToResult(this.lastVisitNode);
        }
        return this.transferToResult(nextMatchedNode);
    }

    protected abstract R transferToResult(IMNode var1);
}

