/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.exchange.source;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.mpp.execution.exchange.source.ISourceHandle;
import org.apache.iotdb.db.mpp.execution.memory.LocalMemoryManager;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TAcknowledgeDataBlockEvent;
import org.apache.iotdb.mpp.rpc.thrift.TCloseSinkChannelEvent;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceHandle
implements ISourceHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceHandle.class);
    public static final int MAX_ATTEMPT_TIMES = 3;
    private static final long DEFAULT_RETRY_INTERVAL_IN_MS = 1000L;
    private final TEndPoint remoteEndpoint;
    private final TFragmentInstanceId remoteFragmentInstanceId;
    private final TFragmentInstanceId localFragmentInstanceId;
    private final String fullFragmentInstanceId;
    private final String localPlanNodeId;
    private final int indexOfUpstreamSinkHandle;
    private final LocalMemoryManager localMemoryManager;
    private final ExecutorService executorService;
    private final TsBlockSerde serde;
    private final MPPDataExchangeManager.SourceHandleListener sourceHandleListener;
    private final Map<Integer, Long> sequenceIdToDataBlockSize = new HashMap<Integer, Long>();
    private final Map<Integer, ByteBuffer> sequenceIdToTsBlock = new HashMap<Integer, ByteBuffer>();
    private final String threadName;
    private long retryIntervalInMs;
    private final IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> mppDataExchangeServiceClientManager;
    private SettableFuture<Void> blocked = SettableFuture.create();
    private ListenableFuture<Void> blockedOnMemory;
    private long bufferRetainedSizeInBytes = 0L;
    private int currSequenceId = 0;
    private int nextSequenceId = 0;
    private int lastSequenceId = Integer.MAX_VALUE;
    private boolean aborted = false;
    private boolean closed = false;
    private long maxBytesCanReserve = IoTDBDescriptor.getInstance().getConfig().getMaxBytesPerFragmentInstance();
    private boolean canGetTsBlockFromRemote = false;
    private static final QueryMetricsManager QUERY_METRICS = QueryMetricsManager.getInstance();

    public SourceHandle(TEndPoint remoteEndpoint, TFragmentInstanceId remoteFragmentInstanceId, TFragmentInstanceId localFragmentInstanceId, String localPlanNodeId, int indexOfUpstreamSinkHandle, LocalMemoryManager localMemoryManager, ExecutorService executorService, TsBlockSerde serde, MPPDataExchangeManager.SourceHandleListener sourceHandleListener, IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> mppDataExchangeServiceClientManager) {
        this.remoteEndpoint = (TEndPoint)Validate.notNull((Object)remoteEndpoint);
        this.remoteFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)remoteFragmentInstanceId);
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)localFragmentInstanceId);
        this.fullFragmentInstanceId = FragmentInstanceId.createFragmentInstanceIdFromTFragmentInstanceId(localFragmentInstanceId);
        this.localPlanNodeId = (String)Validate.notNull((Object)localPlanNodeId);
        this.indexOfUpstreamSinkHandle = indexOfUpstreamSinkHandle;
        this.localMemoryManager = (LocalMemoryManager)Validate.notNull((Object)localMemoryManager);
        this.executorService = (ExecutorService)Validate.notNull((Object)executorService);
        this.serde = (TsBlockSerde)Validate.notNull((Object)serde);
        this.sourceHandleListener = (MPPDataExchangeManager.SourceHandleListener)Validate.notNull((Object)sourceHandleListener);
        this.bufferRetainedSizeInBytes = 0L;
        this.mppDataExchangeServiceClientManager = mppDataExchangeServiceClientManager;
        this.retryIntervalInMs = 1000L;
        this.threadName = MPPDataExchangeManager.createFullIdFrom(localFragmentInstanceId, localPlanNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TsBlock receive() {
        ByteBuffer tsBlock = this.getSerializedTsBlock();
        if (tsBlock != null) {
            long startTime = System.nanoTime();
            try {
                TsBlock tsBlock2 = this.serde.deserialize(tsBlock);
                return tsBlock2;
            }
            finally {
                QUERY_METRICS.recordDataExchangeCost("source_handle_deserialize_tsblock_remote", System.nanoTime() - startTime);
            }
        }
        return null;
    }

    @Override
    public synchronized ByteBuffer getSerializedTsBlock() {
        long startTime = System.nanoTime();
        try {
            ByteBuffer tsBlock;
            SetThreadName sourceHandleName;
            block13: {
                sourceHandleName = new SetThreadName(this.threadName);
                try {
                    this.checkState();
                    if (!this.blocked.isDone()) {
                        throw new IllegalStateException("Source handle is blocked.");
                    }
                    tsBlock = this.sequenceIdToTsBlock.remove(this.currSequenceId);
                    if (tsBlock != null) break block13;
                    ByteBuffer byteBuffer = null;
                    sourceHandleName.close();
                    return byteBuffer;
                }
                catch (Throwable throwable) {
                    try {
                        sourceHandleName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            long retainedSize = this.sequenceIdToDataBlockSize.remove(this.currSequenceId);
            LOGGER.debug("[GetTsBlockFromBuffer] sequenceId:{}, size:{}", (Object)this.currSequenceId, (Object)retainedSize);
            ++this.currSequenceId;
            this.bufferRetainedSizeInBytes -= retainedSize;
            this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, retainedSize);
            if (this.sequenceIdToTsBlock.isEmpty() && !this.isFinished()) {
                LOGGER.debug("[WaitForMoreTsBlock]");
                this.blocked = SettableFuture.create();
            }
            if (this.isFinished()) {
                this.sourceHandleListener.onFinished(this);
            }
            this.trySubmitGetDataBlocksTask();
            ByteBuffer byteBuffer = tsBlock;
            sourceHandleName.close();
            return byteBuffer;
        }
        finally {
            QUERY_METRICS.recordDataExchangeCost("source_handle_get_tsblock_remote", System.nanoTime() - startTime);
        }
    }

    private synchronized void trySubmitGetDataBlocksTask() {
        if (this.aborted || this.closed) {
            return;
        }
        if (this.blockedOnMemory != null && !this.blockedOnMemory.isDone()) {
            return;
        }
        int startSequenceId = this.nextSequenceId;
        int endSequenceId = this.nextSequenceId;
        long reservedBytes = 0L;
        Pair<ListenableFuture<Void>, Boolean> pair = null;
        long blockedSize = 0L;
        while (this.sequenceIdToDataBlockSize.containsKey(endSequenceId)) {
            Long bytesToReserve = this.sequenceIdToDataBlockSize.get(endSequenceId);
            if (bytesToReserve == null) {
                throw new IllegalStateException("Data block size is null.");
            }
            pair = this.localMemoryManager.getQueryPool().reserve(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, bytesToReserve, this.maxBytesCanReserve);
            this.bufferRetainedSizeInBytes += bytesToReserve.longValue();
            ++endSequenceId;
            reservedBytes += bytesToReserve.longValue();
            if (((Boolean)pair.right).booleanValue()) continue;
            blockedSize = bytesToReserve;
            break;
        }
        if (pair == null) {
            return;
        }
        this.nextSequenceId = endSequenceId--;
        if (!((Boolean)pair.right).booleanValue()) {
            reservedBytes -= blockedSize;
            this.blockedOnMemory = (ListenableFuture)pair.left;
            int blockedSequenceId = endSequenceId;
            long blockedRetainedSize = blockedSize;
            this.blockedOnMemory.addListener(() -> this.executorService.submit(new GetDataBlocksTask(blockedSequenceId, blockedSequenceId + 1, blockedRetainedSize)), (Executor)this.executorService);
        }
        if (endSequenceId > startSequenceId) {
            this.executorService.submit(new GetDataBlocksTask(startSequenceId, endSequenceId, reservedBytes));
        }
    }

    @Override
    public synchronized ListenableFuture<?> isBlocked() {
        this.checkState();
        if (!this.canGetTsBlockFromRemote) {
            this.canGetTsBlockFromRemote = true;
            this.trySubmitGetDataBlocksTask();
        }
        return Futures.nonCancellationPropagating(this.blocked);
    }

    public synchronized void setNoMoreTsBlocks(int lastSequenceId) {
        LOGGER.debug("[ReceiveNoMoreTsBlockEvent]");
        this.lastSequenceId = lastSequenceId;
        if (!this.blocked.isDone() && this.remoteTsBlockedConsumedUp()) {
            this.blocked.set(null);
        }
        if (this.isFinished()) {
            this.sourceHandleListener.onFinished(this);
        }
    }

    public synchronized void updatePendingDataBlockInfo(int startSequenceId, List<Long> dataBlockSizes) {
        LOGGER.debug("[ReceiveNewTsBlockNotification] [{}, {}), each size is: {}", new Object[]{startSequenceId, startSequenceId + dataBlockSizes.size(), dataBlockSizes});
        for (int i = 0; i < dataBlockSizes.size(); ++i) {
            this.sequenceIdToDataBlockSize.put(i + startSequenceId, dataBlockSizes.get(i));
        }
        if (this.canGetTsBlockFromRemote) {
            this.trySubmitGetDataBlocksTask();
        }
    }

    @Override
    public synchronized void abort() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            if (this.aborted || this.closed) {
                return;
            }
            if (this.blocked != null && !this.blocked.isDone()) {
                this.blocked.cancel(true);
            }
            if (this.blockedOnMemory != null) {
                this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
            }
            this.sequenceIdToDataBlockSize.clear();
            if (this.bufferRetainedSizeInBytes > 0L) {
                this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, this.bufferRetainedSizeInBytes);
                this.bufferRetainedSizeInBytes = 0L;
            }
            this.localMemoryManager.getQueryPool().clearMemoryReservationMap(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId);
            this.aborted = true;
            this.sourceHandleListener.onAborted(this);
        }
    }

    @Override
    public synchronized void abort(Throwable t) {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            if (this.aborted || this.closed) {
                return;
            }
            if (this.blocked != null && !this.blocked.isDone()) {
                this.blocked.setException(t);
            }
            if (this.blockedOnMemory != null) {
                this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
            }
            this.sequenceIdToDataBlockSize.clear();
            if (this.bufferRetainedSizeInBytes > 0L) {
                this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, this.bufferRetainedSizeInBytes);
                this.bufferRetainedSizeInBytes = 0L;
            }
            this.localMemoryManager.getQueryPool().clearMemoryReservationMap(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId);
            this.aborted = true;
            this.sourceHandleListener.onAborted(this);
        }
    }

    @Override
    public synchronized void close() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            if (this.aborted || this.closed) {
                return;
            }
            if (this.blocked != null && !this.blocked.isDone()) {
                this.blocked.set(null);
            }
            if (this.blockedOnMemory != null) {
                this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
            }
            this.sequenceIdToDataBlockSize.clear();
            if (this.bufferRetainedSizeInBytes > 0L) {
                this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, this.bufferRetainedSizeInBytes);
                this.bufferRetainedSizeInBytes = 0L;
            }
            this.localMemoryManager.getQueryPool().clearMemoryReservationMap(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId);
            this.closed = true;
            this.executorService.submit(new SendCloseSinkChannelEventTask());
            this.currSequenceId = this.lastSequenceId + 1;
            this.sourceHandleListener.onFinished(this);
        }
    }

    @Override
    public boolean isFinished() {
        return this.remoteTsBlockedConsumedUp();
    }

    private synchronized boolean remoteTsBlockedConsumedUp() {
        return this.currSequenceId - 1 == this.lastSequenceId;
    }

    public TEndPoint getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public TFragmentInstanceId getRemoteFragmentInstanceId() {
        return this.remoteFragmentInstanceId.deepCopy();
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return this.localFragmentInstanceId;
    }

    @Override
    public String getLocalPlanNodeId() {
        return this.localPlanNodeId;
    }

    @Override
    public long getBufferRetainedSizeInBytes() {
        return this.bufferRetainedSizeInBytes;
    }

    @Override
    public void setMaxBytesCanReserve(long maxBytesCanReserve) {
        this.maxBytesCanReserve = Math.min(this.maxBytesCanReserve, maxBytesCanReserve);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    private void checkState() {
        if (this.aborted) {
            throw new IllegalStateException("Source handle is aborted.");
        }
        if (this.closed) {
            throw new IllegalStateException("SourceHandle is closed.");
        }
    }

    public String toString() {
        return String.format("Query[%s]-[%s-%s-SourceHandle-%s]", this.localFragmentInstanceId.getQueryId(), this.localFragmentInstanceId.getFragmentId(), this.fullFragmentInstanceId, this.localPlanNodeId);
    }

    public void setRetryIntervalInMs(long retryIntervalInMs) {
        this.retryIntervalInMs = retryIntervalInMs;
    }

    static /* synthetic */ ExecutorService access$900(SourceHandle x0) {
        return x0.executorService;
    }

    static /* synthetic */ Map access$1100(SourceHandle x0) {
        return x0.sequenceIdToTsBlock;
    }

    static /* synthetic */ SettableFuture access$1200(SourceHandle x0) {
        return x0.blocked;
    }

    class SendCloseSinkChannelEventTask
    implements Runnable {
        SendCloseSinkChannelEventTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try (SetThreadName sourceHandleName = new SetThreadName(SourceHandle.this.threadName);){
                LOGGER.debug("[SendCloseSinkChanelEvent] to [ShuffleSinkHandle: {}, index: {}]).", (Object)SourceHandle.this.remoteFragmentInstanceId, (Object)SourceHandle.this.indexOfUpstreamSinkHandle);
                int attempt = 0;
                TCloseSinkChannelEvent closeSinkChannelEvent = new TCloseSinkChannelEvent(SourceHandle.this.remoteFragmentInstanceId, SourceHandle.this.indexOfUpstreamSinkHandle);
                while (attempt < 3) {
                    ++attempt;
                    long startTime = System.nanoTime();
                    try (SyncDataNodeMPPDataExchangeServiceClient client = (SyncDataNodeMPPDataExchangeServiceClient)SourceHandle.this.mppDataExchangeServiceClientManager.borrowClient((Object)SourceHandle.this.remoteEndpoint);){
                        client.onCloseSinkChannelEvent(closeSinkChannelEvent);
                        return;
                    }
                    catch (Throwable e) {
                        LOGGER.warn("[SendCloseSinkChanelEvent] to [ShuffleSinkHandle: {}, index: {}] failed.).", (Object)SourceHandle.this.remoteFragmentInstanceId, (Object)SourceHandle.this.indexOfUpstreamSinkHandle);
                        if (attempt == 3) {
                            SourceHandle sourceHandle = SourceHandle.this;
                            // MONITORENTER : sourceHandle
                            SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, e);
                            // MONITOREXIT : sourceHandle
                        }
                        try {
                            Thread.sleep(SourceHandle.this.retryIntervalInMs);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            SourceHandle sourceHandle = SourceHandle.this;
                            // MONITORENTER : sourceHandle
                            SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, e);
                            // MONITOREXIT : sourceHandle
                        }
                    }
                }
                return;
            }
        }
    }

    class SendAcknowledgeDataBlockEventTask
    implements Runnable {
        private final int startSequenceId;
        private final int endSequenceId;

        public SendAcknowledgeDataBlockEventTask(int startSequenceId, int endSequenceId) {
            this.startSequenceId = startSequenceId;
            this.endSequenceId = endSequenceId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try (SetThreadName sourceHandleName = new SetThreadName(SourceHandle.this.threadName);){
                LOGGER.debug("[SendACKTsBlock] [{}, {}).", (Object)this.startSequenceId, (Object)this.endSequenceId);
                int attempt = 0;
                TAcknowledgeDataBlockEvent acknowledgeDataBlockEvent = new TAcknowledgeDataBlockEvent(SourceHandle.this.remoteFragmentInstanceId, this.startSequenceId, this.endSequenceId, SourceHandle.this.indexOfUpstreamSinkHandle);
                while (attempt < 3) {
                    long startTime;
                    block24: {
                        ++attempt;
                        startTime = System.nanoTime();
                        SyncDataNodeMPPDataExchangeServiceClient client = (SyncDataNodeMPPDataExchangeServiceClient)SourceHandle.this.mppDataExchangeServiceClientManager.borrowClient((Object)SourceHandle.this.remoteEndpoint);
                        try {
                            client.onAcknowledgeDataBlockEvent(acknowledgeDataBlockEvent);
                            if (client == null) break block24;
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    if (client == null) throw throwable;
                                    try {
                                        client.close();
                                        throw throwable;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                catch (Throwable e) {
                                    LOGGER.warn("failed to send ack data block event [{}, {}), attempt times: {}", new Object[]{this.startSequenceId, this.endSequenceId, attempt, e});
                                    if (attempt == 3) {
                                        SourceHandle sourceHandle = SourceHandle.this;
                                        synchronized (sourceHandle) {
                                            SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, e);
                                        }
                                    }
                                    try {
                                        Thread.sleep(SourceHandle.this.retryIntervalInMs);
                                    }
                                    catch (InterruptedException ex) {
                                        Thread.currentThread().interrupt();
                                        SourceHandle sourceHandle = SourceHandle.this;
                                        synchronized (sourceHandle) {
                                            SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, e);
                                        }
                                    }
                                    QUERY_METRICS.recordDataExchangeCost("on_acknowledge_data_block_event_task_caller", System.nanoTime() - startTime);
                                    QUERY_METRICS.recordDataBlockNum("on_acknowledge_data_block_num_caller", this.endSequenceId - this.startSequenceId);
                                    continue;
                                }
                            }
                            catch (Throwable throwable3) {
                                QUERY_METRICS.recordDataExchangeCost("on_acknowledge_data_block_event_task_caller", System.nanoTime() - startTime);
                                QUERY_METRICS.recordDataBlockNum("on_acknowledge_data_block_num_caller", this.endSequenceId - this.startSequenceId);
                                throw throwable3;
                                return;
                            }
                        }
                        client.close();
                    }
                    QUERY_METRICS.recordDataExchangeCost("on_acknowledge_data_block_event_task_caller", System.nanoTime() - startTime);
                    QUERY_METRICS.recordDataBlockNum("on_acknowledge_data_block_num_caller", this.endSequenceId - this.startSequenceId);
                    return;
                }
            }
        }
    }

    class GetDataBlocksTask
    implements Runnable {
        private final int startSequenceId;
        private final int endSequenceId;
        private final long reservedBytes;

        GetDataBlocksTask(int startSequenceId, int endSequenceId, long reservedBytes) {
            Validate.isTrue((startSequenceId >= 0 ? 1 : 0) != 0, (String)("Start sequence ID should be greater than or equal to zero. Start sequence ID: " + startSequenceId), (Object[])new Object[0]);
            this.startSequenceId = startSequenceId;
            Validate.isTrue((endSequenceId > startSequenceId ? 1 : 0) != 0, (String)("End sequence ID should be greater than the start sequence ID. Start sequence ID: " + startSequenceId + ", end sequence ID: " + endSequenceId), (Object[])new Object[0]);
            this.endSequenceId = endSequenceId;
            Validate.isTrue((reservedBytes > 0L ? 1 : 0) != 0, (String)"Reserved bytes should be greater than zero.", (Object[])new Object[0]);
            this.reservedBytes = reservedBytes;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[MONITOR]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable t) {
            SourceHandle sourceHandle = SourceHandle.this;
            synchronized (sourceHandle) {
                if (SourceHandle.this.aborted || SourceHandle.this.closed) {
                    return;
                }
                SourceHandle.this.bufferRetainedSizeInBytes -= this.reservedBytes;
                SourceHandle.this.localMemoryManager.getQueryPool().free(SourceHandle.this.localFragmentInstanceId.getQueryId(), SourceHandle.this.fullFragmentInstanceId, SourceHandle.this.localPlanNodeId, this.reservedBytes);
                SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, t);
            }
        }
    }
}

