/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.join.merge;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.component.SortKey;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class MergeSortComparator {
    public static final Comparator<MergeSortKey> ASC_TIME_ASC_DEVICE = (o1, o2) -> {
        int timeComparing = Long.compare(o1.tsBlock.getTimeByIndex(o1.rowIndex), o2.tsBlock.getTimeByIndex(o2.rowIndex));
        return timeComparing == 0 ? o1.tsBlock.getColumn(0).getBinary(o1.rowIndex).compareTo(o2.tsBlock.getColumn(0).getBinary(o2.rowIndex)) : timeComparing;
    };
    public static final Comparator<MergeSortKey> ASC_TIME_DESC_DEVICE = (o1, o2) -> {
        int timeComparing = Long.compare(o1.tsBlock.getTimeByIndex(o1.rowIndex), o2.tsBlock.getTimeByIndex(o2.rowIndex));
        return timeComparing == 0 ? o2.tsBlock.getColumn(0).getBinary(o2.rowIndex).compareTo(o1.tsBlock.getColumn(0).getBinary(o1.rowIndex)) : timeComparing;
    };
    public static final Comparator<MergeSortKey> DESC_TIME_ASC_DEVICE = (o1, o2) -> {
        int timeComparing = Long.compare(o2.tsBlock.getTimeByIndex(o2.rowIndex), o1.tsBlock.getTimeByIndex(o1.rowIndex));
        return timeComparing == 0 ? o1.tsBlock.getColumn(0).getBinary(o1.rowIndex).compareTo(o2.tsBlock.getColumn(0).getBinary(o2.rowIndex)) : timeComparing;
    };
    public static final Comparator<MergeSortKey> DESC_TIME_DESC_DEVICE = (o1, o2) -> {
        int timeComparing = Long.compare(o2.tsBlock.getTimeByIndex(o2.rowIndex), o1.tsBlock.getTimeByIndex(o1.rowIndex));
        return timeComparing == 0 ? o2.tsBlock.getColumn(0).getBinary(o2.rowIndex).compareTo(o1.tsBlock.getColumn(0).getBinary(o1.rowIndex)) : timeComparing;
    };
    public static final Comparator<MergeSortKey> ASC_DEVICE_ASC_TIME = (o1, o2) -> {
        int deviceComparing = o1.tsBlock.getColumn(0).getBinary(o1.rowIndex).compareTo(o2.tsBlock.getColumn(0).getBinary(o2.rowIndex));
        return deviceComparing == 0 ? Long.compare(o1.tsBlock.getTimeByIndex(o1.rowIndex), o2.tsBlock.getTimeByIndex(o2.rowIndex)) : deviceComparing;
    };
    public static final Comparator<MergeSortKey> ASC_DEVICE_DESC_TIME = (o1, o2) -> {
        int deviceComparing = o1.tsBlock.getColumn(0).getBinary(o1.rowIndex).compareTo(o2.tsBlock.getColumn(0).getBinary(o2.rowIndex));
        return deviceComparing == 0 ? Long.compare(o2.tsBlock.getTimeByIndex(o2.rowIndex), o1.tsBlock.getTimeByIndex(o1.rowIndex)) : deviceComparing;
    };
    public static final Comparator<MergeSortKey> DESC_DEVICE_ASC_TIME = (o1, o2) -> {
        int deviceComparing = o2.tsBlock.getColumn(0).getBinary(o2.rowIndex).compareTo(o1.tsBlock.getColumn(0).getBinary(o1.rowIndex));
        return deviceComparing == 0 ? Long.compare(o1.tsBlock.getTimeByIndex(o1.rowIndex), o2.tsBlock.getTimeByIndex(o2.rowIndex)) : deviceComparing;
    };
    public static final Comparator<MergeSortKey> DESC_DEVICE_DESC_TIME = (o1, o2) -> {
        int deviceComparing = o2.tsBlock.getColumn(0).getBinary(o2.rowIndex).compareTo(o1.tsBlock.getColumn(0).getBinary(o1.rowIndex));
        return deviceComparing == 0 ? Long.compare(o2.tsBlock.getTimeByIndex(o2.rowIndex), o1.tsBlock.getTimeByIndex(o1.rowIndex)) : deviceComparing;
    };

    public static Comparator<MergeSortKey> getComparator(List<SortItem> sortItemList, List<Integer> indexList, List<TSDataType> dataTypeList) {
        if (sortItemList.size() == 2 && (sortItemList.get(0).getSortKey() == SortKey.TIME && sortItemList.get(1).getSortKey() == SortKey.DEVICE || sortItemList.get(0).getSortKey() == SortKey.DEVICE && sortItemList.get(1).getSortKey() == SortKey.TIME)) {
            if (sortItemList.get(0).getOrdering() == Ordering.ASC) {
                if (sortItemList.get(1).getOrdering() == Ordering.ASC) {
                    if (sortItemList.get(0).getSortKey() == SortKey.TIME) {
                        return ASC_TIME_ASC_DEVICE;
                    }
                    return ASC_DEVICE_ASC_TIME;
                }
                if (sortItemList.get(0).getSortKey() == SortKey.TIME) {
                    return ASC_TIME_DESC_DEVICE;
                }
                return ASC_DEVICE_DESC_TIME;
            }
            if (sortItemList.get(1).getOrdering() == Ordering.ASC) {
                if (sortItemList.get(0).getSortKey() == SortKey.TIME) {
                    return DESC_TIME_ASC_DEVICE;
                }
                return DESC_DEVICE_ASC_TIME;
            }
            if (sortItemList.get(0).getSortKey() == SortKey.TIME) {
                return DESC_TIME_DESC_DEVICE;
            }
            return DESC_DEVICE_DESC_TIME;
        }
        return MergeSortComparator.genComparatorChain(sortItemList, indexList, dataTypeList);
    }

    private static ComparatorChain<MergeSortKey> genComparatorChain(List<SortItem> sortItemList, List<Integer> indexList, List<TSDataType> dataTypeList) {
        ArrayList<Comparator<MergeSortKey>> list = new ArrayList<Comparator<MergeSortKey>>(indexList.size());
        for (int i = 0; i < indexList.size(); ++i) {
            int index = indexList.get(i);
            TSDataType dataType = dataTypeList.get(i);
            boolean asc = sortItemList.get(i).getOrdering() == Ordering.ASC;
            list.add(MergeSortComparator.genSingleComparator(asc, index, dataType));
        }
        return new ComparatorChain(list);
    }

    private static Comparator<MergeSortKey> genSingleComparator(boolean asc, int index, TSDataType dataType) {
        Comparator<MergeSortKey> comparator;
        switch (dataType) {
            case INT32: {
                comparator = Comparator.comparingInt(sortKey -> sortKey.tsBlock.getColumn(index).getInt(sortKey.rowIndex));
                break;
            }
            case INT64: {
                if (index == -1) {
                    comparator = Comparator.comparingLong(sortKey -> sortKey.tsBlock.getTimeByIndex(sortKey.rowIndex));
                    break;
                }
                comparator = Comparator.comparingLong(sortKey -> sortKey.tsBlock.getColumn(index).getLong(sortKey.rowIndex));
                break;
            }
            case FLOAT: {
                comparator = Comparator.comparingDouble(sortKey -> sortKey.tsBlock.getColumn(index).getFloat(sortKey.rowIndex));
                break;
            }
            case DOUBLE: {
                comparator = Comparator.comparingDouble(sortKey -> sortKey.tsBlock.getColumn(index).getDouble(sortKey.rowIndex));
                break;
            }
            case TEXT: {
                comparator = Comparator.comparing(sortKey -> sortKey.tsBlock.getColumn(index).getBinary(sortKey.rowIndex));
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type: " + dataType + " cannot be ordered");
            }
        }
        if (!asc) {
            comparator = comparator.reversed();
        }
        return comparator;
    }
}

