/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.InExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;

public class ExpressionUtils {
    public static List<Expression> reconstructTimeSeriesOperands(List<? extends PartialPath> actualPaths) {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        for (PartialPath partialPath : actualPaths) {
            resultExpressions.add(new TimeSeriesOperand(partialPath));
        }
        return resultExpressions;
    }

    public static Expression reconstructTimeSeriesOperand(PartialPath actualPath) {
        return new TimeSeriesOperand(actualPath);
    }

    public static List<Expression> reconstructFunctionExpressions(FunctionExpression expression, List<List<Expression>> childExpressionsList) {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        for (List<Expression> functionExpressions : childExpressionsList) {
            resultExpressions.add(new FunctionExpression(expression.getFunctionName(), expression.getFunctionAttributes(), functionExpressions));
        }
        return resultExpressions;
    }

    public static Expression reconstructFunctionExpression(FunctionExpression expression, List<Expression> childExpressions) {
        return new FunctionExpression(expression.getFunctionName(), expression.getFunctionAttributes(), childExpressions);
    }

    public static List<Expression> reconstructUnaryExpressions(UnaryExpression expression, List<Expression> childExpressions) {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        block8: for (Expression childExpression : childExpressions) {
            switch (expression.getExpressionType()) {
                case IS_NULL: {
                    resultExpressions.add(new IsNullExpression(childExpression, ((IsNullExpression)expression).isNot()));
                    continue block8;
                }
                case IN: {
                    resultExpressions.add(new InExpression(childExpression, ((InExpression)expression).isNotIn(), ((InExpression)expression).getValues()));
                    continue block8;
                }
                case LIKE: {
                    resultExpressions.add(new LikeExpression(childExpression, ((LikeExpression)expression).getPatternString(), ((LikeExpression)expression).getPattern()));
                    continue block8;
                }
                case LOGIC_NOT: {
                    resultExpressions.add(new LogicNotExpression(childExpression));
                    continue block8;
                }
                case NEGATION: {
                    resultExpressions.add(new NegationExpression(childExpression));
                    continue block8;
                }
                case REGEXP: {
                    resultExpressions.add(new RegularExpression(childExpression, ((RegularExpression)expression).getPatternString(), ((RegularExpression)expression).getPattern()));
                    continue block8;
                }
            }
            throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
        }
        return resultExpressions;
    }

    public static Expression reconstructUnaryExpression(UnaryExpression expression, Expression childExpression) {
        switch (expression.getExpressionType()) {
            case IS_NULL: {
                return new IsNullExpression(childExpression, ((IsNullExpression)expression).isNot());
            }
            case IN: {
                return new InExpression(childExpression, ((InExpression)expression).isNotIn(), ((InExpression)expression).getValues());
            }
            case LIKE: {
                return new LikeExpression(childExpression, ((LikeExpression)expression).getPatternString(), ((LikeExpression)expression).getPattern());
            }
            case LOGIC_NOT: {
                return new LogicNotExpression(childExpression);
            }
            case NEGATION: {
                return new NegationExpression(childExpression);
            }
            case REGEXP: {
                return new RegularExpression(childExpression, ((RegularExpression)expression).getPatternString(), ((RegularExpression)expression).getPattern());
            }
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<Expression> reconstructBinaryExpressions(ExpressionType expressionType, List<Expression> leftExpressions, List<Expression> rightExpressions) {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        for (Expression le : leftExpressions) {
            block16: for (Expression re : rightExpressions) {
                switch (expressionType) {
                    case ADDITION: {
                        resultExpressions.add(new AdditionExpression(le, re));
                        continue block16;
                    }
                    case SUBTRACTION: {
                        resultExpressions.add(new SubtractionExpression(le, re));
                        continue block16;
                    }
                    case MULTIPLICATION: {
                        resultExpressions.add(new MultiplicationExpression(le, re));
                        continue block16;
                    }
                    case DIVISION: {
                        resultExpressions.add(new DivisionExpression(le, re));
                        continue block16;
                    }
                    case MODULO: {
                        resultExpressions.add(new ModuloExpression(le, re));
                        continue block16;
                    }
                    case LESS_THAN: {
                        resultExpressions.add(new LessThanExpression(le, re));
                        continue block16;
                    }
                    case LESS_EQUAL: {
                        resultExpressions.add(new LessEqualExpression(le, re));
                        continue block16;
                    }
                    case GREATER_THAN: {
                        resultExpressions.add(new GreaterThanExpression(le, re));
                        continue block16;
                    }
                    case GREATER_EQUAL: {
                        resultExpressions.add(new GreaterEqualExpression(le, re));
                        continue block16;
                    }
                    case EQUAL_TO: {
                        resultExpressions.add(new EqualToExpression(le, re));
                        continue block16;
                    }
                    case NON_EQUAL: {
                        resultExpressions.add(new NonEqualExpression(le, re));
                        continue block16;
                    }
                    case LOGIC_AND: {
                        resultExpressions.add(new LogicAndExpression(le, re));
                        continue block16;
                    }
                    case LOGIC_OR: {
                        resultExpressions.add(new LogicOrExpression(le, re));
                        continue block16;
                    }
                }
                throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expressionType));
            }
        }
        return resultExpressions;
    }

    public static Expression reconstructBinaryExpression(ExpressionType expressionType, Expression leftExpression, Expression rightExpression) {
        switch (expressionType) {
            case ADDITION: {
                return new AdditionExpression(leftExpression, rightExpression);
            }
            case SUBTRACTION: {
                return new SubtractionExpression(leftExpression, rightExpression);
            }
            case MULTIPLICATION: {
                return new MultiplicationExpression(leftExpression, rightExpression);
            }
            case DIVISION: {
                return new DivisionExpression(leftExpression, rightExpression);
            }
            case MODULO: {
                return new ModuloExpression(leftExpression, rightExpression);
            }
            case LESS_THAN: {
                return new LessThanExpression(leftExpression, rightExpression);
            }
            case LESS_EQUAL: {
                return new LessEqualExpression(leftExpression, rightExpression);
            }
            case GREATER_THAN: {
                return new GreaterThanExpression(leftExpression, rightExpression);
            }
            case GREATER_EQUAL: {
                return new GreaterEqualExpression(leftExpression, rightExpression);
            }
            case EQUAL_TO: {
                return new EqualToExpression(leftExpression, rightExpression);
            }
            case NON_EQUAL: {
                return new NonEqualExpression(leftExpression, rightExpression);
            }
            case LOGIC_AND: {
                return new LogicAndExpression(leftExpression, rightExpression);
            }
            case LOGIC_OR: {
                return new LogicOrExpression(leftExpression, rightExpression);
            }
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expressionType));
    }

    public static List<Expression> reconstructTernaryExpressions(Expression expression, List<Expression> firstExpressions, List<Expression> secondExpressions, List<Expression> thirdExpressions) {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        for (Expression fe : firstExpressions) {
            for (Expression se : secondExpressions) {
                block5: for (Expression te : thirdExpressions) {
                    switch (expression.getExpressionType()) {
                        case BETWEEN: {
                            resultExpressions.add(new BetweenExpression(fe, se, te, ((BetweenExpression)expression).isNotBetween()));
                            continue block5;
                        }
                    }
                    throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
                }
            }
        }
        return resultExpressions;
    }

    public static Expression reconstructTernaryExpression(Expression expression, Expression firstExpression, Expression secondExpression, Expression thirdExpression) {
        switch (expression.getExpressionType()) {
            case BETWEEN: {
                return new BetweenExpression(firstExpression, secondExpression, thirdExpression, ((BetweenExpression)expression).isNotBetween());
            }
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static <T> void cartesianProduct(List<List<T>> dimensionValue, List<List<T>> resultList, int layer, List<T> currentList) {
        block7: {
            block6: {
                if (layer >= dimensionValue.size() - 1) break block6;
                if (dimensionValue.get(layer).isEmpty()) {
                    ExpressionUtils.cartesianProduct(dimensionValue, resultList, layer + 1, currentList);
                } else {
                    for (int i = 0; i < dimensionValue.get(layer).size(); ++i) {
                        ArrayList<T> list = new ArrayList<T>(currentList);
                        list.add(dimensionValue.get(layer).get(i));
                        ExpressionUtils.cartesianProduct(dimensionValue, resultList, layer + 1, list);
                    }
                }
                break block7;
            }
            if (layer != dimensionValue.size() - 1) break block7;
            if (dimensionValue.get(layer).isEmpty()) {
                resultList.add(currentList);
            } else {
                for (int i = 0; i < dimensionValue.get(layer).size(); ++i) {
                    ArrayList<T> list = new ArrayList<T>(currentList);
                    list.add(dimensionValue.get(layer).get(i));
                    resultList.add(list);
                }
            }
        }
    }

    public static Filter constructTimeFilter(ExpressionType expressionType, Expression timeExpression, Expression valueExpression) {
        if (timeExpression instanceof TimestampOperand && valueExpression instanceof ConstantOperand && ((ConstantOperand)valueExpression).getDataType() == TSDataType.INT64) {
            long value = Long.parseLong(((ConstantOperand)valueExpression).getValueString());
            switch (expressionType) {
                case LESS_THAN: {
                    return TimeFilter.lt((long)value);
                }
                case LESS_EQUAL: {
                    return TimeFilter.ltEq((long)value);
                }
                case GREATER_THAN: {
                    return TimeFilter.gt((long)value);
                }
                case GREATER_EQUAL: {
                    return TimeFilter.gtEq((long)value);
                }
                case EQUAL_TO: {
                    return TimeFilter.eq((long)value);
                }
                case NON_EQUAL: {
                    return TimeFilter.notEq((long)value);
                }
            }
            throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expressionType));
        }
        return null;
    }

    public static Pair<Filter, Boolean> getPairFromBetweenTimeFirst(Expression firstExpression, Expression secondExpression, boolean not) {
        if (firstExpression instanceof ConstantOperand && secondExpression instanceof ConstantOperand && ((ConstantOperand)firstExpression).getDataType() == TSDataType.INT64 && ((ConstantOperand)secondExpression).getDataType() == TSDataType.INT64) {
            long value1 = Long.parseLong(((ConstantOperand)firstExpression).getValueString());
            long value2 = Long.parseLong(((ConstantOperand)secondExpression).getValueString());
            return new Pair((Object)(not ? TimeFilter.notBetween((long)value1, (long)value2) : TimeFilter.between((long)value1, (long)value2)), (Object)false);
        }
        return new Pair(null, (Object)true);
    }

    public static Pair<Filter, Boolean> getPairFromBetweenTimeSecond(BetweenExpression predicate, Expression expression) {
        if (predicate.isNotBetween()) {
            return new Pair((Object)TimeFilter.gt((long)Long.parseLong(((ConstantOperand)expression).getValueString())), (Object)false);
        }
        return new Pair((Object)TimeFilter.ltEq((long)Long.parseLong(((ConstantOperand)expression).getValueString())), (Object)false);
    }

    public static Pair<Filter, Boolean> getPairFromBetweenTimeThird(BetweenExpression predicate, Expression expression) {
        if (predicate.isNotBetween()) {
            return new Pair((Object)TimeFilter.lt((long)Long.parseLong(((ConstantOperand)expression).getValueString())), (Object)false);
        }
        return new Pair((Object)TimeFilter.gtEq((long)Long.parseLong(((ConstantOperand)expression).getValueString())), (Object)false);
    }

    public static boolean checkConstantSatisfy(Expression firstExpression, Expression secondExpression) {
        return firstExpression.isConstantOperand() && secondExpression.isConstantOperand() && ((ConstantOperand)firstExpression).getDataType() == TSDataType.INT64 && ((ConstantOperand)secondExpression).getDataType() == TSDataType.INT64 && Long.parseLong(((ConstantOperand)firstExpression).getValueString()) <= Long.parseLong(((ConstantOperand)secondExpression).getValueString());
    }

    public static Expression constructQueryFilter(List<Expression> expressions) {
        if (expressions.size() == 1) {
            return expressions.get(0);
        }
        return ExpressionUtils.constructBinaryFilterTreeWithAnd(expressions);
    }

    private static Expression constructBinaryFilterTreeWithAnd(List<Expression> expressions) {
        if (expressions.size() == 2) {
            return new LogicAndExpression(expressions.get(0), expressions.get(1));
        }
        return new LogicAndExpression(expressions.get(0), ExpressionUtils.constructBinaryFilterTreeWithAnd(expressions.subList(1, expressions.size())));
    }
}

