/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories.strategy;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.utils.JVMCommonUtils;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryStrategy {
    protected static final Logger logger = LoggerFactory.getLogger(DirectoryStrategy.class);
    List<String> folders = new ArrayList<String>();

    public void setFolders(List<String> folders) throws DiskSpaceInsufficientException {
        boolean hasSpace = false;
        for (String folder : folders) {
            if (!JVMCommonUtils.hasSpace((String)folder)) continue;
            hasSpace = true;
            break;
        }
        if (!hasSpace) {
            logger.error("Disk space is insufficient, change system mode to read-only");
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
            throw new DiskSpaceInsufficientException(folders);
        }
        this.folders = folders;
    }

    public abstract int nextFolderIndex() throws DiskSpaceInsufficientException;
}

