/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.settle;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSettleReq;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettleRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(SettleRequestHandler.class);
    private boolean testMode = false;

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public static SettleRequestHandler getInstance() {
        return SettleRequestHandlerHolder.INSTANCE;
    }

    public TSStatus handleSettleRequest(TSettleReq req) {
        List paths = req.getPaths();
        SettleRequestContext context = new SettleRequestContext(paths);
        TSStatus validationResult = context.validate();
        if (validationResult.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return validationResult;
        }
        if (this.testMode) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        List selectedTsFileResources = context.getTsFileResourcesByFileNames();
        return context.submitCompactionTask(selectedTsFileResources);
    }

    private static class SettleRequestHandlerHolder {
        private static final SettleRequestHandler INSTANCE = new SettleRequestHandler();

        private SettleRequestHandlerHolder() {
        }
    }

    private static class ConsistentSettleInfo {
        private int dataRegionId;
        private int level;
        private String storageGroupName;
        private long timePartitionId;
        private boolean isValid;

        private ConsistentSettleInfo() {
        }

        private TSStatus checkConsistency(ConsistentSettleInfo other) {
            if (this.dataRegionId != other.dataRegionId) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PATH, (String)"DataRegion of files is not consistent.");
            }
            if (!this.storageGroupName.equals(other.storageGroupName)) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PATH, (String)"StorageGroup of files is not consistent.");
            }
            if (this.timePartitionId != other.timePartitionId) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PATH, (String)"TimePartition of files is not consistent.");
            }
            if (this.level != other.level) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PARAMETER, (String)"Level of files is not consistent.");
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
    }

    private static class SettleRequestContext {
        private ConsistentSettleInfo targetConsistentSettleInfo;
        private boolean hasSeqFiles;
        private boolean hasUnseqFiles;
        private boolean hasModsFiles;
        private List<String> paths;
        private Set<String> tsFileNames;
        private TsFileResourceList allTsFileResourceList;
        private TsFileManager tsFileManager;
        private IoTDBConfig config;

        private SettleRequestContext(List<String> paths) {
            this.paths = paths;
            this.tsFileNames = new HashSet<String>();
            this.config = IoTDBDescriptor.getInstance().getConfig();
        }

        private TSStatus validate() {
            TSStatus validationResult;
            if (this.paths == null || this.paths.size() == 0) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PARAMETER, (String)"The files to settle is not offered.");
            }
            int maxInnerCompactionCandidateFileNum = this.config.getMaxInnerCompactionCandidateFileNum();
            if (this.paths.size() > maxInnerCompactionCandidateFileNum) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)("Too many files offered, the limited count of system config is " + maxInnerCompactionCandidateFileNum + ", the input file count is " + this.tsFileNames.size()));
            }
            for (String path : this.paths) {
                File currentTsFile = new File(path);
                if (!currentTsFile.exists()) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PATH_NOT_EXIST, (String)("The specified file does not exist in " + path));
                }
                File modsFile = new File(path + ".mods");
                this.hasModsFiles |= modsFile.exists();
                ConsistentSettleInfo currentInfo = this.calculateConsistentInfo(currentTsFile);
                if (!currentInfo.isValid) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PATH, (String)("The File Name of the TsFile is not valid: " + path));
                }
                if (this.targetConsistentSettleInfo == null) {
                    this.targetConsistentSettleInfo = currentInfo;
                }
                if (!this.isSuccess(validationResult = this.targetConsistentSettleInfo.checkConsistency(currentInfo))) {
                    return validationResult;
                }
                if (TsFileUtils.isSequence((File)currentTsFile)) {
                    this.hasSeqFiles = true;
                } else {
                    this.hasUnseqFiles = true;
                }
                this.tsFileNames.add(currentTsFile.getName());
                if (!this.hasSeqFiles || !this.hasUnseqFiles) continue;
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)"Settle by cross compaction is not allowed.");
            }
            if (!this.hasModsFiles) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PARAMETER, (String)"Every selected TsFile does not contains the mods file.");
            }
            DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(this.targetConsistentSettleInfo.dataRegionId));
            if (dataRegion == null) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PATH, (String)"DataRegion not exist");
            }
            this.tsFileManager = dataRegion.getTsFileManager();
            validationResult = this.checkCompactionConfigs();
            if (!this.isSuccess(validationResult)) {
                return validationResult;
            }
            this.allTsFileResourceList = this.hasSeqFiles ? this.tsFileManager.getOrCreateSequenceListByTimePartition(this.targetConsistentSettleInfo.timePartitionId) : this.tsFileManager.getOrCreateUnsequenceListByTimePartition(this.targetConsistentSettleInfo.timePartitionId);
            return this.validateTsFileResources();
        }

        private ConsistentSettleInfo calculateConsistentInfo(File tsFile) {
            TsFileNameGenerator.TsFileName tsFileName;
            ConsistentSettleInfo values = new ConsistentSettleInfo();
            values.dataRegionId = TsFileUtils.getDataRegionId((File)tsFile);
            values.storageGroupName = TsFileUtils.getStorageGroup((File)tsFile);
            values.timePartitionId = TsFileUtils.getTimePartition((File)tsFile);
            values.isValid = true;
            String fileNameStr = tsFile.getName();
            try {
                tsFileName = TsFileNameGenerator.getTsFileName(fileNameStr);
            }
            catch (IOException e) {
                values.isValid = false;
                return values;
            }
            values.level = tsFileName.getInnerCompactionCnt();
            return values;
        }

        private boolean isSuccess(TSStatus status) {
            return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
        }

        private TSStatus checkCompactionConfigs() {
            if (!this.tsFileManager.isAllowCompaction()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)"Compaction in this DataRegion is not allowed.");
            }
            if (this.hasSeqFiles && !this.config.isEnableSeqSpaceCompaction()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)"Compaction in Seq Space is not enabled");
            }
            if (this.hasUnseqFiles && !this.config.isEnableUnseqSpaceCompaction()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)"Compaction in Unseq Space is not enabled");
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }

        private TSStatus validateTsFileResources() {
            int continuousCount = 0;
            for (TsFileResource tsFileResource : this.allTsFileResourceList) {
                File tsFile = tsFileResource.getTsFile();
                if (this.tsFileNames.contains(tsFile.getName())) {
                    if (tsFileResource.getStatus() != TsFileResourceStatus.NORMAL) {
                        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PARAMETER, (String)("The TsFile is not valid: " + tsFile.getAbsolutePath()));
                    }
                    ++continuousCount;
                    continue;
                }
                if (continuousCount == 0) continue;
                break;
            }
            if (continuousCount != this.tsFileNames.size()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PARAMETER, (String)"Selected TsFiles are not continuous.");
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }

        private List<TsFileResource> getTsFileResourcesByFileNames() {
            ArrayList<TsFileResource> selectedTsFileResources = new ArrayList<TsFileResource>(this.tsFileNames.size());
            for (TsFileResource tsFileResource : this.allTsFileResourceList) {
                if (this.tsFileNames.contains(tsFileResource.getTsFile().getName())) {
                    selectedTsFileResources.add(tsFileResource);
                }
                if (selectedTsFileResources.size() != this.tsFileNames.size()) continue;
                break;
            }
            return selectedTsFileResources;
        }

        private TSStatus submitCompactionTask(List<TsFileResource> tsFileResources) {
            ICompactionPerformer performer = this.hasSeqFiles ? this.config.getInnerSeqCompactionPerformer().createInstance() : this.config.getInnerUnseqCompactionPerformer().createInstance();
            InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(this.targetConsistentSettleInfo.timePartitionId, this.tsFileManager, tsFileResources, this.hasSeqFiles, performer, CompactionTaskManager.currentTaskNum, this.tsFileManager.getNextCompactionTaskId());
            try {
                CompactionTaskManager.getInstance().addTaskToWaitingQueue(task);
            }
            catch (InterruptedException e) {
                logger.error("meet error when adding task-{} to compaction waiting queue: {}", (Object)task.getSerialId(), (Object)e.getMessage());
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.COMPACTION_ERROR, (String)"meet error when submit settle task.");
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
    }
}

