/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.AlignedTimeseriesException;
import org.apache.iotdb.db.exception.metadata.MNodeTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.MeasurementInBlackListException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.template.DifferentTemplateException;
import org.apache.iotdb.db.exception.metadata.template.TemplateImcompatibeException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mtree.IMTreeBelowSG;
import org.apache.iotdb.db.metadata.mtree.store.CachedMTreeStore;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.Traverser;
import org.apache.iotdb.db.metadata.mtree.traverser.TraverserWithLimitOffsetWrapper;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.EntityCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MeasurementCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.EntityCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MeasurementCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.updater.EntityUpdater;
import org.apache.iotdb.db.metadata.mtree.traverser.updater.MeasurementUpdater;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowDevicesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowNodesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.result.ShowDevicesResult;
import org.apache.iotdb.db.metadata.plan.schemaregion.result.ShowNodesResult;
import org.apache.iotdb.db.metadata.query.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.metadata.query.info.INodeSchemaInfo;
import org.apache.iotdb.db.metadata.query.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.metadata.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.utils.MetaFormatUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTreeBelowSGCachedImpl
implements IMTreeBelowSG {
    private static final Logger logger = LoggerFactory.getLogger(MTreeBelowSGCachedImpl.class);
    private final CachedMTreeStore store;
    private volatile IStorageGroupMNode storageGroupMNode;
    private final IMNode rootNode;
    private final Function<IMeasurementMNode, Map<String, String>> tagGetter;
    private final int levelOfSG;
    private final CachedSchemaRegionStatistics regionStatistics;

    public MTreeBelowSGCachedImpl(PartialPath storageGroupPath, Function<IMeasurementMNode, Map<String, String>> tagGetter, Runnable flushCallback, final Consumer<IMeasurementMNode> measurementProcess, final Consumer<IEntityMNode> deviceProcess, int schemaRegionId, CachedSchemaRegionStatistics regionStatistics) throws MetadataException, IOException {
        this.tagGetter = tagGetter;
        this.regionStatistics = regionStatistics;
        this.store = new CachedMTreeStore(storageGroupPath, schemaRegionId, regionStatistics, flushCallback);
        this.storageGroupMNode = this.store.getRoot().getAsStorageGroupMNode();
        this.storageGroupMNode.setParent(this.storageGroupMNode.getParent());
        this.rootNode = this.store.generatePrefix(storageGroupPath);
        this.levelOfSG = storageGroupPath.getNodeLength() - 1;
        try (MNodeCollector<Void> collector = new MNodeCollector<Void>(this.rootNode, new PartialPath(this.storageGroupMNode.getFullPath()), (IMTreeStore)this.store, true){

            @Override
            protected Void collectMNode(IMNode node) {
                if (node.isMeasurement()) {
                    measurementProcess.accept(node.getAsMeasurementMNode());
                } else if (node.isEntity()) {
                    deviceProcess.accept(node.getAsEntityMNode());
                }
                return null;
            }
        };){
            collector.traverse();
        }
    }

    private MTreeBelowSGCachedImpl(PartialPath storageGroupPath, CachedMTreeStore store, final Consumer<IMeasurementMNode> measurementProcess, final Consumer<IEntityMNode> deviceProcess, Function<IMeasurementMNode, Map<String, String>> tagGetter, CachedSchemaRegionStatistics regionStatistics) throws MetadataException {
        this.store = store;
        this.regionStatistics = regionStatistics;
        this.storageGroupMNode = store.getRoot().getAsStorageGroupMNode();
        this.rootNode = store.generatePrefix(storageGroupPath);
        this.levelOfSG = this.storageGroupMNode.getPartialPath().getNodeLength() - 1;
        this.tagGetter = tagGetter;
        try (MNodeCollector<Void> collector = new MNodeCollector<Void>(this.rootNode, new PartialPath(this.storageGroupMNode.getFullPath()), (IMTreeStore)this.store, true){

            @Override
            protected Void collectMNode(IMNode node) {
                if (node.isMeasurement()) {
                    measurementProcess.accept(node.getAsMeasurementMNode());
                } else if (node.isEntity()) {
                    deviceProcess.accept(node.getAsEntityMNode());
                }
                return null;
            }
        };){
            collector.traverse();
        }
    }

    @Override
    public void clear() {
        this.store.clear();
        this.storageGroupMNode = null;
    }

    protected void replaceStorageGroupMNode(IStorageGroupMNode newMNode) {
        this.storageGroupMNode.getParent().replaceChild(this.storageGroupMNode.getName(), newMNode);
        this.storageGroupMNode = newMNode;
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        return this.store.createSnapshot(snapshotDir);
    }

    public static MTreeBelowSGCachedImpl loadFromSnapshot(File snapshotDir, String storageGroupFullPath, int schemaRegionId, CachedSchemaRegionStatistics regionStatistics, Consumer<IMeasurementMNode> measurementProcess, Consumer<IEntityMNode> deviceProcess, Function<IMeasurementMNode, Map<String, String>> tagGetter, Runnable flushCallback) throws IOException, MetadataException {
        return new MTreeBelowSGCachedImpl(new PartialPath(storageGroupFullPath), CachedMTreeStore.loadFromSnapshot(snapshotDir, storageGroupFullPath, schemaRegionId, regionStatistics, flushCallback), measurementProcess, deviceProcess, tagGetter, regionStatistics);
    }

    @Override
    public IMeasurementMNode createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        IMeasurementMNode measurementMNode = this.createTimeseriesWithPinnedReturn(path, dataType, encoding, compressor, props, alias);
        this.unPinMNode(measurementMNode);
        return measurementMNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode createTimeseriesWithPinnedReturn(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2) {
            throw new IllegalPathException(path.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(path);
        PartialPath devicePath = path.getDevicePath();
        IMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        try {
            MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                IMeasurementMNode iMeasurementMNode;
                IMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
                try {
                    IEntityMNode entityMNode;
                    MetaFormatUtils.checkTimeseriesProps(path.getFullPath(), props);
                    String leafName = path.getMeasurement();
                    if (alias != null && this.store.hasChild(device, alias)) {
                        throw new AliasAlreadyExistException(path.getFullPath(), alias);
                    }
                    if (this.store.hasChild(device, leafName)) {
                        throw new PathAlreadyExistException(path.getFullPath());
                    }
                    if (device.isEntity() && device.getAsEntityMNode().isAligned()) {
                        throw new AlignedTimeseriesException("timeseries under this entity is aligned, please use createAlignedTimeseries or change entity.", device.getFullPath());
                    }
                    if (device.isEntity()) {
                        entityMNode = device.getAsEntityMNode();
                    } else {
                        entityMNode = this.store.setToEntity(device);
                        if (entityMNode.isStorageGroup()) {
                            this.replaceStorageGroupMNode(entityMNode.getAsStorageGroupMNode());
                        }
                        device = entityMNode;
                    }
                    IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(entityMNode, leafName, (IMeasurementSchema)new MeasurementSchema(leafName, dataType, encoding, compressor, props), alias);
                    this.store.addChild(entityMNode, leafName, measurementMNode);
                    if (alias != null) {
                        entityMNode.addAlias(alias, measurementMNode);
                    }
                    iMeasurementMNode = measurementMNode;
                    this.unPinMNode(device);
                }
                catch (Throwable throwable) {
                    this.unPinMNode(device);
                    throw throwable;
                }
                return iMeasurementMNode;
            }
        }
        finally {
            if (deviceParent != null) {
                this.unPinMNode(deviceParent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMeasurementMNode> createAlignedTimeseries(PartialPath devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList) throws MetadataException {
        ArrayList<IMeasurementMNode> measurementMNodeList = new ArrayList<IMeasurementMNode>();
        MetaFormatUtils.checkSchemaMeasurementNames(measurements);
        IMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        try {
            MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                ArrayList<IMeasurementMNode> arrayList;
                IMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
                try {
                    IEntityMNode entityMNode;
                    for (int i = 0; i < measurements.size(); ++i) {
                        if (this.store.hasChild(device, measurements.get(i))) {
                            throw new PathAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i));
                        }
                        if (aliasList == null || aliasList.get(i) == null || !this.store.hasChild(device, aliasList.get(i))) continue;
                        throw new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), aliasList.get(i));
                    }
                    if (device.isEntity() && !device.getAsEntityMNode().isAligned()) {
                        throw new AlignedTimeseriesException("Timeseries under this entity is not aligned, please use createTimeseries or change entity.", devicePath.getFullPath());
                    }
                    if (device.isEntity()) {
                        entityMNode = device.getAsEntityMNode();
                    } else {
                        entityMNode = this.store.setToEntity(device);
                        entityMNode.setAligned(true);
                        if (entityMNode.isStorageGroup()) {
                            this.replaceStorageGroupMNode(entityMNode.getAsStorageGroupMNode());
                        }
                        device = entityMNode;
                    }
                    for (int i = 0; i < measurements.size(); ++i) {
                        IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(entityMNode, measurements.get(i), (IMeasurementSchema)new MeasurementSchema(measurements.get(i), dataTypes.get(i), encodings.get(i), compressors.get(i)), aliasList == null ? null : aliasList.get(i));
                        this.store.addChild(entityMNode, measurements.get(i), measurementMNode);
                        if (aliasList != null && aliasList.get(i) != null) {
                            entityMNode.addAlias(aliasList.get(i), measurementMNode);
                        }
                        measurementMNodeList.add(measurementMNode);
                    }
                    arrayList = measurementMNodeList;
                    this.unPinMNode(device);
                }
                catch (Throwable throwable) {
                    this.unPinMNode(device);
                    throw throwable;
                }
                return arrayList;
            }
        }
        finally {
            if (deviceParent != null) {
                this.unPinMNode(deviceParent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath devicePath, List<String> measurementList, List<String> aliasList) {
        IMNode device;
        try {
            device = this.getNodeByPath(devicePath);
        }
        catch (MetadataException e) {
            return Collections.emptyMap();
        }
        try {
            if (!device.isEntity()) {
                Map<Integer, MetadataException> e = Collections.emptyMap();
                return e;
            }
            HashMap<Integer, MetadataException> failingMeasurementMap = new HashMap<Integer, MetadataException>();
            for (int i = 0; i < measurementList.size(); ++i) {
                IMNode node = null;
                try {
                    node = this.store.getChild(device, measurementList.get(i));
                    if (node != null) {
                        if (node.isMeasurement()) {
                            if (node.getAsMeasurementMNode().isPreDeleted()) {
                                failingMeasurementMap.put(i, new MeasurementInBlackListException(devicePath.concatNode(measurementList.get(i))));
                            } else {
                                failingMeasurementMap.put(i, new MeasurementAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), node.getAsMeasurementMNode().getMeasurementPath()));
                            }
                        } else {
                            failingMeasurementMap.put(i, new PathAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i)));
                        }
                    }
                    if (aliasList != null && aliasList.get(i) != null && this.store.hasChild(device, aliasList.get(i))) {
                        failingMeasurementMap.put(i, new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), aliasList.get(i)));
                    }
                    if (node == null) continue;
                    this.unPinMNode(node);
                    continue;
                }
                catch (MetadataException e) {
                    try {
                        failingMeasurementMap.put(i, e);
                        if (node == null) continue;
                        this.unPinMNode(node);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (node != null) {
                            this.unPinMNode(node);
                        }
                        throw throwable;
                    }
                }
            }
            HashMap<Integer, MetadataException> hashMap = failingMeasurementMap;
            return hashMap;
        }
        finally {
            this.unPinMNode(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMNode checkAndAutoCreateInternalPath(PartialPath devicePath) throws MetadataException {
        String[] nodeNames = devicePath.getNodes();
        MetaFormatUtils.checkTimeseries(devicePath);
        if (nodeNames.length == this.levelOfSG + 1) {
            return null;
        }
        IMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodeNames.length - 1; ++i) {
                String childName = nodeNames[i];
                IMNode child = this.store.getChild(cur, childName);
                if (child == null) {
                    child = this.store.addChild(cur, childName, new InternalMNode(cur, childName));
                }
                if (!(cur = child).isMeasurement()) continue;
                throw new PathAlreadyExistException(cur.getFullPath());
            }
            this.pinMNode(cur);
            IStorageGroupMNode iStorageGroupMNode = cur;
            return iStorageGroupMNode;
        }
        finally {
            this.unPinPath(cur);
        }
    }

    private IMNode checkAndAutoCreateDeviceNode(String deviceName, IMNode deviceParent) throws MetadataException {
        if (deviceParent == null) {
            this.pinMNode(this.storageGroupMNode);
            return this.storageGroupMNode;
        }
        IMNode device = this.store.getChild(deviceParent, deviceName);
        if (device == null) {
            device = this.store.addChild(deviceParent, deviceName, new InternalMNode(deviceParent, deviceName));
        }
        if (device.isMeasurement()) {
            throw new PathAlreadyExistException(device.getFullPath());
        }
        return device;
    }

    @Override
    public IMeasurementMNode deleteTimeseries(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMeasurementMNode deletedNode = this.getMeasurementMNode(path);
        IEntityMNode parent = deletedNode.getParent();
        this.store.deleteChild(parent, path.getMeasurement());
        if (deletedNode.getAlias() != null) {
            parent.deleteAliasChild(deletedNode.getAlias());
        }
        this.deleteAndUnpinEmptyInternalMNode(parent);
        return deletedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAndUnpinEmptyInternalMNode(IEntityMNode entityMNode) throws MetadataException {
        IMNode curNode = entityMNode;
        if (!entityMNode.isUseTemplate()) {
            boolean hasMeasurement = false;
            try (IMNodeIterator iterator = this.store.getChildrenIterator(entityMNode);){
                while (iterator.hasNext()) {
                    IMNode child = (IMNode)iterator.next();
                    this.unPinMNode(child);
                    if (!child.isMeasurement()) continue;
                    hasMeasurement = true;
                    break;
                }
            }
            if (!hasMeasurement) {
                MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
                synchronized (mTreeBelowSGCachedImpl) {
                    curNode = this.store.setToInternal(entityMNode);
                    if (curNode.isStorageGroup()) {
                        this.replaceStorageGroupMNode(curNode.getAsStorageGroupMNode());
                    }
                }
            }
        }
        while (this.isEmptyInternalMNode(curNode)) {
            if (curNode.isStorageGroup()) {
                return;
            }
            this.store.deleteChild(curNode.getParent(), curNode.getName());
            curNode = curNode.getParent();
        }
        this.unPinMNode(curNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmptyInternalMNode(IMNode node) throws MetadataException {
        try (IMNodeIterator iterator = this.store.getChildrenIterator(node);){
            boolean bl = !"root".equals(node.getName()) && !node.isMeasurement() && !node.isUseTemplate() && !iterator.hasNext();
            return bl;
        }
    }

    @Override
    public List<PartialPath> constructSchemaBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater updater = new MeasurementUpdater(this.rootNode, pathPattern, this.store, false){

            @Override
            protected void updateMeasurement(IMeasurementMNode node) throws MetadataException {
                node.setPreDeleted(true);
                this.store.updateMNode(node);
                result.add(this.getPartialPathFromRootToNode(node));
            }
        };){
            updater.update();
        }
        return result;
    }

    @Override
    public List<PartialPath> rollbackSchemaBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater updater = new MeasurementUpdater(this.rootNode, pathPattern, this.store, false){

            @Override
            protected void updateMeasurement(IMeasurementMNode node) throws MetadataException {
                node.setPreDeleted(false);
                this.store.updateMNode(node);
                result.add(this.getPartialPathFromRootToNode(node));
            }
        };){
            updater.update();
        }
        return result;
    }

    @Override
    public List<PartialPath> getPreDeletedTimeseries(PartialPath pathPattern) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (MeasurementCollector<Void> collector = new MeasurementCollector<Void>(this.rootNode, pathPattern, (IMTreeStore)this.store, false){

            @Override
            protected Void collectMeasurement(IMeasurementMNode node) {
                if (node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode(node));
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    @Override
    public Set<PartialPath> getDevicesOfPreDeletedTimeseries(PartialPath pathPattern) throws MetadataException {
        final HashSet<PartialPath> result = new HashSet<PartialPath>();
        try (MeasurementCollector<Void> collector = new MeasurementCollector<Void>(this.rootNode, pathPattern, (IMTreeStore)this.store, false){

            @Override
            protected Void collectMeasurement(IMeasurementMNode node) {
                if (node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode(node).getDevicePath());
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    @Override
    public void setAlias(IMeasurementMNode measurementMNode, String alias) throws MetadataException {
        this.store.setAlias(measurementMNode, alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode getDeviceNodeWithAutoCreating(PartialPath deviceId) throws MetadataException {
        String[] nodeNames = deviceId.getNodes();
        MetaFormatUtils.checkTimeseries(deviceId);
        IMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
                IMNode child = this.store.getChild(cur, nodeNames[i]);
                if (child == null) {
                    child = this.store.addChild(cur, nodeNames[i], new InternalMNode(cur, nodeNames[i]));
                }
                cur = child;
            }
            this.pinMNode(cur);
            IStorageGroupMNode iStorageGroupMNode = cur;
            return iStorageGroupMNode;
        }
        finally {
            this.unPinPath(cur);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkDeviceNodeExists(PartialPath deviceId) {
        IMNode deviceMNode = null;
        try {
            deviceMNode = this.getNodeByPath(deviceId);
            boolean bl = deviceMNode.isEntity();
            return bl;
        }
        catch (MetadataException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (deviceMNode != null) {
                this.unPinMNode(deviceMNode);
            }
        }
    }

    @Override
    public List<MeasurementPath> fetchSchema(PartialPath pathPattern, Map<Integer, Template> templateMap, final boolean withTags) throws MetadataException {
        final LinkedList<MeasurementPath> result = new LinkedList<MeasurementPath>();
        try (MeasurementCollector<Void> collector = new MeasurementCollector<Void>(this.rootNode, pathPattern, (IMTreeStore)this.store, false){

            @Override
            protected Void collectMeasurement(IMeasurementMNode node) {
                if (node.isPreDeleted()) {
                    return null;
                }
                MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                if (this.nodes[this.nodes.length - 1].equals(node.getAlias())) {
                    path.setMeasurementAlias(node.getAlias());
                }
                if (withTags) {
                    path.setTagMap((Map)MTreeBelowSGCachedImpl.this.tagGetter.apply(node));
                }
                result.add(path);
                return null;
            }
        };){
            collector.setTemplateMap(templateMap);
            collector.traverse();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode getNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        IMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
                IMNode next = this.store.getChild(cur, nodes[i]);
                if (next == null) {
                    throw new PathNotExistException(path.getFullPath(), true);
                }
                if (next.isMeasurement()) {
                    if (i == nodes.length - 1) {
                        IMNode iMNode = next;
                        return iMNode;
                    }
                    throw new PathNotExistException(path.getFullPath(), true);
                }
                cur = next;
            }
            this.pinMNode(cur);
            IStorageGroupMNode iStorageGroupMNode = cur;
            return iStorageGroupMNode;
        }
        finally {
            this.unPinPath(cur);
        }
    }

    @Override
    public IMeasurementMNode getMeasurementMNode(PartialPath path) throws MetadataException {
        IMNode node = this.getNodeByPath(path);
        if (node.isMeasurement()) {
            return node.getAsMeasurementMNode();
        }
        this.unPinMNode(node);
        throw new MNodeTypeMismatchException(path.getFullPath(), 2);
    }

    @Override
    public long countAllMeasurement() throws MetadataException {
        try (MeasurementCounter measurementCounter = new MeasurementCounter(this.rootNode, MetadataConstant.ALL_MATCH_PATTERN, this.store, false);){
            long l = measurementCounter.count();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateTemplate(PartialPath activatePath, Template template) throws MetadataException {
        String[] nodes = activatePath.getNodes();
        IMNode cur = this.storageGroupMNode;
        try {
            IEntityMNode entityMNode;
            for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
                IMNode child = this.store.getChild(cur, nodes[i]);
                if (child == null) {
                    throw new PathNotExistException(activatePath.getFullPath());
                }
                cur = child;
            }
            MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                for (String measurement : template.getSchemaMap().keySet()) {
                    if (!this.store.hasChild(cur, measurement)) continue;
                    throw new TemplateImcompatibeException(activatePath.concatNode(measurement).getFullPath(), template.getName());
                }
                if (cur.isUseTemplate()) {
                    if (template.getId() == cur.getSchemaTemplateId()) {
                        throw new TemplateIsInUseException(cur.getFullPath());
                    }
                    throw new DifferentTemplateException(activatePath.getFullPath(), template.getName());
                }
                if (cur.isEntity()) {
                    entityMNode = cur.getAsEntityMNode();
                } else {
                    entityMNode = this.store.setToEntity(cur);
                    if (entityMNode.isStorageGroup()) {
                        this.replaceStorageGroupMNode(entityMNode.getAsStorageGroupMNode());
                    }
                }
            }
            if (!entityMNode.isAligned()) {
                entityMNode.setAligned(template.isDirectAligned());
            }
            entityMNode.setUseTemplate(true);
            entityMNode.setSchemaTemplateId(template.getId());
            this.store.updateMNode(entityMNode);
            this.regionStatistics.activateTemplate(template.getId());
        }
        finally {
            this.unPinPath(cur);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateTemplateWithoutCheck(PartialPath activatePath, int templateId, boolean isAligned) throws MetadataException {
        String[] nodes = activatePath.getNodes();
        IMNode cur = this.storageGroupMNode;
        try {
            IEntityMNode entityMNode;
            for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
                IMNode child = this.store.getChild(cur, nodes[i]);
                if (child == null) {
                    throw new PathNotExistException(activatePath.getFullPath());
                }
                cur = child;
            }
            if (cur.isEntity()) {
                entityMNode = cur.getAsEntityMNode();
            } else {
                entityMNode = this.store.setToEntity(cur);
                if (entityMNode.isStorageGroup()) {
                    this.replaceStorageGroupMNode(entityMNode.getAsStorageGroupMNode());
                }
            }
            if (!entityMNode.isAligned()) {
                entityMNode.setAligned(isAligned);
            }
            entityMNode.setUseTemplate(true);
            entityMNode.setSchemaTemplateId(templateId);
            this.store.updateMNode(entityMNode);
            this.regionStatistics.activateTemplate(templateId);
        }
        finally {
            this.unPinPath(cur);
        }
    }

    @Override
    public Map<PartialPath, List<Integer>> constructSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater updater = new EntityUpdater(this.rootNode, entry.getKey(), this.store, false){

                @Override
                protected void updateEntity(IEntityMNode node) throws MetadataException {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId())) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.preDeactivateTemplate();
                        this.store.updateMNode(node);
                    }
                }
            };){
                updater.update();
            }
        }
        return resultTemplateSetInfo;
    }

    @Override
    public Map<PartialPath, List<Integer>> rollbackSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater updater = new EntityUpdater(this.rootNode, entry.getKey(), this.store, false){

                @Override
                protected void updateEntity(IEntityMNode node) throws MetadataException {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.rollbackPreDeactivateTemplate();
                        this.store.updateMNode(node);
                    }
                }
            };){
                updater.update();
            }
        }
        return resultTemplateSetInfo;
    }

    @Override
    public Map<PartialPath, List<Integer>> deactivateTemplateInBlackList(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater collector = new EntityUpdater(this.rootNode, entry.getKey(), this.store, false){

                @Override
                protected void updateEntity(IEntityMNode node) throws MetadataException {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        MTreeBelowSGCachedImpl.this.regionStatistics.deactivateTemplate(node.getSchemaTemplateId());
                        node.deactivateTemplate();
                        this.store.updateMNode(node);
                    }
                }
            };){
                collector.traverse();
            }
        }
        for (PartialPath path : resultTemplateSetInfo.keySet()) {
            this.deleteAndUnpinEmptyInternalMNode(this.getNodeByPath(path).getAsEntityMNode());
        }
        return resultTemplateSetInfo;
    }

    @Override
    public long countPathsUsingTemplate(PartialPath pathPattern, int templateId) throws MetadataException {
        try (EntityCounter counter = new EntityCounter(this.rootNode, pathPattern, this.store, false);){
            counter.setSchemaTemplateFilter(templateId);
            long l = counter.count();
            return l;
        }
    }

    public void pinMNode(IMNode node) throws MetadataException {
        this.store.pin(node);
    }

    public void unPinMNode(IMNode node) {
        this.store.unPin(node);
    }

    private void unPinPath(IMNode node) {
        this.store.unPinPath(node);
    }

    public void updateMNode(IMNode node) throws MetadataException {
        this.store.updateMNode(node);
    }

    public ISchemaReader<IDeviceSchemaInfo> getDeviceReader(IShowDevicesPlan showDevicesPlan) throws MetadataException {
        EntityCollector<IDeviceSchemaInfo> collector = new EntityCollector<IDeviceSchemaInfo>(this.rootNode, showDevicesPlan.getPath(), (IMTreeStore)this.store, showDevicesPlan.isPrefixMatch()){

            @Override
            protected IDeviceSchemaInfo collectEntity(IEntityMNode node) {
                PartialPath device = this.getPartialPathFromRootToNode(node);
                return new ShowDevicesResult(device.getFullPath(), node.isAligned());
            }
        };
        if (showDevicesPlan.usingSchemaTemplate()) {
            collector.setSchemaTemplateFilter(showDevicesPlan.getSchemaTemplateId());
        }
        final TraverserWithLimitOffsetWrapper<IDeviceSchemaInfo> traverser = new TraverserWithLimitOffsetWrapper<IDeviceSchemaInfo>(collector, showDevicesPlan.getLimit(), showDevicesPlan.getOffset());
        return new ISchemaReader<IDeviceSchemaInfo>(){

            @Override
            public boolean isSuccess() {
                return traverser.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return traverser.getFailure();
            }

            @Override
            public void close() {
                traverser.close();
            }

            @Override
            public boolean hasNext() {
                return traverser.hasNext();
            }

            @Override
            public IDeviceSchemaInfo next() {
                return (IDeviceSchemaInfo)traverser.next();
            }
        };
    }

    public ISchemaReader<ITimeSeriesSchemaInfo> getTimeSeriesReader(IShowTimeSeriesPlan showTimeSeriesPlan, final Function<Long, Pair<Map<String, String>, Map<String, String>>> tagAndAttributeProvider) throws MetadataException {
        MeasurementCollector<ITimeSeriesSchemaInfo> collector = new MeasurementCollector<ITimeSeriesSchemaInfo>(this.rootNode, showTimeSeriesPlan.getPath(), (IMTreeStore)this.store, showTimeSeriesPlan.isPrefixMatch()){

            @Override
            protected ITimeSeriesSchemaInfo collectMeasurement(final IMeasurementMNode node) {
                return new ITimeSeriesSchemaInfo(){
                    private Pair<Map<String, String>, Map<String, String>> tagAndAttribute = null;

                    @Override
                    public String getAlias() {
                        return node.getAlias();
                    }

                    @Override
                    public MeasurementSchema getSchema() {
                        return (MeasurementSchema)node.getSchema();
                    }

                    @Override
                    public Map<String, String> getTags() {
                        if (this.tagAndAttribute == null) {
                            this.tagAndAttribute = (Pair)tagAndAttributeProvider.apply(node.getOffset());
                        }
                        return (Map)this.tagAndAttribute.left;
                    }

                    @Override
                    public Map<String, String> getAttributes() {
                        if (this.tagAndAttribute == null) {
                            this.tagAndAttribute = (Pair)tagAndAttributeProvider.apply(node.getOffset());
                        }
                        return (Map)this.tagAndAttribute.right;
                    }

                    @Override
                    public boolean isUnderAlignedDevice() {
                        return ((IMNode)this.getParentOfNextMatchedNode()).getAsEntityMNode().isAligned();
                    }

                    @Override
                    public String getFullPath() {
                        return this.getPartialPathFromRootToNode(node).getFullPath();
                    }

                    @Override
                    public PartialPath getPartialPath() {
                        return this.getPartialPathFromRootToNode(node);
                    }
                };
            }
        };
        collector.setTemplateMap(showTimeSeriesPlan.getRelatedTemplate());
        final Traverser traverser = showTimeSeriesPlan.getLimit() > 0L || showTimeSeriesPlan.getOffset() > 0L ? new TraverserWithLimitOffsetWrapper<ITimeSeriesSchemaInfo>(collector, showTimeSeriesPlan.getLimit(), showTimeSeriesPlan.getOffset()) : collector;
        return new ISchemaReader<ITimeSeriesSchemaInfo>(){

            @Override
            public boolean isSuccess() {
                return traverser.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return traverser.getFailure();
            }

            @Override
            public void close() {
                traverser.close();
            }

            @Override
            public boolean hasNext() {
                return traverser.hasNext();
            }

            @Override
            public ITimeSeriesSchemaInfo next() {
                return (ITimeSeriesSchemaInfo)traverser.next();
            }
        };
    }

    public ISchemaReader<INodeSchemaInfo> getNodeReader(IShowNodesPlan showNodesPlan) throws MetadataException {
        final MNodeCollector<INodeSchemaInfo> collector = new MNodeCollector<INodeSchemaInfo>(this.rootNode, showNodesPlan.getPath(), (IMTreeStore)this.store, showNodesPlan.isPrefixMatch()){

            @Override
            protected INodeSchemaInfo collectMNode(IMNode node) {
                return new ShowNodesResult(this.getPartialPathFromRootToNode(node).getFullPath(), node.getMNodeType(false));
            }
        };
        collector.setTargetLevel(showNodesPlan.getLevel());
        return new ISchemaReader<INodeSchemaInfo>(){

            @Override
            public boolean isSuccess() {
                return collector.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return collector.getFailure();
            }

            @Override
            public void close() {
                collector.close();
            }

            @Override
            public boolean hasNext() {
                return collector.hasNext();
            }

            @Override
            public INodeSchemaInfo next() {
                return (INodeSchemaInfo)collector.next();
            }
        };
    }
}

