/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.basic;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.Traverser;

public abstract class DatabaseTraverser<R>
extends Traverser<R> {
    protected boolean collectInternal = false;

    public DatabaseTraverser(IMNode startNode, PartialPath path, IMTreeStore store, boolean isPrefixMatch) throws MetadataException {
        super(startNode, path, store, isPrefixMatch);
    }

    protected boolean mayTargetNodeType(IMNode node) {
        return this.collectInternal || node.isStorageGroup();
    }

    protected boolean acceptFullMatchedNode(IMNode node) {
        return node.isStorageGroup();
    }

    protected boolean acceptInternalMatchedNode(IMNode node) {
        return this.collectInternal && node.isStorageGroup();
    }

    protected boolean shouldVisitSubtreeOfFullMatchedNode(IMNode node) {
        return !node.isStorageGroup();
    }

    protected boolean shouldVisitSubtreeOfInternalMatchedNode(IMNode node) {
        return !node.isStorageGroup();
    }

    public void setCollectInternal(boolean collectInternal) {
        this.collectInternal = collectInternal;
    }
}

