/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.utils.SerializedSize;

public class WALMetaData
implements SerializedSize {
    private static final int FIXED_SERIALIZED_SIZE = 12;
    private long firstSearchIndex;
    private final List<Integer> buffersSize;

    public WALMetaData() {
        this(-1L, new ArrayList<Integer>());
    }

    public WALMetaData(long firstSearchIndex, List<Integer> buffersSize) {
        this.firstSearchIndex = firstSearchIndex;
        this.buffersSize = buffersSize;
    }

    public void add(int size, long searchIndex) {
        if (this.buffersSize.isEmpty()) {
            this.firstSearchIndex = searchIndex;
        }
        this.buffersSize.add(size);
    }

    public void addAll(WALMetaData metaData) {
        if (this.buffersSize.isEmpty()) {
            this.firstSearchIndex = metaData.getFirstSearchIndex();
        }
        this.buffersSize.addAll(metaData.getBuffersSize());
    }

    @Override
    public int serializedSize() {
        return 12 + this.buffersSize.size() * 4;
    }

    public void serialize(ByteBuffer buffer) {
        buffer.putLong(this.firstSearchIndex);
        buffer.putInt(this.buffersSize.size());
        for (int size : this.buffersSize) {
            buffer.putInt(size);
        }
    }

    public static WALMetaData deserialize(ByteBuffer buffer) {
        long firstSearchIndex = buffer.getLong();
        int entriesNum = buffer.getInt();
        ArrayList<Integer> buffersSize = new ArrayList<Integer>(entriesNum);
        for (int i = 0; i < entriesNum; ++i) {
            buffersSize.add(buffer.getInt());
        }
        return new WALMetaData(firstSearchIndex, buffersSize);
    }

    public List<Integer> getBuffersSize() {
        return this.buffersSize;
    }

    public long getFirstSearchIndex() {
        return this.firstSearchIndex;
    }
}

