/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.mem.iterator;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.db.metadata.mnode.utils.MNodeUtils;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.template.Template;

public abstract class AbstractTraverserIterator<N extends IMNode<N>>
implements IMNodeIterator<N> {
    private final IMNodeIterator<N> directChildrenIterator;
    private Iterator<N> templateChildrenIterator;
    protected N nextMatchedNode;
    protected boolean usingDirectChildrenIterator = true;
    private boolean skipPreDeletedSchema = false;

    protected AbstractTraverserIterator(IMTreeStore<N> store, IDeviceMNode<N> parent, Map<Integer, Template> templateMap, IMNodeFactory<N> nodeFactory) throws MetadataException {
        Template template;
        this.directChildrenIterator = store.getChildrenIterator(parent.getAsMNode());
        if (templateMap != null && parent.isUseTemplate() && (template = this.getActivatedSchemaTemplate(parent, templateMap)) != null) {
            this.templateChildrenIterator = MNodeUtils.getChildren(template, nodeFactory);
        }
    }

    public void setSkipPreDeletedSchema(boolean skipPreDeletedSchema) {
        this.skipPreDeletedSchema = skipPreDeletedSchema;
    }

    private Template getActivatedSchemaTemplate(IDeviceMNode<N> node, Map<Integer, Template> templateMap) {
        if (node.getSchemaTemplateId() != -1) {
            if (this.skipPreDeletedSchema && node.getAsDeviceMNode().isPreDeactivateTemplate()) {
                return null;
            }
            return templateMap.get(node.getSchemaTemplateId());
        }
        throw new IllegalStateException(String.format("There should be a template mounted on any ancestor of the node [%s] usingTemplate.", node.getFullPath()));
    }

    public boolean hasNext() {
        while (this.nextMatchedNode == null) {
            if (this.directChildrenIterator.hasNext()) {
                this.nextMatchedNode = (IMNode)this.directChildrenIterator.next();
                this.usingDirectChildrenIterator = true;
            } else if (this.templateChildrenIterator != null && this.templateChildrenIterator.hasNext()) {
                this.nextMatchedNode = (IMNode)this.templateChildrenIterator.next();
                this.usingDirectChildrenIterator = false;
            } else {
                return false;
            }
            if (!this.skipPreDeletedSchema || !this.nextMatchedNode.isMeasurement() || !this.nextMatchedNode.getAsMeasurementMNode().isPreDeleted()) continue;
            this.nextMatchedNode = null;
        }
        return true;
    }

    public N next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        N result = this.nextMatchedNode;
        this.nextMatchedNode = null;
        return result;
    }

    public void close() {
        this.directChildrenIterator.close();
        this.templateChildrenIterator = null;
    }
}

