/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.multi.builtin.helper;

import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.multi.builtin.BuiltInScalarFunctionHelper;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.unary.scalar.DiffFunctionColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.scalar.DiffFunctionTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.type.TypeFactory;

public class DiffFunctionHelper
implements BuiltInScalarFunctionHelper {
    @Override
    public void checkBuiltInScalarFunctionInputDataType(TSDataType tsDataType) throws SemanticException {
        if (tsDataType.isNumeric()) {
            return;
        }
        throw new SemanticException("Input series of Scalar function [DIFF] only supports numeric data types [INT32, INT64, FLOAT, DOUBLE]");
    }

    @Override
    public TSDataType getBuiltInScalarFunctionReturnType(FunctionExpression functionExpression) {
        return TSDataType.DOUBLE;
    }

    @Override
    public ColumnTransformer getBuiltInScalarFunctionColumnTransformer(FunctionExpression expression, ColumnTransformer columnTransformer) {
        return new DiffFunctionColumnTransformer(TypeFactory.getType((TSDataType)TSDataType.DOUBLE), columnTransformer, Boolean.parseBoolean(expression.getFunctionAttributes().getOrDefault("ignoreNull", "true")));
    }

    @Override
    public Transformer getBuiltInScalarFunctionTransformer(FunctionExpression expression, LayerPointReader layerPointReader) {
        return new DiffFunctionTransformer(layerPointReader, Boolean.parseBoolean(expression.getFunctionAttributes().getOrDefault("ignoreNull", "true")));
    }
}

