/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.visitor.cartesian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.metadata.view.viewExpression.visitor.TransformToExpressionVisitor;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.CompleteMeasurementSchemaVisitor;
import org.apache.iotdb.db.mpp.plan.expression.visitor.cartesian.CartesianProductVisitor;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class BindSchemaForExpressionVisitor
extends CartesianProductVisitor<ISchemaTree> {
    @Override
    public List<Expression> visitFunctionExpression(FunctionExpression functionExpression, ISchemaTree schemaTree) {
        ArrayList<List<Expression>> extendedExpressions = new ArrayList<List<Expression>>();
        for (Expression originExpression : functionExpression.getExpressions()) {
            List actualExpressions = (List)this.process(originExpression, schemaTree);
            if (actualExpressions.isEmpty()) {
                return Collections.emptyList();
            }
            extendedExpressions.add(actualExpressions);
            if (!functionExpression.isBuiltInAggregationFunctionExpression()) continue;
            List<Expression> children = functionExpression.getExpressions();
            TypeInferenceUtils.bindTypeForAggregationNonSeriesInputExpressions(functionExpression.getFunctionName(), children, extendedExpressions);
            break;
        }
        ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
        ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
        return ExpressionUtils.reconstructFunctionExpressions(functionExpression, childExpressionsList);
    }

    @Override
    public List<Expression> visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, ISchemaTree schemaTree) {
        PartialPath timeSeriesOperandPath = timeSeriesOperand.getPath();
        List actualPaths = (List)schemaTree.searchMeasurementPaths((PartialPath)timeSeriesOperandPath).left;
        ArrayList<MeasurementPath> nonViewActualPaths = new ArrayList<MeasurementPath>();
        ArrayList<MeasurementPath> viewPaths = new ArrayList<MeasurementPath>();
        for (MeasurementPath measurementPath : actualPaths) {
            if (measurementPath.getMeasurementSchema().isLogicalView()) {
                viewPaths.add(measurementPath);
                continue;
            }
            nonViewActualPaths.add(measurementPath);
        }
        List<Expression> reconstructTimeSeriesOperands = ExpressionUtils.reconstructTimeSeriesOperands(timeSeriesOperand, nonViewActualPaths);
        for (MeasurementPath measurementPath : viewPaths) {
            Expression replacedExpression = BindSchemaForExpressionVisitor.transformViewPath(measurementPath, schemaTree);
            replacedExpression.setViewPath((PartialPath)measurementPath);
            reconstructTimeSeriesOperands.add(replacedExpression);
        }
        return reconstructTimeSeriesOperands;
    }

    @Override
    public List<Expression> visitTimeStampOperand(TimestampOperand timestampOperand, ISchemaTree schemaTree) {
        return Collections.singletonList(timestampOperand);
    }

    @Override
    public List<Expression> visitConstantOperand(ConstantOperand constantOperand, ISchemaTree schemaTree) {
        return Collections.singletonList(constantOperand);
    }

    public static Expression transformViewPath(MeasurementPath measurementPath, ISchemaTree schemaTree) {
        IMeasurementSchema measurementSchema = measurementPath.getMeasurementSchema();
        if (measurementSchema.isLogicalView()) {
            ViewExpression viewExpression = ((LogicalViewSchema)measurementSchema).getExpression();
            Expression expression = new TransformToExpressionVisitor().process(viewExpression, null);
            expression = new CompleteMeasurementSchemaVisitor().process(expression, schemaTree);
            return expression;
        }
        throw new RuntimeException(new UnsupportedOperationException("Can not construct expression using non view path in transformViewPath!"));
    }
}

