/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.metadata.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.ModelTask;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;

public class CreateModelStatement
extends Statement
implements IConfigStatement {
    private String modelId;
    private boolean isAuto;
    private Map<String, String> attributes;
    private QueryStatement queryStatement;

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public boolean isAuto() {
        return this.isAuto;
    }

    public void setAuto(boolean auto) {
        this.isAuto = auto;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public QueryStatement getQueryStatement() {
        return this.queryStatement;
    }

    public void setQueryStatement(QueryStatement queryStatement) {
        this.queryStatement = queryStatement;
    }

    public ModelTask getModelTask() {
        return ModelTask.valueOf((String)this.attributes.get("model_task").toUpperCase());
    }

    public String getModelType() {
        return this.attributes.get("model_type");
    }

    public void semanticCheck() {
        if (!this.attributes.containsKey("model_task")) {
            throw new SemanticException("The attribute `model_task` must be specified.");
        }
        if (!this.attributes.containsKey("model_type")) {
            throw new SemanticException("The attribute `model_type` must be specified.");
        }
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreateModel(this, context);
    }
}

