/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.legacy.loader;

import java.util.Collections;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.pipe.connector.legacy.loader.ILoader;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionLoader
implements ILoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletionLoader.class);
    private final Deletion deletion;

    public DeletionLoader(Deletion deletion) {
        this.deletion = deletion;
    }

    @Override
    public void load() throws PipeException {
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new PipeException("storage engine readonly");
        }
        try {
            Statement statement = this.generateStatement();
            long queryId = SessionManager.getInstance().requestQueryId();
            ExecutionResult result = Coordinator.getInstance().execute(statement, queryId, null, "", PARTITION_FETCHER, SCHEMA_FETCHER, IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.error("Delete {} error, statement: {}.", (Object)this.deletion, (Object)statement);
                LOGGER.error("Delete result status : {}.", (Object)result.status);
                throw new LoadFileException(String.format("Can not execute delete statement: %s", statement));
            }
        }
        catch (Exception e) {
            throw new PipeException(e.getMessage());
        }
    }

    private Statement generateStatement() {
        if (this.deletion.getStartTime() == Long.MIN_VALUE && this.deletion.getEndTime() == Long.MAX_VALUE) {
            return new DeleteTimeSeriesStatement(Collections.singletonList(this.deletion.getPath()));
        }
        DeleteDataStatement statement = new DeleteDataStatement();
        statement.setPathList(Collections.singletonList(this.deletion.getPath()));
        statement.setDeleteStartTime(this.deletion.getStartTime());
        statement.setDeleteEndTime(this.deletion.getEndTime());
        return statement;
    }
}

