/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.v1.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.pipe.connector.IoTDBThriftConnectorRequestVersion;
import org.apache.iotdb.db.pipe.connector.v1.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferFileSealReq
extends TPipeTransferReq {
    private String fileName;
    private long fileLength;

    private PipeTransferFileSealReq() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public static PipeTransferFileSealReq toTPipeTransferReq(String fileName, long fileLength) throws IOException {
        PipeTransferFileSealReq fileSealReq = new PipeTransferFileSealReq();
        fileSealReq.fileName = fileName;
        fileSealReq.fileLength = fileLength;
        fileSealReq.version = IoTDBThriftConnectorRequestVersion.VERSION_1.getVersion();
        fileSealReq.type = PipeRequestType.TRANSFER_FILE_SEAL.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)fileName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)fileLength, (OutputStream)outputStream);
            fileSealReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return fileSealReq;
    }

    public static PipeTransferFileSealReq fromTPipeTransferReq(TPipeTransferReq req) {
        PipeTransferFileSealReq fileSealReq = new PipeTransferFileSealReq();
        fileSealReq.fileName = ReadWriteIOUtils.readString((ByteBuffer)req.body);
        fileSealReq.fileLength = ReadWriteIOUtils.readLong((ByteBuffer)req.body);
        fileSealReq.version = req.version;
        fileSealReq.type = req.type;
        fileSealReq.body = req.body;
        return fileSealReq;
    }
}

