/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.realtime;

import java.util.Map;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.pipe.api.event.Event;

public class PipeRealtimeEvent
extends EnrichedEvent {
    private final EnrichedEvent event;
    private final TsFileEpoch tsFileEpoch;
    private Map<String, String[]> device2Measurements;

    public PipeRealtimeEvent(EnrichedEvent event, TsFileEpoch tsFileEpoch, Map<String, String[]> device2Measurements, String pattern) {
        super(null, pattern);
        this.event = event;
        this.tsFileEpoch = tsFileEpoch;
        this.device2Measurements = device2Measurements;
    }

    public PipeRealtimeEvent(EnrichedEvent event, TsFileEpoch tsFileEpoch, Map<String, String[]> device2Measurements, PipeTaskMeta pipeTaskMeta, String pattern) {
        super(pipeTaskMeta, pattern);
        this.event = event;
        this.tsFileEpoch = tsFileEpoch;
        this.device2Measurements = device2Measurements;
    }

    public Event getEvent() {
        return this.event;
    }

    public TsFileEpoch getTsFileEpoch() {
        return this.tsFileEpoch;
    }

    public Map<String, String[]> getSchemaInfo() {
        return this.device2Measurements;
    }

    public void gcSchemaInfo() {
        this.device2Measurements = null;
    }

    @Override
    public boolean increaseReferenceCount(String holderMessage) {
        return this.event.increaseReferenceCount(holderMessage);
    }

    @Override
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        return this.event.internallyIncreaseResourceReferenceCount(holderMessage);
    }

    @Override
    public boolean decreaseReferenceCount(String holderMessage) {
        return this.event.decreaseReferenceCount(holderMessage);
    }

    @Override
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        return this.event.internallyDecreaseResourceReferenceCount(holderMessage);
    }

    @Override
    public ProgressIndex getProgressIndex() {
        return this.event.getProgressIndex();
    }

    @Override
    public PipeRealtimeEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(PipeTaskMeta pipeTaskMeta, String pattern) {
        return new PipeRealtimeEvent(this.event.shallowCopySelfAndBindPipeTaskMetaForProgressReport(pipeTaskMeta, pattern), this.tsFileEpoch, this.device2Measurements, pipeTaskMeta, pattern);
    }

    public String toString() {
        return "PipeRealtimeEvent{event=" + this.event + ", tsFileEpoch=" + this.tsFileEpoch + ", device2Measurements=" + this.device2Measurements + '}';
    }
}

