/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.connection;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;

public class PipeEventCollector
implements EventCollector {
    private final BoundedBlockingPendingQueue<Event> pendingQueue;
    private final Queue<Event> bufferQueue;

    public PipeEventCollector(BoundedBlockingPendingQueue<Event> pendingQueue) {
        this.pendingQueue = pendingQueue;
        this.bufferQueue = new LinkedList<Event>();
    }

    public synchronized void collect(Event event) {
        if (event instanceof EnrichedEvent) {
            ((EnrichedEvent)event).increaseReferenceCount(PipeEventCollector.class.getName());
        }
        while (!this.bufferQueue.isEmpty()) {
            Event bufferedEvent = this.bufferQueue.peek();
            if (this.pendingQueue.offer(bufferedEvent)) {
                this.bufferQueue.poll();
                continue;
            }
            this.bufferQueue.offer(event);
            return;
        }
        if (!this.pendingQueue.offer(event)) {
            this.bufferQueue.offer(event);
        }
    }
}

