/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.quotas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.engine.StorageEngine;

public class DataNodeSizeStore {
    private final StorageEngine storageEngine = StorageEngine.getInstance();
    private final Map<Integer, Long> dataRegionDisk = new HashMap<Integer, Long>();
    private final ScheduledExecutorService scheduledExecutorService;
    private List<Integer> dataRegionIds = new ArrayList<Integer>();

    public DataNodeSizeStore() {
        this.scheduledExecutorService = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.RESOURCE_CONTROL_DISK_STATISTIC.getName());
        ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.scheduledExecutorService, () -> this.calculateRegionSize(this.dataRegionIds), (long)0L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    public void calculateRegionSize(List<Integer> dataRegionIds) {
        this.storageEngine.getDiskSizeByDataRegion(this.dataRegionDisk, dataRegionIds);
    }

    public Map<Integer, Long> getDataRegionDisk() {
        return this.dataRegionDisk;
    }

    public void setDataRegionIds(List<Integer> dataRegionIds) {
        this.dataRegionIds = dataRegionIds;
    }
}

