/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.reponse.PipeTransferFilePieceResp;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferFilePieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferFileSealReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletInsertionEventHandler;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferTsFileInsertionEventHandler
implements AsyncMethodCallback<TPipeTransferResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTsFileInsertionEventHandler.class);
    private final long requestCommitId;
    private final PipeTsFileInsertionEvent event;
    private final IoTDBThriftAsyncConnector connector;
    private final File tsFile;
    private final int readFileBufferSize;
    private final byte[] readBuffer;
    private long position;
    private final RandomAccessFile reader;
    private final AtomicBoolean isSealSignalSent;
    private AsyncPipeDataTransferServiceClient client;

    public PipeTransferTsFileInsertionEventHandler(long requestCommitId, PipeTsFileInsertionEvent event, IoTDBThriftAsyncConnector connector) throws FileNotFoundException {
        this.requestCommitId = requestCommitId;
        this.event = event;
        this.connector = connector;
        this.tsFile = event.getTsFile();
        this.readFileBufferSize = PipeConfig.getInstance().getPipeConnectorReadFileBufferSize();
        this.readBuffer = new byte[this.readFileBufferSize];
        this.position = 0L;
        this.reader = new RandomAccessFile(this.tsFile, "r");
        this.isSealSignalSent = new AtomicBoolean(false);
        event.increaseReferenceCount(PipeTransferTabletInsertionEventHandler.class.getName());
    }

    public void transfer(AsyncPipeDataTransferServiceClient client) throws TException, IOException {
        this.client = client;
        client.setShouldReturnSelf(false);
        int readLength = this.reader.read(this.readBuffer);
        if (readLength == -1) {
            this.isSealSignalSent.set(true);
            client.pipeTransfer((TPipeTransferReq)PipeTransferFileSealReq.toTPipeTransferReq(this.tsFile.getName(), this.tsFile.length()), (AsyncMethodCallback)this);
            return;
        }
        client.pipeTransfer((TPipeTransferReq)PipeTransferFilePieceReq.toTPipeTransferReq(this.tsFile.getName(), this.position, readLength == this.readFileBufferSize ? this.readBuffer : Arrays.copyOfRange(this.readBuffer, 0, readLength)), (AsyncMethodCallback)this);
        this.position += (long)readLength;
    }

    public void onComplete(TPipeTransferResp response) {
        if (this.isSealSignalSent.get()) {
            if (response.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                this.onError((Exception)((Object)new PipeException(String.format("Seal file %s error, result status %s.", this.tsFile, response.getStatus()))));
                return;
            }
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close file reader when successfully transferred file.", (Throwable)e);
            }
            finally {
                this.connector.commit(this.requestCommitId, this.event);
                LOGGER.info("Successfully transferred file {}. Request commit id is {}.", (Object)this.tsFile, (Object)this.requestCommitId);
                if (this.client != null) {
                    this.client.setShouldReturnSelf(true);
                    this.client.returnSelf();
                }
            }
            return;
        }
        try {
            PipeTransferFilePieceResp resp = PipeTransferFilePieceResp.fromTPipeTransferResp(response);
            long code = resp.getStatus().getCode();
            if (code == (long)TSStatusCode.PIPE_TRANSFER_FILE_OFFSET_RESET.getStatusCode()) {
                this.position = resp.getEndWritingOffset();
                this.reader.seek(this.position);
                LOGGER.info("Redirect file position to {}.", (Object)this.position);
            } else if (code != (long)TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new PipeException(String.format("Transfer file %s error, result status %s.", this.tsFile, resp.getStatus()));
            }
            this.transfer(this.client);
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    public void onError(Exception exception) {
        LOGGER.warn("Failed to transfer tsfile {} (request commit id {}).", new Object[]{this.tsFile, this.requestCommitId, exception});
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close file reader when failed to transfer file.", (Throwable)e);
        }
        finally {
            this.connector.addFailureEventToRetryQueue(this.requestCommitId, this.event);
            if (this.client != null) {
                this.client.setShouldReturnSelf(true);
                this.client.returnSelf();
            }
        }
    }
}

