/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.historical;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.extractor.historical.PipeHistoricalDataRegionExtractor;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHistoricalDataRegionTsFileExtractor
implements PipeHistoricalDataRegionExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHistoricalDataRegionTsFileExtractor.class);
    private PipeTaskMeta pipeTaskMeta;
    private ProgressIndex startIndex;
    private int dataRegionId;
    private String pattern;
    private long historicalDataExtractionStartTime;
    private long historicalDataExtractionEndTime;
    private long historicalDataExtractionTimeLowerBound;
    private Queue<PipeTsFileInsertionEvent> pendingQueue;

    public void validate(PipeParameterValidator validator) {
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) {
        PipeTaskExtractorRuntimeEnvironment environment = (PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.startIndex = environment.getPipeTaskMeta().getProgressIndex();
        this.dataRegionId = environment.getRegionId();
        this.pattern = parameters.getStringOrDefault("extractor.pattern", "root");
        boolean isHistoricalExtractorEnabledByUser = parameters.getBooleanOrDefault("extractor.history.enable", true);
        this.historicalDataExtractionStartTime = isHistoricalExtractorEnabledByUser && parameters.hasAttribute("extractor.history.start-time") ? DateTimeUtils.convertDatetimeStrToLong(parameters.getString("extractor.history.start-time"), ZoneId.systemDefault()) : Long.MIN_VALUE;
        this.historicalDataExtractionEndTime = isHistoricalExtractorEnabledByUser && parameters.hasAttribute("extractor.history.end-time") ? DateTimeUtils.convertDatetimeStrToLong(parameters.getString("extractor.history.end-time"), ZoneId.systemDefault()) : Long.MAX_VALUE;
        long l = this.historicalDataExtractionTimeLowerBound = parameters.getBooleanOrDefault("extractor.history.enable", true) ? Long.MIN_VALUE : environment.getCreationTime();
        if (this.historicalDataExtractionTimeLowerBound != Long.MIN_VALUE) {
            this.flushDataRegionAllTsFiles();
        }
    }

    private void flushDataRegionAllTsFiles() {
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(this.dataRegionId));
        if (dataRegion == null) {
            return;
        }
        dataRegion.writeLock("Pipe: create historical TsFile extractor");
        try {
            dataRegion.syncCloseAllWorkingTsFileProcessors();
        }
        finally {
            dataRegion.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(this.dataRegionId));
        if (dataRegion == null) {
            this.pendingQueue = new ArrayDeque<PipeTsFileInsertionEvent>();
            return;
        }
        dataRegion.writeLock("Pipe: start to extract historical TsFile");
        try {
            dataRegion.syncCloseAllWorkingTsFileProcessors();
            TsFileManager tsFileManager = dataRegion.getTsFileManager();
            tsFileManager.readLock();
            try {
                this.pendingQueue = new ArrayDeque<PipeTsFileInsertionEvent>(tsFileManager.size(true) + tsFileManager.size(false));
                this.pendingQueue.addAll(tsFileManager.getTsFileList(true).stream().filter(resource -> !this.startIndex.isAfter(resource.getMaxProgressIndexAfterClose()) && this.isTsFileResourceOverlappedWithTimeRange((TsFileResource)resource) && this.isTsFileGeneratedAfterExtractionTimeLowerBound((TsFileResource)resource)).map(resource -> new PipeTsFileInsertionEvent((TsFileResource)resource, this.pipeTaskMeta, this.pattern, this.historicalDataExtractionStartTime, this.historicalDataExtractionEndTime)).collect(Collectors.toList()));
                this.pendingQueue.addAll(tsFileManager.getTsFileList(false).stream().filter(resource -> !this.startIndex.isAfter(resource.getMaxProgressIndexAfterClose()) && this.isTsFileResourceOverlappedWithTimeRange((TsFileResource)resource) && this.isTsFileGeneratedAfterExtractionTimeLowerBound((TsFileResource)resource)).map(resource -> new PipeTsFileInsertionEvent((TsFileResource)resource, this.pipeTaskMeta, this.pattern, this.historicalDataExtractionStartTime, this.historicalDataExtractionEndTime)).collect(Collectors.toList()));
                this.pendingQueue.forEach(event -> event.increaseReferenceCount(PipeHistoricalDataRegionTsFileExtractor.class.getName()));
            }
            finally {
                tsFileManager.readUnlock();
            }
        }
        finally {
            dataRegion.writeUnlock();
        }
    }

    private boolean isTsFileResourceOverlappedWithTimeRange(TsFileResource resource) {
        return resource.getFileEndTime() >= this.historicalDataExtractionStartTime && this.historicalDataExtractionEndTime >= resource.getFileStartTime();
    }

    private boolean isTsFileGeneratedAfterExtractionTimeLowerBound(TsFileResource resource) {
        try {
            return this.historicalDataExtractionTimeLowerBound <= TsFileNameGenerator.getTsFileName(resource.getTsFile().getName()).getTime();
        }
        catch (IOException e) {
            LOGGER.warn(String.format("failed to get the generation time of TsFile %s, extract it anyway", resource.getTsFilePath()), (Throwable)e);
            return true;
        }
    }

    public Event supply() {
        if (this.pendingQueue == null) {
            return null;
        }
        return this.pendingQueue.poll();
    }

    @Override
    public synchronized boolean hasConsumedAll() {
        return this.pendingQueue != null && this.pendingQueue.isEmpty();
    }

    public void close() {
        if (this.pendingQueue != null) {
            this.pendingQueue.clear();
            this.pendingQueue = null;
        }
    }
}

