/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime;

import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.db.pipe.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimeDataRegionLogExtractor
extends PipeRealtimeDataRegionExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionLogExtractor.class);
    private final UnboundedBlockingPendingQueue<Event> pendingQueue = new UnboundedBlockingPendingQueue();

    @Override
    public void extract(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TABLET);
        if (!(event.getEvent() instanceof TabletInsertionEvent)) {
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName());
            return;
        }
        if (!this.pendingQueue.waitedOffer(event)) {
            String errorMessage = String.format("extract: pending queue of PipeRealtimeDataRegionLogExtractor %s has reached capacity, discard tablet event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
            LOGGER.error(errorMessage);
            PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName());
        }
    }

    @Override
    public boolean isNeedListenToTsFile() {
        return false;
    }

    @Override
    public boolean isNeedListenToInsertNode() {
        return true;
    }

    public Event supply() {
        PipeRealtimeEvent realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        while (realtimeEvent != null) {
            Event suppliedEvent = null;
            if (realtimeEvent.increaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName())) {
                suppliedEvent = realtimeEvent.getEvent();
            } else {
                String errorMessage = String.format("Tablet Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", realtimeEvent.getEvent());
                LOGGER.error(errorMessage);
                PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            }
            realtimeEvent.decreaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName());
            if (suppliedEvent != null) {
                return suppliedEvent;
            }
            realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.pendingQueue.clear();
    }
}

