/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v1.impl;

import com.google.common.base.Joiner;
import java.time.ZoneId;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.rest.handler.AuthorizationHandler;
import org.apache.iotdb.db.protocol.rest.v1.GrafanaApiService;
import org.apache.iotdb.db.protocol.rest.v1.handler.ExceptionHandler;
import org.apache.iotdb.db.protocol.rest.v1.handler.QueryDataSetHandler;
import org.apache.iotdb.db.protocol.rest.v1.handler.RequestValidationHandler;
import org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.v1.model.ExpressionRequest;
import org.apache.iotdb.db.protocol.rest.v1.model.SQL;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowStatement;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;

public class GrafanaApiServiceImpl
extends GrafanaApiService {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    private final ISchemaFetcher schemaFetcher = ClusterSchemaFetcher.getInstance();
    private final AuthorizationHandler authorizationHandler = new AuthorizationHandler();
    private final long timePrecision;

    public GrafanaApiServiceImpl() {
        switch (CommonDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ns": {
                this.timePrecision = 1000000L;
                break;
            }
            case "us": {
                this.timePrecision = 1000L;
                break;
            }
            default: {
                this.timePrecision = 1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response variables(SQL sql, SecurityContext securityContext) {
        ExecutionResult result;
        Statement statement;
        Long queryId;
        block20: {
            block19: {
                block18: {
                    queryId = null;
                    RequestValidationHandler.validateSQL(sql);
                    statement = StatementGenerator.createStatement(sql.getSql(), ZoneId.systemDefault());
                    if (statement instanceof ShowStatement || statement instanceof QueryStatement) break block18;
                    Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
                    if (queryId != null) {
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return response;
                }
                Response response = this.authorizationHandler.checkAuthority(securityContext, statement);
                if (response == null) break block19;
                Response response2 = response;
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                return response2;
            }
            queryId = SESSION_MANAGER.requestQueryId();
            result = COORDINATOR.execute(statement, queryId, null, sql.getSql(), this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold());
            if (result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) break block20;
            Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response;
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        try {
            Response response = QueryDataSetHandler.fillGrafanaVariablesResult(queryExecution, statement);
            threadName.close();
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response;
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Response response = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
                    return response;
                }
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
            finally {
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Response expression(ExpressionRequest expressionRequest, SecurityContext securityContext) {
        SetThreadName threadName;
        IQueryExecution queryExecution;
        Long queryId;
        block23: {
            ExecutionResult result;
            Statement statement;
            block22: {
                String sql;
                block21: {
                    Response response;
                    queryId = null;
                    RequestValidationHandler.validateExpressionRequest(expressionRequest);
                    String expression = Joiner.on((String)",").join((Iterable)expressionRequest.getExpression());
                    String prefixPaths = Joiner.on((String)",").join((Iterable)expressionRequest.getPrefixPath());
                    long startTime = (long)(expressionRequest.getStartTime().doubleValue() * (double)this.timePrecision);
                    long endTime = (long)(expressionRequest.getEndTime().doubleValue() * (double)this.timePrecision);
                    sql = "select " + expression + " from " + prefixPaths + " where timestamp>=" + startTime + " and timestamp<= " + endTime;
                    if (StringUtils.isNotEmpty((CharSequence)expressionRequest.getCondition())) {
                        sql = sql + " and " + expressionRequest.getCondition();
                    }
                    if (StringUtils.isNotEmpty((CharSequence)expressionRequest.getControl())) {
                        sql = sql + " " + expressionRequest.getControl();
                    }
                    if ((response = this.authorizationHandler.checkAuthority(securityContext, statement = StatementGenerator.createStatement(sql, ZoneId.systemDefault()))) == null) break block21;
                    Response response2 = response;
                    if (queryId != null) {
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return response2;
                }
                queryId = SESSION_MANAGER.requestQueryId();
                result = COORDINATOR.execute(statement, queryId, null, sql, this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold());
                if (result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) break block22;
                Response response2 = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                return response2;
            }
            queryExecution = COORDINATOR.getQueryExecution(queryId);
            threadName = new SetThreadName(result.queryId.getId());
            if (!((QueryStatement)statement).isGroupByLevel()) break block23;
            Response response3 = QueryDataSetHandler.fillAggregationPlanDataSet(queryExecution, 0);
            threadName.close();
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response3;
        }
        Response response4 = QueryDataSetHandler.fillDataSetWithTimestamps(queryExecution, 0, this.timePrecision);
        threadName.close();
        if (queryId != null) {
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return response4;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            threadName.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Response response3 = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
                        return response3;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    if (queryId != null) {
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                }
            }
        }
    }

    public Response login(SecurityContext securityContext) {
        return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name())).build();
    }

    /*
     * Exception decompiling
     */
    public Response node(List<String> requestBody, SecurityContext securityContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

