/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.executor;

import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.queryengine.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.storageengine.dataregion.VirtualDataRegion;
import org.apache.iotdb.db.utils.SetThreadName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionReadExecutor {
    public static final String RESPONSE_NULL_ERROR_MSG = "ReadResponse is null";
    public static final String ERROR_MSG_FORMAT = "Execute FragmentInstance failed: %s";
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionReadExecutor.class);
    private final IConsensus dataRegionConsensus;
    private final IConsensus schemaRegionConsensus;
    private final FragmentInstanceManager fragmentInstanceManager;

    public RegionReadExecutor() {
        this.dataRegionConsensus = DataRegionConsensusImpl.getInstance();
        this.schemaRegionConsensus = SchemaRegionConsensusImpl.getInstance();
        this.fragmentInstanceManager = FragmentInstanceManager.getInstance();
    }

    public RegionReadExecutor(IConsensus dataRegionConsensus, IConsensus schemaRegionConsensus, FragmentInstanceManager fragmentInstanceManager) {
        this.dataRegionConsensus = dataRegionConsensus;
        this.schemaRegionConsensus = schemaRegionConsensus;
        this.fragmentInstanceManager = fragmentInstanceManager;
    }

    public RegionExecutionResult execute(ConsensusGroupId groupId, FragmentInstance fragmentInstance) {
        SetThreadName threadName = new SetThreadName(fragmentInstance.getId().getFullId());
        try {
            ConsensusReadResponse readResponse = groupId instanceof DataRegionId ? this.dataRegionConsensus.read(groupId, (IConsensusRequest)fragmentInstance) : this.schemaRegionConsensus.read(groupId, (IConsensusRequest)fragmentInstance);
            RegionExecutionResult resp = new RegionExecutionResult();
            if (readResponse == null) {
                LOGGER.error(RESPONSE_NULL_ERROR_MSG);
                resp.setAccepted(false);
                resp.setMessage(RESPONSE_NULL_ERROR_MSG);
            } else if (!readResponse.isSuccess()) {
                LOGGER.error("Execute FragmentInstance in ConsensusGroup {} failed.", (Object)groupId, (Object)readResponse.getException());
                resp.setAccepted(false);
                resp.setMessage(String.format(ERROR_MSG_FORMAT, readResponse.getException() == null ? "" : readResponse.getException().getMessage()));
            } else {
                FragmentInstanceInfo info = (FragmentInstanceInfo)readResponse.getDataset();
                resp.setAccepted(!info.getState().isFailed());
                resp.setMessage(info.getMessage());
            }
            RegionExecutionResult regionExecutionResult = resp;
            threadName.close();
            return regionExecutionResult;
        }
        catch (Throwable resp) {
            try {
                try {
                    threadName.close();
                }
                catch (Throwable throwable) {
                    resp.addSuppressed(throwable);
                }
                throw resp;
            }
            catch (Throwable t) {
                LOGGER.error("Execute FragmentInstance in ConsensusGroup {} failed.", (Object)groupId, (Object)t);
                RegionExecutionResult resp2 = new RegionExecutionResult();
                resp2.setAccepted(false);
                resp2.setMessage(String.format(ERROR_MSG_FORMAT, t.getMessage()));
                return resp2;
            }
        }
    }

    public RegionExecutionResult execute(FragmentInstance fragmentInstance) {
        SetThreadName threadName = new SetThreadName(fragmentInstance.getId().getFullId());
        try {
            RegionExecutionResult resp = new RegionExecutionResult();
            FragmentInstanceInfo info = this.fragmentInstanceManager.execDataQueryFragmentInstance(fragmentInstance, VirtualDataRegion.getInstance());
            resp.setAccepted(!info.getState().isFailed());
            resp.setMessage(info.getMessage());
            RegionExecutionResult regionExecutionResult = resp;
            threadName.close();
            return regionExecutionResult;
        }
        catch (Throwable resp) {
            try {
                try {
                    threadName.close();
                }
                catch (Throwable throwable) {
                    resp.addSuppressed(throwable);
                }
                throw resp;
            }
            catch (Throwable t) {
                LOGGER.error("Execute FragmentInstance in QueryExecutor failed.", t);
                RegionExecutionResult resp2 = new RegionExecutionResult();
                resp2.setAccepted(false);
                resp2.setMessage(String.format(ERROR_MSG_FORMAT, t.getMessage()));
                return resp2;
            }
        }
    }
}

