/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.SingleTimeWindowIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.TimeRangeIteratorFactory;
import org.apache.iotdb.db.queryengine.execution.operator.window.TimeWindow;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.statistics.StatisticsManager;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.read.common.block.TsBlockUtil;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.utils.Pair;

public class AggregationUtil {
    private AggregationUtil() {
    }

    public static ITimeRangeIterator initTimeRangeIterator(GroupByTimeParameter groupByTimeParameter, boolean ascending, boolean outputPartialTimeWindow) {
        if (groupByTimeParameter == null) {
            return new SingleTimeWindowIterator(0L, Long.MAX_VALUE);
        }
        return TimeRangeIteratorFactory.getTimeRangeIterator(groupByTimeParameter.getStartTime(), groupByTimeParameter.getEndTime(), groupByTimeParameter.getInterval(), groupByTimeParameter.getSlidingStep(), ascending, groupByTimeParameter.isIntervalByMonth(), groupByTimeParameter.isSlidingStepByMonth(), groupByTimeParameter.isLeftCRightO(), outputPartialTimeWindow);
    }

    public static Pair<Boolean, TsBlock> calculateAggregationFromRawData(TsBlock inputTsBlock, List<Aggregator> aggregators, TimeRange curTimeRange, boolean ascending) {
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return new Pair((Object)false, (Object)inputTsBlock);
        }
        if (AggregationUtil.satisfiedTimeRange(inputTsBlock, curTimeRange, ascending)) {
            if (ascending && inputTsBlock.getStartTime() < curTimeRange.getMin() || !ascending && inputTsBlock.getStartTime() > curTimeRange.getMax()) {
                inputTsBlock = TsBlockUtil.skipPointsOutOfTimeRange((TsBlock)inputTsBlock, (TimeRange)curTimeRange, (boolean)ascending);
            }
            inputTsBlock = AggregationUtil.process(inputTsBlock, curTimeRange, aggregators);
        }
        boolean isTsBlockOutOfBound = inputTsBlock != null && (ascending ? inputTsBlock.getEndTime() > curTimeRange.getMax() : inputTsBlock.getEndTime() < curTimeRange.getMin());
        return new Pair((Object)(AggregationUtil.isAllAggregatorsHasFinalResult(aggregators) || isTsBlockOutOfBound ? 1 : 0), (Object)inputTsBlock);
    }

    private static TsBlock process(TsBlock inputTsBlock, TimeRange curTimeRange, List<Aggregator> aggregators) {
        TimeWindow curWindow = new TimeWindow(curTimeRange);
        TimeColumn timeColumn = inputTsBlock.getTimeColumn();
        int lastIndexToProcess = 0;
        int i = 0;
        while (i < inputTsBlock.getPositionCount() && curWindow.satisfy((Column)timeColumn, i)) {
            lastIndexToProcess = i++;
        }
        for (Aggregator aggregator : aggregators) {
            if (aggregator.hasFinalResult()) continue;
            aggregator.processTsBlock(inputTsBlock, null, lastIndexToProcess);
        }
        int lastReadRowIndex = lastIndexToProcess + 1;
        if (lastReadRowIndex >= inputTsBlock.getPositionCount()) {
            return null;
        }
        return inputTsBlock.subTsBlock(lastReadRowIndex);
    }

    public static void appendAggregationResult(TsBlockBuilder tsBlockBuilder, List<? extends Aggregator> aggregators, long outputTime) {
        TimeColumnBuilder timeColumnBuilder = tsBlockBuilder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(outputTime);
        ColumnBuilder[] columnBuilders = tsBlockBuilder.getValueColumnBuilders();
        int columnIndex = 0;
        for (Aggregator aggregator : aggregators) {
            ColumnBuilder[] columnBuilder = new ColumnBuilder[aggregator.getOutputType().length];
            columnBuilder[0] = columnBuilders[columnIndex++];
            if (columnBuilder.length > 1) {
                columnBuilder[1] = columnBuilders[columnIndex++];
            }
            aggregator.outputResult(columnBuilder);
        }
        tsBlockBuilder.declarePosition();
    }

    public static boolean satisfiedTimeRange(TsBlock tsBlock, TimeRange curTimeRange, boolean ascending) {
        if (tsBlock == null || tsBlock.isEmpty()) {
            return false;
        }
        return ascending ? tsBlock.getEndTime() >= curTimeRange.getMin() && tsBlock.getStartTime() <= curTimeRange.getMax() : tsBlock.getEndTime() <= curTimeRange.getMax() && tsBlock.getStartTime() >= curTimeRange.getMin();
    }

    public static boolean isAllAggregatorsHasFinalResult(List<Aggregator> aggregators) {
        for (Aggregator aggregator : aggregators) {
            if (aggregator.hasFinalResult()) continue;
            return false;
        }
        return true;
    }

    public static long calculateMaxAggregationResultSize(List<? extends AggregationDescriptor> aggregationDescriptors, ITimeRangeIterator timeRangeIterator, TypeProvider typeProvider) {
        long timeValueColumnsSizePerLine = 8L;
        for (AggregationDescriptor aggregationDescriptor : aggregationDescriptors) {
            List outPutDataTypes = aggregationDescriptor.getOutputColumnNames().stream().map(typeProvider::getType).collect(Collectors.toList());
            for (TSDataType tsDataType : outPutDataTypes) {
                timeValueColumnsSizePerLine += AggregationUtil.getOutputColumnSizePerLine(tsDataType);
            }
        }
        return Math.min((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, Math.min((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber(), timeRangeIterator.getTotalIntervalNum()) * timeValueColumnsSizePerLine);
    }

    public static long calculateMaxAggregationResultSizeForLastQuery(List<Aggregator> aggregators) {
        long timeValueColumnsSizePerLine = 8L;
        List outPutDataTypes = aggregators.stream().flatMap(aggregator -> Arrays.stream(aggregator.getOutputType())).collect(Collectors.toList());
        for (TSDataType tsDataType : outPutDataTypes) {
            timeValueColumnsSizePerLine += AggregationUtil.getOutputColumnSizePerLine(tsDataType);
        }
        return timeValueColumnsSizePerLine;
    }

    private static long getOutputColumnSizePerLine(TSDataType tsDataType) {
        switch (tsDataType) {
            case INT32: {
                return 5L;
            }
            case INT64: {
                return 9L;
            }
            case FLOAT: {
                return 5L;
            }
            case DOUBLE: {
                return 9L;
            }
            case BOOLEAN: {
                return 2L;
            }
            case TEXT: {
                return StatisticsManager.getInstance().getMaxBinarySizeInBytes();
            }
        }
        throw new UnsupportedOperationException("Unknown data type " + tsDataType);
    }
}

